;------------------------------------------------------------------------
;                                                                        
; CSRCFG.INC Configuration Include File for DMCSR
;                                                                        
; Last update: 10/25/89
;                                                                        
;------------------------------------------------------------------------

DRIVER_NAME_SIZE   equ 13  ; size of driver names in bytes 

; Printer configuration 
PRINTER_CFG struc
    PRINTER_CFG_bAutoLF       db  ?   ;CR_ONLY or CR_WITH_LF 
    PRINTER_CFG_port          db  ?   ;selected port 
    PRINTER_CFG_driver        db  DRIVER_NAME_SIZE dup (?)   ;driver filename 
    PRINTER_CFG_id            db  ?   ;driver sub-id 
    PRINTER_CFG_cpi           db  ?   ;characters per inch 
    PRINTER_CFG_bPause        db  ?   ;pause between pages flag 
PRINTER_CFG ends



PRT_LPT1    equ 0
PRT_LPT2    equ 1
PRT_LPT3    equ 2

PRT_10_CPI  equ 0
PRT_12_CPI  equ 1
PRT_16_CPI  equ 2

; Mouse 
MOUSE_CFG struc
    MOUSE_CFG_bSelected       db  ?   ;indicates if user wants a mouse 
    MOUSE_CFG_click_speed     db  ?   ;double click timeout value 
    MOUSE_CFG_port            db  ?   ;mouse driver port 
    MOUSE_CFG_driver          db  DRIVER_NAME_SIZE dup (?)   ;filename of the mouse driver 
MOUSE_CFG ends



MS_MAX_CLICK_SPEED  equ 4

MS_COMPORT1 equ 0
MS_COMPORT2 equ 1

; Communications 
CPARMS struc
    CPARMS_bXon               db  ?   ;Xon/Xoff enable flag 
    CPARMS_bASCfilter         db  ?   ;ASCII filter enable flag 
    CPARMS_bLFfilter          db  ?   ;line filter enable flag 
    CPARMS_bStatus            db  ?   ;com port status flag  OPEN or CLOSED  
    CPARMS_bCarrier           db  ?   ;carrier det stat flag  CARRY/NO_CARRY  
    CPARMS_baud_rate          dw  ?   ;line speed setting 
    CPARMS_word_size          db  ?   ;7 or 8 
    CPARMS_parity             db  ?   ;EVEN_PARITY, ODD_PARITY or NO_ PARITY 
    CPARMS_stop_bits          db  ?   ;1 or 2 
CPARMS ends



COM_BUFFER_INFO struc
    COM_BUFFER_INFO_rs232_start_ptr dd  ?
    COM_BUFFER_INFO_rs232_end_ptr dd  ?
    COM_BUFFER_INFO_input_ptr dd  ?
    COM_BUFFER_INFO_output_ptr dd  ?
    COM_BUFFER_INFO_rs232_buf_size dw  ?
    COM_BUFFER_INFO_count_num dw  ?
    COM_BUFFER_INFO_xon_xoff_flag db  ?
COM_BUFFER_INFO ends



COM_STATE struc
    COM_STATE_com_port        db  ?   ;COM1 or COM2 
    COM_STATE_line_type1      db  ?   ;DIRECT or MODEM 
    COM_STATE_modem1          db  ?   ;modem name index 
    COM_STATE_line_type2      db  ?   ;DIRECT or MODEM 
    COM_STATE_modem2          db  ?   ;modem name index 
COM_STATE ends



; Parity settings 
NO_PARITY       equ 0
ODD_PARITY      equ 1
EVEN_PARITY     equ 2

; Port addresses 
COM1            equ 0
COM2            equ 1

; Line types 
MODEM           equ 1           ; modem is attatched to line 
DIRECT          equ 0           ; direct connect line 

; Port status 
PORT_OPEN       equ 1           ; terminal active - dtr and rts 
PORT_CLOSED     equ 0           ; terminal not ready - no dtr or rts 

; Carrier state 
CARRY           equ 1
NO_CARRY        equ 0

; Help Level values 
CFG_NEW_USER          equ 0
CFG_BEGINNING_USER    equ 1
CFG_INTERMEDIATE_USER equ 2
CFG_EXPERT_USER       equ 3

;end of CSRCFG.INC
