/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRPRT.H Printer and Print-To-Device Include File                      */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef CSRPRT_INCLUDED
#define CSRPRT_INCLUDED 1

/* Printer margin */
struct margin_defn
{
    char           left;       /* left margin */
    unsigned char  lnwidth;    /* line width */
    char           linepp;     /* total lines per page */
    char           plinepp;    /* printed lines per page */
};
typedef struct margin_defn MARGIN;

/* Page setup */
struct pgsetup_defn
{
   char     mode;           /* LANDSCAPE,PORTRAIT */
   MARGIN   mNotebk;        /* notebook is no longer supported */
   MARGIN   mLandscp;       /* landscape margin defs */
   MARGIN   mPortrait;      /* portrait margin defns */
   char     bDspace;        /* double space boolean flag */
   char     bPgpause;       /* pause between pages flag */
   char     bScontrol;      /* send control sequences flag */
   char     bGraphic;       /* graphic mode boolean flag */
   char     bText;          /* text mode boolean flag */
};
typedef struct pgsetup_defn PGSETUP;

/* Page setup options */
struct pgopt_defn
{
    unsigned char  max_line_wid;   /* max width */
    char           bMode;          /* mode enable flag */
    char           bLmargin;       /* left margin enable flag */
    char           bLwidth;        /* line width enable flag */
    char           bLinepp;        /* total lines/page enable flag */
    char           bPLinepp;       /* printed lines/page enable flag */
    char           bDspace;        /* set double space flag */
};
typedef struct pgopt_defn PGOPT;

/* Page modes */
struct pgmode_defn
{
    PGOPT   pNotebook;      /* notebook is no longer supported */
    PGOPT   pLandscape;     /* landscape pg setup opts */
    PGOPT   pPortrait;      /* portrait pg setup opts */
};
typedef struct pgmode_defn PGMODE;

/* Printout types */
#define PORTRAIT    0
#define LANDSCAPE   1

struct printer_defn
{
    char            bTextOnly;
    char            bIBMCompat;
    char            bCROnly;
    char            name[12];
    unsigned char   max_columns;
    unsigned char   paper_sizes;
    unsigned char   line_pitches;
    unsigned char   char_pitches;
    unsigned char   char_sets;
    unsigned char   font_styles;
    unsigned char   print_mode;
    unsigned char   bFormFeed;
    unsigned char   unaddr_width;
    unsigned char   unaddr_height;
    unsigned char   orientations;
    unsigned char   font_attrs;
    unsigned char   nColors;
    unsigned int    horz_dpi;
    unsigned int    vert_dpi;
};
typedef struct printer_defn PRINTER;

#define PRT_TEXT_ONLY   SELECTED
#define PRT_GRAPHICS    DESELECTED

#define PRT_IBM         SELECTED
#define PRT_TANDY       DESELECTED

#define CR_ONLY         SELECTED
#define CR_WITH_LF      DESELECTED

#define PRT_A4          0x01
#define PRT_A5          0x02
#define PRT_B5          0x04
#define PRT_LEGAL       0x08
#define PRT_LETTER      0x10
#define PRT_HALF        0x20

#define PRT_3LPI        0x01
#define PRT_6LPI        0x02
#define PRT_8LPI        0x04

#define PRT_10CPI       0x01
#define PRT_12CPI       0x02
#define PRT_16CPI       0x04

#define PRT_CS_TANDY    0x01
#define PRT_CS_ASCII    0x02
#define PRT_CS_IBM1     0x04
#define PRT_CS_IBM2     0x08

#define PRT_STANDARD    0x01
#define PRT_CORRESPOND  0x02

#define PRT_UNIDIRECT   0x01
#define PRT_BIDIRECT    0x02
#define PRT_SHEET       0x04
#define PRT_CONTINUOUS  0x08

#define PRT_PORTRAIT    0x01
#define PRT_LANDSCAPE   0x02

#define PRT_ELONGATED   0x01
#define PRT_DBL_HEIGHT  0x02
#define PRT_SUBSCRIPT   0x04
#define PRT_SUPERSCRIPT 0x08
#define PRT_BOLD        0x10
#define PRT_ITALIC      0x20
#define PRT_UNDERLINE   0x40
#define PRT_OVERSCORE   0x80

/* Print-To-Device */
#define PTD_READY       0
#define PTD_CANCEL      CSR_ERROR
#define PTD_TO_SCREEN   0
#define PTD_TO_PRINTER  1
#define PTD_TO_FILE     2

/* Device flags for ptd_open */
#define PTD_DEVICES     0x07        /* all devices (screen, printer, file) */
#define PTD_SCREEN      0x01        /* mask for screen device */
#define PTD_PRINTER     0x02        /* mask for printer device */
#define PTD_FILE        0x04        /* mask for file device */

/* Character Y extent sizes with printer CPI scales */
#define PRT_10CPI_YEXT  166  /* 166.67 = yext of chars in a 10 cpi draw list */
#define PRT_12CPI_YEXT  200  /* 200.00 = yext of chars in a 12 cpi draw list */
#define PRT_16CPI_YEXT  277  /* 277.77 = yext of chars in a 16 cpi draw list */

#endif

/* end of CSRPRT.H */
