/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRVID.H Video Include File for DMCSR                                  */
/*                                                                        */
/* Last update : 10-16-89                                                 */
/*                                                                        */
/*------------------------------------------------------------------------*/

#ifndef CSRVID_INCLUDED
#define CSRVID_INCLUDED 1

/* Tandy Characters */
#define TC_OPEN_BOX     0x01    /* box outline with a cleared interion */
#define TC_GRAYED_BOX   0x02    /* box outline with a grayed interior */
#define TC_CHECK1       0x03    /* left half of a check mark */
#define TC_CHECK2       0x04    /* right half of a check mark */
#define TC_LARROW1      0x05    /* left half of a left arrow */
#define TC_LARROW2      0x06    /* right half of a left arrow */
#define TC_RARROW1      0x06    /* left half of a right arrow */
#define TC_RARROW2      0x07    /* right half of a right arrow */
#define TC_UARROW1      0x08    /* left half of an up arrow */
#define TC_UARROW2      0x09    /* right half of an up arrow */
#define TC_DARROW1      0x0A    /* left half of a down arrow */
#define TC_DARROW2      0x0B    /* right half of a down arrow */
#define TC_ACCESSORY    0x0C    /* menubar accessory symbol */
#define TC_KERNED_F1    0x0D    /* kerned F1 character in a single character */
#define TC_KERNED_F     0x0E    /* left half of kerned F1-F9 in two chars */
#define TC_KERNED_1     0x0F    /* right half of two character kerned F1 */
#define TC_KERNED_2     0x10    /* right half of two character kerned F2 */
#define TC_KERNED_3     0x11    /* right half of two character kerned F3 */
#define TC_KERNED_4     0x12    /* right half of two character kerned F4 */
#define TC_KERNED_5     0x13    /* right half of two character kerned F5 */
#define TC_KERNED_6     0x14    /* right half of two character kerned F6 */
#define TC_KERNED_7     0x15    /* right half of two character kerned F7 */
#define TC_KERNED_8     0x16    /* right half of two character kerned F8 */
#define TC_KERNED_9     0x17    /* right half of two character kerned F9 */
#define TC_DIAMOND      0x18    /* diamond character */
#define TC_CATEAR1      0x19    /* left half of cat-eared page character */
#define TC_CATEAR2      0x1A    /* right half of cat-eared page character */
#define TC_KERNED_F101  0x1B    /* left half of kerned F10 */
#define TC_KERNED_F102  0x1C    /* right half of kerned F10 */
#define TC_BLANK        0x1F    /* alternate space character */

/* Cursor types */
#define VID_BLOCK_CURSOR    0       /* block cursor */
#define VID_BAR_CURSOR      1       /* insert cursor */
#define VID_LINE_CURSOR     2       /* underline cursor */
#define VID_DEFINED_CURSOR  3       /* definable cursor */
#define VID_NO_FLASH        0x80    /* mask for non-flashing cursor */

/* Character attributes */
#define NORMAL      0x00        /* no special attributes */
#define BOLD        0x01        /* bold (by color or by enbolding) */
#define ITALIC      0x02        /* italic (skewed) */
#define UNDERLINE   0x04        /* underlined */
#define INVERSE     0x08        /* inverse (swap fore & background colors) */
#define GRAYED      0x10        /* grayed (cross hatch shading) */
#define TRANSPARENT 0x20        /* transparent background */

/* Character attribute switches */
#define BOLD_ON         0x13
#define BOLD_OFF        0x12
#define UNDERLINE_ON    0x11
#define UNDERLINE_OFF   0x10
#define ITALIC_ON       0x17
#define ITALIC_OFF      0x16

/* Colors */
#define COLOR_XOR   CSR_ERROR
#define COLOR1      0
#define COLOR2      1
#define COLOR3      2
#define COLOR4      3
#define COLOR5      4
#define COLOR6      5
#define COLOR7      6
#define COLOR8      7
#define COLOR9      8
#define COLOR10     9
#define COLOR11     10
#define COLOR12     11
#define COLOR13     12
#define COLOR14     13
#define COLOR15     14
#define COLOR16     15

/* Line types */
#define LINE_SOLID          0   /* solid lines */
#define LINE_INVISIBLE      1   /* invisible lines */
#define LINE_DOTTED         2   /* dotted lines */
#define LINE_DASHED         3   /* dashed lines */
#define LINE_DOT_DASHED     4   /* dot-dashed lines */
#define LINE_DENSE_DOTTED   5   /* densly dotted lines */
#define LINE_DENSE_DASHED   6   /* densly dashed lines */

#define LINE_INVERTED    0x80   /* inverse (swap fore & background colors) */


/* Line widths */
#define LINE_WIDTH1     0
#define LINE_WIDTH2     1
#define LINE_WIDTH3     2
#define LINE_WIDTH4     3
#define LINE_WIDTH5     4

/* Line brush */
#define LINE_BRUSH1     5
#define LINE_BRUSH2     6
#define LINE_BRUSH3     7
#define LINE_BRUSH4     8
#define LINE_BRUSH5     9
#define LINE_BRUSH6     10
#define LINE_BRUSH7     11
#define LINE_BRUSH8     12
#define LINE_BRUSH9     13
#define LINE_BRUSH10    14
#define LINE_BRUSH11    15
#define LINE_BRUSH12    16
#define LINE_BRUSH13    17
#define LINE_BRUSH14    18
#define LINE_BRUSH15    19
#define LINE_BRUSH16    20
#define LINE_BRUSH17    21
#define LINE_BRUSH18    22

/* Fill flags */
#define VID_FILL        SELECTED
#define VID_NO_FILL     DESELECTED

/* Rectangle beveledness */
#define VID_NO_BEVEL    0
#define VID_BEVEL1      1
#define VID_BEVEL2      2
#define VID_BEVEL3      3

/* Fill pattern types */
#define PATTERN_DEFAULT CSR_ERROR
#define PATTERN_NULL    CSR_DEFAULT     /* transparent fill */
#define PATTERN1        0               /* solid background */
#define PATTERN2        1               /* solid foreground */
#define PATTERN3        2               /* fine checker */
#define PATTERN4        3               /* coarse checker */
#define PATTERN5        4               /* 25% unalligned dots */
#define PATTERN6        5               /* 25% alligned dots */
#define PATTERN7        6               /* random dots */
#define PATTERN8        7               /* vertical stripes */
#define PATTERN9        8               /* horizontal stripes */
#define PATTERN10       9               /* ascending slanted lines */
#define PATTERN11       10              /* descending slanted lines */
#define PATTERN12       11              /* diamonds */
#define PATTERN13       12              /* squares */
#define PATTERN14       13              /* cubes */
#define PATTERN15       14              /* bricks */
#define PATTERN16       15              /* shingles */
#define PATTERN17       16              /* weave */
#define PATTERN18       17              /* epcot */
#define PATTERN19       18              /* curls */
#define PATTERN20       19              /* scales */

/* Video attributes */
struct vid_attrs_defn
{
    char    cursor_enable;      /* ##D DISABLED  cursor enable flag */
    int     cursor_x;           /* ##D 0000H cursor position */
    int     cursor_y;    	/* ##D 0000H */  
    char    cursor_type;        /* ##D VID_BLOCK_CURSOR block cursor type */
    int     cursor_len;         /* VID_LINE_CURSOR only */
    char    cursor_color;       /* VID_LINE_CURSOR only */
    int     cursor_defseg;      /* segment address of defined cursor */
    int     cursor_defptr;      /* offset to defined cursor */
    char    cursor_focal_x;     /* hot spot x of defined cursor */
    char    cursor_focal_y;     /* hot spot y of defined cursor */
    char    char_attr;          /* ##D NORMAL character attributes */
    char    bg_color;           /* ##D COLOR1 background color */
    char    fg_color;           /* ##D COLOR2 foreground color */
    char    line_type;          /* ##D LINE_SOLID line type */
    char    line_width;         /* ##D LINE_WIDTH1 line width */
    char    line_fgnd_color;    /* ##D COLOR4 line color */
    char    pattern;            /* ##D PATTERN2 fill pattern */
    int     char_xext;          /* ##D CHAR_XEXT character x extent */
    int     char_yext;          /* ##D CHAR_YEXT character y extent */
    /* ## NOINC */
    char    line_bgnd_color;    /* line pattern background color */
    char    overrun;            /* extra byte for vid_attr overrun */
    /* ## ENDNOINC */
    /* ## INCONLY
    VID_ATTRS_line_bgnd_color   dw  COLOR3            ;line pattern bg color
    ## ENDINCONLY */
};
typedef struct vid_attrs_defn VID_ATTRS;

/* Video device */
struct vid_device_defn
{
    char    card;       /* video card id */
    int     dc_xorg;    /* device pixel x origin */
    int     dc_yorg;    /* device pixel y origin */
    int     dc_xext;    /* device pixel x extent */
    int     dc_yext;    /* device pixel y extent */
    char    xaspect;    /* x aspect ratio (x:y) */
    char    yaspect;    /* y aspect ratio (x:y) */
};
typedef struct vid_device_defn VID_DEVICE;

/* Video cards */
#define VID_1000    0   /* Tandy 1000 640x200/4.......Better Again! */
#define VID_CGA     1   /* Dual Display Adaptor/CGA 640x200/2 */
#define VID_DDGA    2   /* Dual Display Adaptor/special mode 640x200/16 */
#define VID_EGA     3   /* QuadEGA/EGA+ 640x350/16 */
#define VID_HERC    4   /* Dual Display Adaptor/Hercules 720x348/2 */
#define VID_PLAN    5   /* Dual Display Adaptor/Plantronics 640x200/16 */
#define VID_TC16    6   /* 1988 Tandy 1000TX custom mode 640x200/16 */
#define VID_TC4     7   /* 1988 Tandy 1000TX custom mode 640x400/4 */
#define VID_VGA     8   /* VGA Adaptor 640x450/16 */
#define VID_MCGA    9   /* MCGA Adaptor */
#define VID_EGAM    10  /* Monochrome EGA */

/* added on 02-01-89    */
#define VID_LRES    11  /* Low resolution (cga 40 column) 320x200/4 */
#define VID_T256    12  /* Tandy 256 colors (40 column) 320x200/254 */
#define VID_TC40    13  /* Tandy 40 column driver  320x200/16 */

/* added on 09-22-89    */
#define VID_HERC40	14     /* Hercules 40 column  360x348/3        */
#define VID_EGA40C	15     /* EGA 40 column color 640x350/16       */
#define VID_EGA40M	16     /* EGA 40 column monochrome  640x350/3  */

/* added on 10-9-89     */
#define VID_EGA40C_LORES 17 /*EGA 40 column color low resolution 320x200/16*/

/* Video colors */
struct vid_colors_defn
{
    int     nColors;            /* num of colors to choose from */
    char    nPalettes;          /* number of palettes */
    char    nGunIncs;           /* number of RGB gun increments */
    char    nIntensIncs;        /* number of intensity increments */
    char    first_palette;      /* first assignable palette of device */
};
typedef struct vid_colors_defn VID_COLORS;

struct vid_palette_defn
{
    char    palette;    /* palette index */
    char    red;        /* red color gun intensity */
    char    green;      /* green color gun intensity */
    char    blue;       /* blue color gun intensity */
};
typedef struct vid_palette_defn VID_PALETTE;

/* Buttons */
struct button_defn
{
    int     xorg;           /* world coordinate x origin of button */
    int     yorg;           /* world coordinate y origin of button */
    int     xext;           /* world coordinate x extent of button */
    char    type;           /* button type */
    char    pattern;        /* pattern upon which button is being drawn */
    char    bgnd_color;     /* background color of the button image */
    char    fgnd_color;     /* foreground color of the button image */
    char    string_color;   /* color of the button label string */
    char    *pString;       /* pointer to the button label string */
};
typedef struct button_defn BUTTON;

/* Button masks for type element of the BUTTON structure */
#define BTN_ROUNDED     0x00    /* rounded edges */
#define BTN_SQUARED     0x01    /* squared edges */
#define BTN_RAISED      0x00    /* raise position */
#define BTN_PRESSED     0x02    /* pressed position */
#define BTN_INVERTED    0x04    /* invert button (valid w/ BTN_PRESSED only) */
#define BTN_LEFT_EDGE   0x08    /* left unobstructed (for BTN_SQUARED only) */
#define BTN_RIGHT_EDGE  0x10    /* right unobstructed (for BTN_SQUARED only) */
#define BTN_GRAYED      0x20    /* button is grayed */

/* video swaping structure     02-06-89 */
struct vid_swap_info_defn
{
    /* ## NOINC  */
    char    driver_name[9];   /* holds the driver name */
    /* ## ENDNOINC  */
    /* ## INCONLY
    VID_SWAP_INFO_driver_name       db 'DMVS'
                                    db 0
                                    db 0
                                    db 0
                                    db 0
                                    db 0
    ## ENDINCONLY */
    int     nColumns;         /* number of columns the driver supports */
    int     nColors;          /* number of colors supported */
    int     dc_xext;          /* number of pixels on screen in x-extent */
    int     dc_yext;          /* number of pixels on screen in y-extent */
    int     system_memory;    /* amount of system memory in paragraph used */
    char    card_id;          /* holds the card id, as in the VID_DEVICE struct*/
};
typedef struct vid_swap_info_defn VID_SWAP_INFO;


/* Video Memory  09-26-89 */
struct vid_memory_defn
{
    char card ;            /* video card id */
    long start ;           /* offset of the first free video byte */
    long end ;             /* end offset of block video screen */
    long nKBytes ;         /* number of video memory Kbytes required */
};
typedef struct vid_memory_defn VID_MEMORY ;

#endif

/* end of CSRVID.H */
