/*----------------------------------------------------------------*/
/*                                                                */
/* DMDB.H contains the defines for the function numbers for the   */
/*        database manager.  It is used by the application as     */
/*        well as the DeskMate Database Resources.                */
/*                                                                */
/* Last update: 07/19/89                                          */ 
/*                                                                */
/*----------------------------------------------------------------*/

#ifndef DMDB_INCLUDED
#define DMDB_INCLUDED 1

/* defines for dbmgr main case statement */

#define CREATE_FILE	1
#define OPEN_FILE	2
#define CLOSE_FILE	3

#define CREATE_TABLE	4
#define ALTER_TABLE	5
#define OPEN_TABLE	6

#define ADD_ROW 	7

#define DROP_TABLE	8
#define CLOSE_TABLE	9

#define COUNT_RECORDS	10
#define FIRST_RECORD	11
#define LAST_RECORD	12
#define PREV_RECORD	13
#define NEXT_RECORD	14

#define SETUP_QUERY	15
#define MORE_RECORDS	16
#define FETCH_RECORD	17

#define DELETE_ROW	18
#define UPDATE_ROW	19
#define GET_TABLE_NAMES 20

#define GET_COLUMN_NAMES 21

#define COPY_LAYOUTS	22
#define PACK_TABLE	23

#define DEFINE_INDEX	24

#define GET_PAGE_SETUP	25
#define SAVE_PAGE_SETUP 26

#define DROP_INDEX	27

#define DELETE_MULTI_ROWS 28
#define GET_INDEX_INFO	29

#define MERGE		30

#define GET_MIN 	31
#define GET_MAX 	32

#define GET_COL_INFO	33
#define GET_TBL_HIST	34
#define INIT_TBL_HIST	35
#define TEMP_SORT	36
#define END_TEMP_SORT	37
#define GET_RECORD_LOCATION 38
#define ADD_ROW_NO_FLUSH 39
/* nothing should go between here */

#define DB_PAUSE	50
#define INIT_DB 	51
#define END_DB		52
#define OPEN_FILE_READ_ONLY 55

/* defines for DB_PAUSE */
#define PAUSE_STATUS	0		/* Return the status  */
#define STOP_DB 	1		/* Stop the DBMGR     */
#define START_DB	2		/* Start the DBMGR.   */

/* defines for initialization binding and unbinding */
#define BIND_READ_ONLY	0		/* for 89 app support */
#define BIND_ALL	1		/* for server/88 network app support */
#define BIND_UPDATE	2		/* bind update resource */
#define BIND_BUILD	3		/* bind build and update resources */
#define BIND_NETWK	4		/* bind network resource */
#define READ_ONLY	5		/* parameter to db_bind_read */
#define READ_WRITE	6		/* parameter to db_bind_read */

#define MAX_REC_SIZE	1020  /* PG_SIZE - TOKEN_OVERHEAD - RECORD_OVERHEAD */
#define ER_TKN	0x02		/* end of record token */
#define KS_TKN	0x04		/* separator for pSortOrder */
#define LOWEST_VALID_CHAR 0x07	/* smallest character allowed for app data */
#define MAX_HIST_SLOTS	10	/* maximum partial update slots */

/* internal database limits */
#define MTABS		20	/* maximum number of tables in a database */
#define MCOLS		40	/* maximum columns allowed in a table	*/
#define MQLINES 	12	/* maximum number of query lines */
#define MSORT_FLDS	 5	/* maximum number of sort fields */
#define MAX_COL_NAME	20	/* maximum number of chars in column name */
#define MAX_TAB_NAME	20	/* maximum number of chars in table name */
#define MAX_QLINE_LEN	62	/* maximum number of chars in query line */

/* error messages from db_mgr */

#define DB_OK			 0
#define DB_NO_TBL_HIST		-1
#define DB_ALREADY_OPEN 	-2
#define DB_DISK_WRITE		-3
#define DB_NO_CREATE		-4
#define DB_DUPL_TABLE		-5
#define DB_TBL_NAME_ERR 	-6
#define DB_COL_NAME_ERR 	-7
#define DB_FIRST_RECORD 	-8
#define DB_LAST_RECORD		-9
#define DB_QUERY_SYNTAX 	-10
#define DB_NO_ROWS_SELECTED	-11
#define DB_DISK_READ		-12
#define DB_NO_OPEN		-13
#define DB_DUPL_COLUMN		-14
#define DB_RECNUM_ERR		-15
#define DB_OUT_OF_MEMORY	-16
#define DB_MAX_NBR_FIELDS	-17
#define DB_INVALID_FILE_TYPE	-18
#define DB_MULTI_UNIQ		-19
#define DB_UNIQ_NOT_SORT	-20
#define DB_INVALID_CHAR 	-21
#define DB_NO_EOR		-22
#define DB_UNIMPLEMENTED	-23
#define DB_RECORD_NOT_CURRENT	-24
#define DB_TOO_MANY_OPEN_FILES	-25
#define DB_INVALID_FILE_HANDLE	-26
#define DB_TABLE_LOCKED 	-27
#define DB_DUPL_KEY_FIELD	-28
#define DB_TABLE_SHARED 	-29
#define DB_INVALID_TABLE_HANDLE -30
#define DB_RECORD_DELETED	-31
#define DB_NO_DBCOLUMNS 	-32
#define DB_NO_TEMP_SORT 	-33
#define DB_NO_PACK		-34
#define DB_PAGE_NOT_FOUND	-35
#define DB_NO_RECORDS		-36
#define DB_DIR_FULL		-37
#define DB_NO_INDEX		-38
#define DB_ONLY_RECORD		-39
#define DB_SAME_TABLE		-40
#define DB_DIFFERENT_TABLES	-41
#define DB_DISK_FULL		-42
#define DB_STOPPED		-43
#define DB_WRITE_PROTECTED	-44
#define DB_TABLE_FULL		-45
#define DB_TABLE_NEEDS_UPDATE	-46
#define DB_MULTI_AGAIN		-49
#define DB_BUSY 		-50
#ifndef HL_ROM
#define DB_TIMOUT		-51
#define DB_SERVER_BUSY		-52
#define DB_NO_SERVER		-53
#define DB_SERVER_DIED		-54
#define DB_NETERR		-55
#endif
#define DB_TEMP_SORT_ALREADY	-56	/* may be temp error */
#define DB_GOT_MINIMUM		-57
#define DB_READ_ONLY		-58
#define DB_RESOURCE_NOT_LOADED	-59
#define DB_NEEDS_PACK		-60
#define DB_NO_FLUSH		-61

#define MAX_ERR_MSG_NUM 61

#ifndef HL_ROM
/* defines for client calls */
#define CL_LOCAL	0	/* not a client */
#define CL_CLIENT	1	/* client on non-server */
#define CL_RESUME	2	/* resume client on non-server */
#define CL_SRVR 	-1	/* client on server */
#define CL_PAUSE	-2	/* pause client on non-server */
#endif

/*  structures for database manager calls */

typedef unsigned int UNSIGNED;	/* used on all rec_num elements */

struct db_columnsx	    /* used internally as part of db_table	*/
    {
    char *col_name;	    /* pointer to column name			 */
    char *new_name;	    /* used to change column name		 */
    int  col_length;	    /* column length				 */
    char col_type;	    /* column type see types below		 */
    char col_pattr;	    /* column protection attribute		 */
    char unique_flag;	    /* if non zero - column value must be unique */
    };
typedef struct db_columnsx db_columns;

/* defines for col_type */
#define CHAR87			'C'     /* 1987 compatible - to_upper &0x5F */
#define CHAR88			'K'     /* for DOS 3.3 & greater uses  */
					/* collating sequence table for */
					/* sorting & queries */
#define NUMERIC_COL		'N'
#define DATE_COL		'D'     /* stored internally in julian format */


/* defines for setting unique_flag value */
#define SET_UNIQUE_COL		'1'
#define UNSET_UNIQUE_COL	'0'

struct db_tablex	    /* used in CREATE_TABLE, ALTER_TABLE	*/
    {
    int        handle;	  /* handle of open file (create) or table (alter) */
    char       *tbl_name;	/* pointer to table name		*/
    int        n_columns;	/* number of columns in table		*/
    char       update_type;	/* update function number		*/
    int        n_items; 	/* number of items in the db_column array   */
    db_columns *cols;		/* pointer to array of db_column structures */
    };
typedef struct db_tablex db_table;

/* defines for ALTER_TABLE update_type */

#define ADD_COLUMN	1
#define DROP_COLUMN	2
#define CHG_COLUMN	3
#define COLUMN_INFO	4


struct	table_accessx		/* used in OPEN_TABLE, DROP_TABLE	*/
    {
    int 	file_handle;	/* handle of open file */
    char	*tbl_name;	/* table name to open */
    int 	access_level;	/* DEFINITION or DATA_ACCESS */
    };
typedef struct table_accessx table_access;

/* defines for OPEN_TABLE access_level */

#define DEFINITION	-2
#define DATA_ACCESS	1


struct db_valuex		/* used internally in db_add structure	*/
    {
    char *col_name;		/* pointer to column name		*/
    char *col_value;		/* pointer to column value		*/
    };
typedef struct db_valuex db_value;

struct db_addx		/* used in ADD_ROW, UPDATE_ROW single user calls */
    {
    int 	table_handle;	/* handle of open table */
    int 	n_columns;	/* number of columns to be added or updated  */
    db_value	*val;		/* pointer to an array of db_value structures */
    int 	prev_rec;	/* previous record, 0= this is first record */
    int 	next_rec;	/* next record, 0= this is last record */
    };
typedef struct db_addx db_add;

struct db_getx
    {
    int 	table_handle;		/* handle of open table */
    char	*buffer;		/* pointer to destination buffer */
    int 	num_columns;		/* number of columns being selected */
    char	**col_array;		/* array of column names (in ret order) */
    int 	num_query_lines;	/* number of constraints */
    char	**query_line_array;	/* array of query constraints */
    UNSIGNED	rec_num;		/* rec num used for prior/after/fetch */
    int 	index_handle;		/* index_handle to support TEMP_SORT */
    };
typedef struct db_getx db_get;

struct db_deletex
    {
    int 	table_handle;		/* handle of table to delete from */
    UNSIGNED	rec_num;		/* record number to delete */
    int 	num_query_lines;	/* number of constraints */
    char	**query_line_array;	/* array of query constraints */
    };
typedef struct db_deletex db_delete;

struct db_queryx
    {
    int 	table_handle;		/* handle of open table */
    char	*pBuffer;		/* pointer to destination buffer */
    int 	num_columns;		/* number of columns being selected */
    char	**col_array;		/* array col names (in return order) */
    int 	num_query_lines;	/* number of constraints */
    char	**query_line_array;	/* array of query constraints */
    int 	amt_memory;		/* amount of memory app has for recs */
    int 	rec_cnt;		/* number of records in buffer */
    UNSIGNED	cur_rec_num;		/* next record number to be returned */
    int 	direction;		/* direction records are assembled in */
    int 	index_handle;		/* index to retrieve records from */
    unsigned	char q_id;		/* current query id */
    };
typedef struct db_queryx db_query;

/* directions for record searches for multi-user queries */
#define DIRN_FIRST  FIRST_RECORD
#define DIRN_LAST   LAST_RECORD
#define DIRN_NEXT   NEXT_RECORD
#define DIRN_PRIOR  PREV_RECORD

#define DB_EQUAL	'='     /* all rows equal to the specified value */
#define DB_GREATER	'>'     /* all rows greater or equal to  value */
#define DB_LESS 	'<'     /* all rows less or equal to value */
#define DB_NOT_EQUAL	'!'     /* all rows not equal to value */
#define DB_SUBSTRING	'|'     /* all rows with this substring in the field */
#define REC_CONTAINS	'^'     /* all rows with this substring in some field */

struct db_updatex
    {
    int 	table_handle;		/* handle of open table */
    int 	n_columns;		/* number of columns being selected */
    char	**col_names;		/* array col names (in return order) */
    char	**pOld_col_values;	/* old column values (in order) */
    char	**pNew_col_values;	/* new column values (in order) */
    UNSIGNED	rec_num;		/* current record number */
    char	verify_flag;		/* VERIFY or NO_VERIFY */
    int 	prev_rec;	/* previous record, 0= this is first record */
    int 	next_rec;	/* next record, 0= this is last record */
    };
typedef struct db_updatex db_update;

/* defines for verify_flag */
#define VERIFY	1
#define NO_VERIFY 0

struct handle_bufx   /* general purpose struct for a handle and buffer */
    {
    int 	handle; 	/* handle of open table or file */
    char	*buffer;	/* buffer to return information in */
    };
typedef struct handle_bufx handle_buf;

struct db_indexx
    {
    int 	table_handle;	/* open table handle */
    char	*index_name;	/* pointer to index name */
    char	*pSortOrder;	/* column names for sort order, separated by */
				/* 0x0E's */
    };
typedef struct db_indexx db_index;

struct db_end_tempx
    {
    int 	table_handle;	/* table handle with TEMP_SORT defined */
    int 	index_handle;	/* index handle of TEMP_SORT to drop */
    };
typedef struct db_end_tempx db_end_temp;


struct db_mergex
    {
    int 	to_th;		/* tbl handle merge to must be EXCLUSIVE USE */
    int 	from_th;	/* table handle merging from */
    char	duplicates;	/* DUP - Allow duplicates */
				/* NO_DUP - Don't allow duplicate records */
    };
typedef struct db_mergex db_merge;

#define DUP	1
#define NO_DUP	0

struct db_countx
    {
    int 	table_handle;		/* handle of open table */
    int 	num_query_lines;	/* number of constraints */
    char	**query_line_array;	/* array of query constraints */
    int 	num_match;		/* number of matching records */
    int 	total_num;		/* total number of records in table */
    };
typedef struct db_countx db_count;

struct db_copy_tblx
    {
    char	*tablename;		/* table name to copy */
    char	data;			/* COPY_DATA or NO_COPY_DATA flag */
    };
typedef struct db_copy_tblx db_copy_tbl;

#define COPY_DATA	1
#define NO_COPY_DATA	0

struct db_copy_layx
    {
    int 	file_handle;		/* handle of file containing tables */
					/* to copy */
    char	*new_filename;		/* name of destination file to create */
    int 	num_tables;		/* number of tables in the array */
    db_copy_tbl *table_array;		/* array of tables to copy */
    };
typedef struct db_copy_layx db_copy_lay;

/* table history slot structure */
typedef struct
{
	unsigned int rec_num;		/* record number of transaction */
	char trans_type;		/* A, D, U = Add, Delete, Update */
} hist_slot;

/* table history request structure */
typedef struct
{
	int table_handle;   /* handle of table with history table */
	unsigned long time; /* time of last update in seconds since 1/1/1980 */
	unsigned char num_changes; /* number of items in following array. */
	hist_slot hist_changes[ MAX_HIST_SLOTS ];
} UserHist;

struct db_locationx
    {
    int 	table_handle;		/* handle of open table */
    int 	num_query_lines;	/* number of constraints */
    char	**query_line_array;	/* array of query constraints */
    unsigned int rec_num;		/* record to get location of */
    unsigned int prev_num;		/* previous record to rec_num */
    unsigned int next_num;		/* next record after rec_num */
    int 	index_handle;		/* index handle from TEMP_SORT */
    };
typedef struct db_locationx db_location;

#endif

/* end of DMDB.H */
