;---------------------------------------------------------------------------
;
; DMEXEC.INC - include file used by both the executive and exec users (both
;              application and resources) to insure correct communication
;
; This file is very general so that only one file must be included for any 
; program that uses the exec.
;---------------------------------------------------------------------------

DM_EXEC_INT	equ	0E0h	; This is the interrupt to call the exec.

;---------------------------------------------------------------------------
; The executive is organized to handle requests during an int E0h by
; checking for what major class of service is requested.  Once found, the
; actual service requested is determined.  ah is used to hold the major
; class designation, with al typically holding the actual function request.
;---------------------------------------------------------------------------

MISC	equ	00000h
RLOAD	equ	00100h
ALOAD	equ	00200h
FIXUP	equ	00300h
CLIP	equ	00400h
TASK	equ	00500h
INFO	equ	00600h
RUNACC	equ	00700h

;---------------------------------------------------------------------------;
; 'equ's for the actual function id used for exec services having to do     ;
; with applications.                                                        ;
;---------------------------------------------------------------------------;

SETNEXTAPP	equ	004h
SETOTHERTASK	equ	005h

LOAD_RES	equ	006h
TEMP_RES	equ	009h
FREE_RES	equ	007h
BIND_RES	equ	008h
CLEAR_RES	equ	00bh
NLOAD_RES	equ	00ch

APP_NO_SHED	equ	00ah

TS_START	equ	00h
TS_YIELD	equ	01h
TS_COUNT	equ	02h
TS_RSTVECTAB	equ	03h

CB_CLEAR	equ	00h
CB_GETINFO	equ	01h
CB_SETINFO	equ	02h
CB_SIZE		equ	03h
CB_GBUFF	equ	04h
CB_FBUFF	equ	05h

IN_PRODUCT	equ	00h
IN_DMCONFIG	equ	01h
IN_LASTCRIT	equ	02h
IN_FILESEARCH	equ	03h
IN_ISITHERE	equ	04h
IN_TASKID	equ	05h
IN_TASKNAME	equ	06h
IN_MSGID	equ	07h
IN_ERRFILE	equ	08h
IN_ERRDRIVE	equ	09h
IN_RESOURCES	equ	0ah
IN_SHED		equ	0bh
IN_FLOPPY	equ	0ch
IN_VERSION	equ	0dh
IN_RESVER	equ	0eh
IN_UNDEFINED	equ	0fh	; marks end of INFO functions, must be last

REGISTER	equ	0F0h	; new (1989) resource register
BY_NAME		equ	0FFh	; resource referenced by name, not index

GET_MEM		equ	3	; allocate memory
MEM_MSG		equ	4	; display not enuff memory msg box

VDD_INIT	equ	5	; about to load new video driver
VDD_READY	equ	6	; csr video is initialized
VDD_END		equ	7	; done loading video driver, load autoloads

SILENT_MSG	equ	8	; turn off desk's message boxes
ENABLE_MSG	equ	9	; turn desk's message boxes back on

TRAP_INT	equ	0ah	; trap an interrupt
UN_TRAP		equ	0bh	; stop trapping an interrupt

;---------------------------------------------------------------------------;
; The following are the 'equ's placed into reg ax before issuing the exec   ;
; service request interrupt.                                                ;
;---------------------------------------------------------------------------;

DM_EXEC_RES_START	equ	RLOAD+BY_NAME	; register resource with exec.
DM_EXEC_RES_REGISTER	equ	RLOAD+REGISTER	; register resource with exec.

DM_EXEC_SETNEXTAPP	equ	ALOAD+SETNEXTAPP; tell exec what app runs next
DM_EXEC_SETOTHERTASK	equ	ALOAD+SETOTHERTASK; tell exec what task to fork

DM_EXEC_LOAD_RES	equ	ALOAD+LOAD_RES	; load & fixup a named resource
DM_EXEC_NLOAD_RES	equ	ALOAD+NLOAD_RES	; load & fixup a named resource
DM_EXEC_TEMP_RES	equ	ALOAD+TEMP_RES	; load resource temporary
DM_EXEC_FREE_RES	equ	ALOAD+FREE_RES	; free a named resource
DM_EXEC_BIND_RES	equ	ALOAD+BIND_RES	; bind to resource if present
DM_EXEC_CLEAR_RES	equ	ALOAD+CLEAR_RES	; remove a resource from mem

DM_EXEC_DONT_SHED	equ	ALOAD+APP_NO_SHED ; don't code shed this app

DM_EXEC_ACC_RUN		equ	RUNACC		; run the requested acc
DM_EXEC_HELP_RUN	equ	RUNACC+1	; run the requested acc nested

DM_EXEC_INQ_PRODUCT	equ	INFO+IN_PRODUCT	; status bits about desk
DM_EXEC_INQ_DMCONFIG	equ	INFO+IN_DMCONFIG ; fill w/ dmconfig=
DM_EXEC_INQ_LASTCRIT	equ	INFO+IN_LASTCRIT ; get last critical error
DM_EXEC_INQ_TASKID	equ	INFO+IN_TASKID	; get task ID, 1, 2, or 3
DM_EXEC_INQ_TASKNAME	equ	INFO+IN_TASKNAME ; get task name
DM_EXEC_INQ_MSGID	equ	INFO+IN_MSGID ; get id of current message box
DM_EXEC_INQ_ERRFILE	equ	INFO+IN_ERRFILE ; get filename of error msg
DM_EXEC_INQ_ERRDRIVE	equ	INFO+IN_ERRDRIVE ; get drive of crit err msg
DM_EXEC_INQ_RESOURCES	equ	INFO+IN_RESOURCES ; get names of resources
DM_EXEC_INQ_SHED	equ	INFO+IN_SHED ; get number of paragraphs shed
DM_EXEC_INQ_FLOPPY	equ	INFO+IN_FLOPPY ; test if floppy
DM_EXEC_INQ_VERSION	equ	INFO+IN_VERSION ; get version of desk
DM_EXEC_INQ_RESVER	equ	INFO+IN_RESVER ; get version of a resource

DM_FILE_SEARCH		equ	INFO+IN_FILESEARCH ;find a file anywhere
DM_DIR_ISITHERE		equ	INFO+IN_ISITHERE   ;finds a file w/ full path

DM_EXEC_START_TASK	equ	TASK+TS_START	; start a new task
DM_EXEC_YIELD		equ	TASK+TS_YIELD	; yield to another task
DM_EXEC_TASK_COUNT	equ	TASK+TS_COUNT	; return number of active tasks
DM_EXEC_RSTVECTAB	equ	TASK+TS_RSTVECTAB ; retset vector table

DM_EXEC_CLIP_CLEAR	equ	CLIP+CB_CLEAR	; reset the clipboard to empty
DM_EXEC_CLIP_GETINFO	equ	CLIP+CB_GETINFO	; fill apps params with CB info
DM_EXEC_CLIP_SETINFO	equ	CLIP+CB_SETINFO	; fill CBs params from app info
DM_EXEC_CLIP_SIZE	equ	CLIP+CB_SIZE ; get max size of clipboard
DM_EXEC_CLIP_GETBUFF	equ	CLIP+CB_GBUFF ; get size and pointer for buffer
DM_EXEC_CLIP_FREEBUFF	equ	CLIP+CB_FBUFF ; free clipboard buffer

DM_EXEC_GET_MEM		equ	MISC+GET_MEM	; allocate mem from DOS
DM_EXEC_MEM_MSG		equ	MISC+MEM_MSG	; display memory msg box

DM_EXEC_VID_INIT	equ	MISC+VDD_INIT	; about to load new vid driver
DM_EXEC_VID_READY	equ	MISC+VDD_READY  ; csr video is initialized
DM_EXEC_VID_END		equ	MISC+VDD_END	; done loading video driver

DM_EXEC_SILENT_MSG	equ	MISC+SILENT_MSG	; turn off msg boxes
DM_EXEC_ENABLE_MSG	equ	MISC+ENABLE_MSG	; turn msg boxes back on

DM_EXEC_TRAP_INT	equ	MISC+TRAP_INT	; trap an interrupt
DM_EXEC_UN_TRAP		equ	MISC+UN_TRAP	; stop trapping an interrupt

;---------------------------------------------------------------------------;
; The following are the 'equ's that define function parameter constants	    ;
; and return values used in calls to the exec.				    ;
;---------------------------------------------------------------------------;

DM_OK		equ	 1	; value returned when exec request was succesful
DM_ERROR	equ	-1	; value returned when an error in exec occured
DM_NOT_ALLOWED	equ	-2	; value returned when an illegal task sw call
DM_DEFAULT      equ     2       ; from DM_EXEC_INQ_DMCONFIG means DESK assigned
DM_EXISTS       equ   -2   ; value returned when trying to load a resource
                           ; that allready existed on an 1988 deskmate system.

; Bits set by DM_EXEC_INQ_PRODUCT
DM_RUN_FLAG	equ	4	; This is the runtime version
DM_COMPAT_FLAG	equ	8	; 1989 Runtime running with 1988 deskmate
DM_SHELL_FLAG	equ	10h	; Desktop only "shell" product

DM_DESKLINK	equ	00100h	; DeskLink active
DM_TASKSWITCHING equ	00200h	; Task switching is active
DM_VERSION	equ	08000h	; DM_EXEC_INQ_VERSION call available

CLIP_EMPTY	equ	0	; These are the different clipboard type
CLIP_TEXT	equ	1	; available to the applications.
CLIP_BITMAP	equ	2
CLIP_WORKSHEET	equ	3
CLIP_FILER	equ	4
CLIP_PAINT	equ	5
CLIP_DRAW	equ	6
CLIP_DRAW_TEXT	equ	7
CLIP_MUSIC	equ	8
CLIP_CALENDAR	equ	9

ACC_BY_NAME	equ	0ffh	; to give the name of the accessory

;end of DMEXEC.INC
