/*-----------------------------------------------------------------------------
	Demo6 -		Reads a file containing digital sound data and plays
			it directly.  The sound being played can be larger
			than available memory.
			18-Oct-94

			Note:	The file to be played should be stored on a
				hard disk, Iomega or other high speed device.
				A floppy drive is not fast enough to be used
				with the 11,000 and 22,000 Hz sampling rates.
				Use of slow disk devices will result in
				fragmented playback.

	DEMO6 is part of the PSSJ Digital Sound Toolkit.
	Copyright 1994 Frank Durda IV, all rights reserved.
	Commercial use is restricted.  See intro(PSSJ) for more information.
-----------------------------------------------------------------------------*/

#include "sound.h"
#include "dsetup.h"
#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <dos.h>

#define BUFFERSIZE 65516

#ifdef __STDC__
int	main(int argc, char *argv[])
#else
int	main(argc, argv)
int	argc;
char	*argv[];
#endif

{
	int	infile;
	int	k, running_time, last_time;
	char far *cp;			/*pointer to last allocated buffer */

	printf("Demonstration #6 - Play sounds stored in a file\n");
	printf("Version  2(2)  18-Oct-94\n");
	printf("Copyright 1994 Frank Durda IV.  All rights reserved.\n");

/*	Print the version number */

	printf("Sound Toolkit ");
	for (cp = snd_version()->version; *cp; putchar(*cp++));
	printf("\n");

	if (argc != 2)			/*Make sure a filename was specified*/
	{
		printf("Usage:  demo6 [C|D]:savefile\n");/*Wrong number of*/
		exit(1);				/*parameters.*/
	}

/*	Allocate buffers that are used internally by the sound toolkit.
	At least 25 buffers (55K) of buffers are required for file-play
	operation.  The more buffers, the higher the reliability on
	slower systems with highly fragmented hard disks.  Fewer buffers
	can be used if the high sampling rates are not to be used.
*/

	set_up_sound(25, 5, 0, 0, 0);

/*	Open the file that was specified on the command line.  The
	handle will be passed to the sound toolkit.
*/

	if (_dos_open(argv[1],O_RDONLY,&infile) || infile==NULL) {
		printf("Can't open file %s\n",argv[1]);
		snd_exit();
		exit(1);
	}

	printf("About to call snd_file_play() - Press ENTER to begin.\n");
	while (getch() != '\r')		/*Wait for carriage return */
		;			/*Until then, do nothing*/

/*	Play the file.  This call determines the playback rate, whether
	compression was used and all other factors necessary for playing
	the file.  This information is in the file header.  
	Once the playback starts, it will return to the caller.
*/

	snd_file_play(infile,0);

/*	Since the actual playing of the file is performed by interrupt-
	driven code, we are free to perform other operations while the
	sound is being played provided we do not tie-up MS-DOS so that
	disk I/O is not possible, and we do not disable interrupts for
	extended periods of time.

	In this demonstration, we will just keep track of how long
	the file has been playing and display that information on the
	screen.
*/

	printf("Back in main() - press any key to stop playback\n");
	printf("       Seconds of Elapsed Time\r");

/*	snd_wait will return zero when the end-of-file has
	been reached.  While the file is being played, it will return
	the elapsed time in 100's of milliseconds.
*/

	while(running_time = snd_wait(0,0,0)) {
		if (kbhit()) {		/*If a key is pressed, read*/
			k=getch();	/*and discard the key, then*/ 
			snd_stop(0,0);	/*stop the playback*/
		}
		if (running_time != last_time) {	/*New time to report?*/
			printf("%d.%1d\r",running_time/10,
			       running_time % 10);	
			last_time = running_time;
		}
	}

/*	When control reaches this point, the player has stopped.  This
	can be because it was requested (snd_stop() was called, the end-of-file
	was reached, or a disk error was encountered.
*/

	printf("\r\nExiting\n");

	snd_exit();			/*Shutdown the sound toolkit*/

	return(0);
}

