.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 18th, 1994\"
.TH SND_AMPLIFY PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_AMPLIFY troff documentation \- Version 1(1) 18\-Feb\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.SH Name
.br
snd_amplify \- Creates an amplitude translation table

.SH Syntax
.br
.B void far snd_amplify(factor, tableptr);
.br
.B unsigned short factor;
.br
.B unsigned char far * tableptr;
.br

.SH Description
.br
\fISnd_amplify\fR generates a function table to be used to amplify
(or de-amplify) a sound by the specified \fIfactor\fR.
\fITableptr\fR is a pointer to a 256-byte array to be initialized by
\fIsnd_amplify\fR(PSSJ).  The calling application is responsible
for providing the buffer that \fItableptr\fR points at.
\fIFactor\fR, multiplied by 1000, specifies the amplification to be
used in constructing the table.
To amplify a sound 1.5 times, \fIfactor\fR would be set to 1500.

To perform de-amplification, specify a \fIfactor\fR less than
1000.  To reduce the amplitude of a signal by 50%, \fIfactor\fR is set
to 500.

The table created by \fIsnd_amplify\fR can be used with
\fIsnd_apply_func\fR(PSSJ) to actually perform the amplification
on a sound buffer.  The table can also be used with the
\fIsnd_record\fR(PSSJ), \fIsnd_file_record\fR(PSSJ).

.SH Return Values
None.

.SH See Also
snd_record(PSSJ), snd_file_record(PSSJ), snd_apply_func(PSSJ)

.SH Credit
\fISnd_amplify\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402181

