.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 18th, 1994\"
.TH SND_CUE PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_CUE troff documentation \- Version 1(6) 18\-Feb\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_cue \- Preconfigures sound hardware for recording or playback.

.SH Syntax
.B short far snd_cue(mode);
.br
.B unsigned short mode;
.br

.SH Description
\fISnd_cue\fR puts the sound driver into stand-by mode for recording or 
playing.  When \fImode\fR is equal to \fBTORECORD\fR, the driver is put
into stand-by mode for recording.  When \fImode\fR is equal to
\fBTOPLAY\fR, the driver is put into stand-by mode for playback.

When switching from play to record mode, or from record to play mode, 
a significant delay is encountered while the hardware is switched between 
modes (unless the \fBFASTRAMP\fR option has been specified to the
\fIsnd_init\fR(PSSJ) call).  This delay can be over one second.
In certain applications it can make cuing the start of a recording or
synchronizing playback to video displays difficult or impossible.

For example,  a user could not be accurately alerted as to when recording 
would actually start if the delay occurs when \fIsnd_record\fR(PSSJ)
is initially called.  By calling \fIsnd_cue\fR(\fBTORECORD\fR)
before recording begins, it will perform the switch-over of the hardware,
which will guarantee that recording will start immediately after calling
\fIsnd_record\fR(PSSJ).

\fISnd_cue\fR can only be called when switching from one mode (play or 
record) to the other.  If called while the recorder or player is already 
running, or while the system is uninitialized, an error will be
returned.

A call to \fIsnd_cue\fR is not required in order to play or record
sounds.  The hardware will be switched when \fIsnd_record\fR(PSSJ) or
\fIsnd_play\fR(PSSJ) is called, if this has not already been done.
However, there will be a delay before recording or playback begins.

\fISnd_cue\fR has no effect if
\fIsnd_init\fR(PSSJ) was called with the \fBFASTRAMP\fR option.

.SH Return Values
.IZ
.TZ
NOERROR Call succeeded.
.br
.TZ
INVALID The sound toolkit is already recording or playing, or
\fIsnd_init\fR(PSSJ) has not been called.
.br
.OZ

.SH See Also
snd_init(PSSJ), snd_play(PSSJ), snd_file_play(PSSJ), snd_record(PSSJ),
snd_file_record(PSSJ) 
.if n .bp
.if t .sp
.SH Credit
\fISnd_cue\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402186

