.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W October 18th, 1994\"
.TH SND_DECOMPRESS_PART PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_DECOMPRESS_PART troff documentation \- Version 1(2) 18\-Oct\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.de IZ
.if t  .in +1.0i
.if n  .in +1.2i
..
.de OZ
.if t  .in -1.0i
.if n  .in -1.2i
..
.de TZ
.if t  .ti -1.0i
.if n  .ti -1.2i
..
.SH Name
.br
snd_decompress_part \- Provide data to be decompressed.

.SH Syntax
.br
.B short far snd_decompress_part(pSound, pInfo, src, src_len);
.br
.B SOUND far *pSound;
.br
.B COMPINFO far *pInfo;
.br
.B u_char far *src;
.br
.B u_short src_len;
.br

.SH Description
.br
\fISnd_decompress_part\fR
is called in a loop to decompress a sound.  On each call, 
the buffer pointed to by \fIsrc\fR must contain \fIsrc_len\fR characters;
these will be decompressed and stored in the specified sound.  On all but
the first call, NULL should be specified for \fIpSound\fR.  A final call
with \fIsrc_len\fR set to 0 should be made after all data has been passed
through this routine.

Before calling \fIsnd_decompress_part\fR, the caller must ensure that the 
buffer associated with \fIpSound\fR is at least two bytes longer than the
original uncompressed sound.

The caller must fill in the length of the uncompressed sound in the 
\fIpSound\fR->\fIsndlen\fR field, using the length of the sound before it
was compressed.  The original \fIrate\fR and \fIbias\fR values from the
\fISOUND\fR structure that was originally compressed should be placed
in the new \fISOUND\fR structure before it is played.

.SH Return Values
.IZ
.TZ
NOERROR Decompression successful.
.br
.TZ
BADFMT  The compressed sound was compressed using an unsupported
compression algorithm, or the data is corrupted.
.br
.OZ

.SH See Also
snd_compress_part(PSSJ), snd_record(PSSJ), snd_play(PSSJ)

.SH Credit
\fISnd_decompress_part\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
110182
