.if t .po 1.0i
.if n .po 0.0i
.if n .nr LL 7.5i
.ds ]W February 15th, 1994\"
.TH SND_VOLUME PSSJ "" "PSSJ Digital Sound Toolkit"
.ig
SND_VOLUME troff documentation \- Version 1(8) 15\-Feb\-94
Copyright 1994 Frank Durda IV, All Rights Reserved.
This and other copyright notices may not be removed from this file.
..
.if t  .ta 0.5i 1.0i 1.5i 2.0i 2.5i 3.0i 3.5i 4.0i 4.5i 5.0i 5.5i 6.0i
.if n  .ta 0.6i 1.2i 1.8i 2.4i 3.0i 3.6i 4.2i 4.8i 5.4i 6.0i
.de IN
.if t  .in +0.5i
.if n  .in +0.6i
..
.de OU
.if t  .in -0.5i
.if n  .in -0.6i
..
.de TI
.if t  .ti -0.5i
.if n  .ti -0.6i
..
.SH Name
.br
snd_volume \- Sets the playback audio level.

.SH Syntax
.br
.B void far snd_volume(volume);
.br
.B unsigned short volume;

.SH Description
.I Snd_volume
sets the hardware output level to \fIvolume\fR.
\fIVolume\fR must be a value in the range \fB1\fR (minimum output) to 
\fB7\fR (maximum output).  If the player is running, the previous value for
\fIvolume\fR will remain in effect until the player stops.

The state of the player can be checked by making the call
\fIsnd_wait\fR(\fB0\fR,\fB0\fR,\fB0\fR).  If the result is \fB0\fR,
the player is inactive, and a new volume level will be set on the
next call to \fIsnd_play\fR(PSSJ) or \fIsnd_file_play\fR(PSSJ).
Calling \fIsnd_stop\fR(PSSJ) or \fIsnd_record\fR(PSSJ) will also guarantee
that the next sound output will be at the new volume level.

By default, the PSSJ Digital Sound Toolkit leaves the playback
volume set to \fB7\fR.

.SH Return Values
None.

.SH Notes
\fISnd_volume\fR does not affect the sound data as
\fIsnd_apply_func\fR(PSSJ) does. It merely sets the hardware output level.

.SH See Also
snd_play(PSSJ), snd_file_play(PSSJ), snd_stop(PSSJ), snd_cue(PSSJ)

.SH Credit
\fISnd_volume\fR(PSSJ) is part of the PSSJ Digital Sound Toolkit.
.br
Copyright 1994 Frank Durda IV, see \fIintro\fR(PSSJ) for
restrictions.
.br
\-\-\-\-\-\-
.br
402158

