	page	60,132
;-----------------------------------------------------------------------------
;	Irq.Asm - Player_Irq -	Handles interrupts from the hardware
;	IRQ.ASM is part of the PSSJ Digital Sound Toolkit.
;	By Frank Durda IV
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	circleirq:byte		;<23>
	extrn	play_safety:NEAR
	extrn	record_safety:NEAR
	extrn	rec_sndaddr:dword
	extrn	get_rec_next:NEAR
	extrn	rec_count:NEAR
	extrn	playexpand:NEAR		;<22>
	extrn	disk_rd:NEAR		;<22>
	extrn	eofchk:NEAR		;<22>
	extrn	indos:dword		;<22>
	extrn	round_esdi:NEAR
	extrn	rec_convert:NEAR	;<29>
	extrn	snd_disk_wr:NEAR
	extrn	snd_rec_offl:NEAR
	extrn	snd_rec_buf:NEAR
	extrn	snd_dma_stop:NEAR	;<29>
	extrn	_snd_clock:word		;<30>
	extrn	iirq:byte		;<32>

	include	external.inc

	include	sound.inc
snddata	segment public	'DATA'
snddata	ends
	page
sndseg	segment	public	'CODE'
	assume cs:sndseg,ds:snddata
	public	player_irq
player_irq proc far
	push	dx
	push	ax
	push	ds
	mov	ax,snddata
	mov	ds,ax
	assume DS:snddata
	cld				;<25>Force direction (was here)

	mov	al,byte ptr snd_mode	;<32>
	test	al,SHUTDOWN		;<32>Are we just trying to quit?
	jnz	$ourirq			;<32>Then just ack and get out

	mov	dx,DacBase		;Get base port
	in	al,dx			;Find out if it was us
	test	al,8
	jnz	$ourirq

;	Here the request is not ours
	pop	ds
	pop	ax
	pop	dx
	jmp	cs:irq_next_task	;Jump to this address
	page
;	Okay the interrupt was ours, set-up our environment

$ourirq:and	al,0e7h			;This works for all bits but 3 & 7
	out	dx,al			;Clear interrupt source

	push	es
	push	cx
	push	bx
	push	di
	push	si

	mov	ax,ds
	mov	es,ax
	assume es:snddata

	mov	al,byte ptr snd_mode	;<22>Find out what we are doing
	test	al,INPLAY
	jnz	$playirq
	test	al,INRECORD
	jz	$irqexit1
	jmp	$recirq

;	Here we got an interrupt, it was ours, but we aren't doing
;	anything, so ignore it.

$irqexit:
	dec	byte ptr circleirq	;<23>ATOMIC**********
$irqexit1:
	pop	si
	pop	di
	pop	bx
	pop	cx
	pop	es

	mov	al,iirq			;<32>Get IRQ before we lose DS
	pop	ds
	or	al,60h			;<32>Specify Specific EOI
	out	20h,al			;Reset interrupt controller
	pop	ax
	pop	dx
	iret
	page
;	Here the interrupt was in response to the player running

$playirq:
	inc	byte ptr circleirq	;ATOMIC************
	test	al,STOPDMA		;Is this the end?
	jz	$playrun
	jmp	short $playstop

;	Here the DMA is stopped and playing is complete.

$playabort:
	mov	ds,bx			;<29>Reset DS
$playstop:
	call	snd_dma_stop		;<29>
	and	snd_mode,NOT (INPLAY OR STOPDMA OR BIAS OR DISKABORT)	;<28>
					;<16>Mark the player as idle
	jmp	$irqexit		;All done
	page	
;	Here we are not finished, so fill in bytes saftey to n,
;	then call play_safety to handle the rest

$playrun:
	inc	word ptr _snd_clock	;<30>Bump the running-time clock
	les	di,merrygo_buf		;Point at target area
	add	di,SPLIT_FILL_BYTES
	mov	bx,ds			;<29>Save DS
	lds	si,queue_play		;Get buffer to play
	mov	ax,ds
	or	ax,si
	jz	$playabort		;Buffer disappeared  SHOULD NOT HAPPEN

	add	si,HEADER_SIZE+SPLIT_FILL_BYTES
	mov	cx,MERRYGO_SPLIT/2	;Get words to fill out
	rep	movsw
	mov	al,[si-1]		;<29>Do DEC here
	mov	ds,bx			;<29>Fix segment
	mov	emptyfill,al		;Save that byte in case we need

;<23>	Interrupts re-enabled later to prevent clk-interrupts from starting
;<23>	slow disk I/O on top of us.
;<23>	I moved this after the expansion and safety code to prevent the
;<23>	spector of being in there twice.   

	mov	dx,DacBase		;Reactivate interrupts
	in	al,dx
	and	al,07fh
	or	al,18h			;IRQ's reset and active
	out	dx,al
	page
;<22>	This is an attempt at avoiding burning 2-3 msec in a tight loop.
;<22>	On disk play this will attempt to do one buffer expansion that
;<22>	would have to be done anyway.  We may take up to 80msec before
;<22>	we could get in trouble, but the code is not nearly that slow.

	mov	ax,snd_mode		;<22>Get machine state
	test	ax,DISKPLAY		;<22>Is this disk play?
	jz	$memplay		;<22>Nope, normal world
	call	playexpand		;<22>See if we can do an expansion
$memplay:				;<22>Ignore return code
	call	play_safety		;Ok, handle safety zone
					;and nasty buffer management
	mov	ax,snd_mode		;<22>Get machine state
	test	ax,DISKPLAY		;<22>Is this disk play?
	jz	$dne			;<22>Nope, normal world
	les	si,indos		;<22>
	cmp	word ptr es:[si],0	;<22>
	jnz	$dne			;<22>
	call	disk_rd			;<22>Attempt to do disk I/O
	call	eofchk			;<22>See if we are done
$dne:	jmp	$irqexit		;All done
	page
;	Here we handle the interrupt request for the recorder
;	The areas beyond the safety zone need to be copied to the user
;	buffer

$recirq:inc	byte ptr circleirq	;<33>ATOMIC************
	mov	dx,MERRYGO_SPLIT	;<30>Size of non-safety area
	call	recoffload		;<30>Shift this much data out of
					;<30>queue, or space remaining
					;<30>in user buffers, whichever is
					;<30>less.
	jz	$moreroom		;<30>Everything worked

;	Here there was not enough room for the non-safety area data
;	in the remaining buffers (now none), so forget about the
;	safety area.

	call	snd_dma_stop		;<29>

	and	byte ptr snd_mode,NOT (INRECORD)	;<32>
	jmp	$irqexit		;Get outta here

$moreroom:
	call	snd_rec_offl		;<31>Try to set more buffers up
	call	snd_rec_buf		;<31>As it is possible to use
					;<31>the active and NEXT in a
					;<31>single operation.
	call	record_safety		;Note that record_safety 
					;may take us out of record mode
					;so don't expect us to still be in
					;record when we get back.
	mov	ax,snd_mode		;<29>Get machine state
	test	ax,DISKRECORD		;<29>Is this disk record?
	jz	$dne1			;<29>Nope, normal world
	les	si,indos		;<29>
	cmp	word ptr es:[si],0	;<29>
	jnz	$dne2			;<29>Skip disk I/O
	call	snd_disk_wr		;<29>
$dne2:	call	snd_rec_offl		;<31>
	call	snd_rec_buf		;<31>Do what we can
$dne1:	mov	dx,DacBase		;Reactivate interrupts
	in	al,dx
	and	al,07fh
	or	al,18h
	out	dx,al
	jmp	$irqexit		;All done

player_irq	endp
	page
;	This routine transfers data from the non-safety area of the
;	circular buffer into user buffers, splitting transfers
;	if necessary.  
;<30>	DX contains the number of bytes to consider in non-safety area.
;<30>	snd_stop can call with less than the full amount.

	public	recoffload
recoffload	proc	near
	xor	bx,bx			;<32>Zero offset

;	This determines whether the source amount (in DX) will fit
;	in the target buffer or if it has to be broken up.

$recnext:
	mov	cx,word ptr rec_len[2]	;Get MSW of length
	or	cx,cx			;Is there a lot to do?
	jnz	$docopy			;No need to worry about size
	mov	cx,word ptr rec_len	;Get LSW
	cmp	cx,dx			;<30>How about this many?
	jnc	$docopy			;<32>Entire buffer will fit.

;	Here only a portion of the source buffer will fit in the target.
;	Fill as much as we can, try to obtain a new buffer, and see
;	if the remainder will fit in the new target buffer.
;	The breaking point could occur one byte into the non-safety
;	area, and there can be multiple breaks so the safety time
;	must be long enough to let all get new buffers into position.
;	CX is amount that will fill the current buffer.

	les	di,rec_sndaddr		;Place to put it
	push	cx			;<33>Save length to copy
	push	es			;<33>Save pointer to start of data
	push	di			;<33>

	push	ds			;<33>Do this last
	lds	si,merrygo_buf		;<33>
	add	si,SPLIT_FILL_BYTES
	add	si,bx			;<32>Add in offset (norm zero)
	sub	dx,cx			;<32>Subtract amount already done.
					;<32>DX amount to do
	add	bx,cx			;<32>BX is amount done so far
					;<32>(used as displacement ptr)
	call	snd_fragmove
	pop	ds
	pop	di			;<33>Restore original pointers
	pop	es			;<33>
	pop	cx			;<33>and length
	call	rec_convert		;<34>Convert area in target buffer
					;<34>that was used
	jz	$datused1
	xor	ax,ax			;<33>Don't keep this data
	ret				;<33>Fail to update target pointers

$datused1:				;<33>Use data, so switch buffers
	push	dx			;<30>Save callers parameter
	call	get_rec_next
	pop	dx			;<32>Put value where it is needed
	jz	$recstop		;No more buffers, stop here

;	We now have a new buffer and BX is the number of bytes moved
;	into the previous buffer(s), and DX is the remaining amount
;	of the original request

	jmp short	$recnext	;<32>See if new buffer has enough
					;<32>space

;	Here there is enough bytes in the target area to accept
;	the entire non-safety area.
;	DX is amount to load into buffer.

$docopy:mov	cx,dx			;<30>
	les	di,rec_sndaddr		;Place to put it
	push	cx			;<33>Save length to copy
	push	es			;<33>Save pointer to start of data
	push	di			;<33>

	push	ds
	lds	si,merrygo_buf
	add	si,SPLIT_FILL_BYTES
	add	si,bx			;<32>Add in offset (norm zero)

	call	snd_fragmove		;<29>

	pop	ds
	pop	bx			;<33>Hold original di
	pop	ax			;<33>Hold original es
	pop	cx			;<33>Hold original cx
	call	round_esdi		;<11>
	push	es			;<33>Save end of xfer pointer
	push	di			;<33>

	mov	es,ax			;<33>Get start of xfer pointer
	mov	di,bx			;<33>
	call	rec_convert		;<33>
	pop	di			;<33>Restore end of xfer pointer
	pop	es			;<33>
	jz	$datused2
	xor	ax,ax			;<33>Don't keep this data
	ret				;<33>Fail to update target pointers

$datused2:				;<33>Use data, so switch buffers
	mov	word ptr rec_sndaddr,di
	mov	word ptr rec_sndaddr[2],es	;Store new starting addr

	mov	ax,dx			;<30>Was MERRYGO_SPLIT
	call	rec_count
	jz	$recfull		;Time to change buffers
$noxfer3:
	xor	ax,ax			;<30>Normal exit  - Z condition
	ret				;All done with non-safety area
	
;	Here the current buffer has been completely filled.  See
;	if there is another buffer.  If not, shut record down.

$recfull:
	call	get_rec_next
	jnz	$noxfer3		;<30>

$recstop:
	or	ax,1			;<30>Time to stop - no more room.
	ret				;<30> NZ condition

recoffload	endp

;	Handle transfer of an odd number of bytes

	public	snd_fragmove
snd_fragmove proc near
	shr	cx,1
	jnc	$dobulk
	movsb				;Move odd byte
$dobulk:rep	movsw			;Now move words
					;<14>According to the song book,
					;<14>REP tests for CX=0 before
					;<14>performing any operations,
					;<14>so no special check is required.
$nodata:ret

snd_fragmove endp

sndseg	ends
	end

