/*---------------------------------------------------------------------------*/
/*                         Main Menu Bar for DeskMate                        */
/*---------------------------------------------------------------------------*/
#include "csrbase.h"
#include "csrkeys.h"
#include "csrvid.h"
#include "csrcmps.h"

/*---------------------------------------------------------------------------*/
/*                              MENU BAR STRINGS                             */
/*---------------------------------------------------------------------------*/
char sMenu0[] = "File";

char sM0Item0 [] = "Open...";
char sM0Item1 [] = "Save As...";
char sM0Item2 [] = "Exit       Esc";

char sMenu1[] = "Sound";

char sM1Item0 [] = "Record...  Ctrl+R";
char sM1Item1 [] = "Play back  Ctrl+P";

/*---------------------------------------------------------------------------*/
/*                              MENU BAR DEFINES                             */
/*---------------------------------------------------------------------------*/
#define OPEN_INDEX		0
#define SAVE_AS_INDEX		1
#define EXIT_INDEX		2
#define RECORD_INDEX		0
#define PLAY_BACK_INDEX		1
#define MENU0COUNT		3
#define MENU1COUNT		2
#define MENU0_APP_TAG		APP_TAG + 100
#define MENU1_APP_TAG		APP_TAG + 200
#define OPEN			(MENU0_APP_TAG + OPEN_INDEX)
#define SAVE_AS			(MENU0_APP_TAG + SAVE_AS_INDEX)
#define EXIT			(MENU0_APP_TAG + EXIT_INDEX)
#define RECORD			(MENU1_APP_TAG + RECORD_INDEX)
#define PLAY_BACK		(MENU1_APP_TAG + PLAY_BACK_INDEX)

/*-----------------*/
/* Items in Menu0. */
/*-----------------*/
MENUITEM menu0items[]=
{
/* open */
MB_STRING, ENABLED,
MB_UNCHECKED, MB_ACCEL, OPEN, MB_GROUP1, MB_PATTERN, sM0Item0,
/* save as */
MB_STRING, ENABLED,
MB_UNCHECKED, MB_ACCEL, SAVE_AS, MB_GROUP1, MB_PATTERN, sM0Item1,
/* exit */
MB_STRING, ENABLED,
MB_UNCHECKED, EC_QUIT, EXIT,  MB_GROUP1, MB_PATTERN, sM0Item2,
};

/*-----------------*/
/* Items in Menu1. */
/*-----------------*/
MENUITEM menu1items[]=
{
/* record */
MB_STRING, ENABLED,
MB_UNCHECKED, CTRL_R, RECORD,  MB_GROUP1, MB_PATTERN, sM1Item0,
/* playback */
MB_STRING, DISABLED,
MB_UNCHECKED, CTRL_P, PLAY_BACK,  MB_GROUP1, MB_PATTERN, sM1Item1,
};

/*-----------------------------*/
/* Items on the MAIN MENU BAR. */
/*-----------------------------*/
MENU menus [] =
{
(MB_BASE_XEXT + 14 * CHAR_XEXT), sMenu0, MENU0COUNT, menu0items,
(MB_BASE_XEXT + 17 * CHAR_XEXT), sMenu1, MENU1COUNT, menu1items,
};

/*--------------------*/
/* MENUBAR structure. */
/*--------------------*/
MENUBAR menubar =
{
CMP_MENUBAR, ENABLED,
MB_XORG, MB_YORG, MB_XEXT, MB_YEXT,
NO_ACCEL, CSR_NULL,
MB_TANDY + MB_ALARM,
MB_NO_REDRAW, 2, menus
};

/*---------------------------------------------------------------------------*/
/*                           END OF MENU STRUCTURES                          */
/*---------------------------------------------------------------------------*/
