# include <stdio.h>
# include <conio.h>
# include "sound.h"
# include "dgetbuf.h"
# include "dplay.h"
# include "csrbase.h"
# include "csrcmps.h"

/*
 *	This routine plays back a sound in the memory allocated by
 *	set_up_buffers() and loaded by something.
 */

# ifdef __STDC__
void do_playback_sound(void)
# else
void do_playback_sound()
# endif
{
	int        i;
	SNDHDR far * shp;
	MSGBOX     msg;

	/* Set message title and button combinations for play back messages */
	msg.pString = "Play Back";
	msg.btn_combo = MSG_COMBO_OK;

	/* prompt operator and wait for response */
	msg.pMessage = "Press ENTER to start playback.";
	msg_run( &msg );

	/* Disable the busy icon during play back */
	vid_busy_disable();

	/* for each buffer */
	for (i = 0; i < numbuffers; i++)
	{
		shp = sndheaders[i];	/* get SNDHDR struct address */
		if (shp->sndp->sndlen > 0)	/* if there is sound in
										the buffer */
		{
			/* play sound at same rate it was recorded */
			shp->rate = shp->sndp->rate;

			/* start and end in the SNDHDR struct have already */
			/* been set to zero (play entire buffer) */
			/* play this buffer */
			snd_play(shp);
		}
	}
	snd_wait((SNDHDR far *) 0, (short) 1);	/* wait for playing to finish */

	/* Reenable the busy icon */
	vid_busy_enable();
	return;
}
