#!/bin/bash

#WARNING: This script MUST be sourced.
#If buffer is missing, we need to bootstrap, because script is not 
# sourced.

if [ "${BUFFER}" = "" ]; then
	echo ERROR! No buffer, bootstrapping!
	source ./bootstrap.sh
fi
#No camera identifier - called from menu
if [ -z "$CAM1" ] || [ -z "$CAM2" ]; then
	PORTS=$(gphoto2 --list-ports | grep usb)
	#PORTS=$(gphoto2 --list-ports)
	DIALOG --title "Select camera..." \
	--inputbox "These are USB PTP cameras in your system:\n \
	$PORTS\n\nType two numbers of cameras separated by spaces.\nE.g. \
	003 002 if we have usb:001,003 and usb:001,002 cameras. \n" 20 70 \
	2>/tmp/cams.tmp
	#user aborts
	if [ ! -s "/tmp/cams.tmp" ]; then
		source ./M.sh
	fi
	#Camera descriptors
	CAM1=$(cat /tmp/cams.tmp | awk '{ print $1 }')
	CAM1="usb:001,"$CAM1
	CAM2=$(cat /tmp/cams.tmp | awk '{ print $2 }')
	CAM2="usb:001,"$CAM2
fi

echo "RETRIEVING"
Prev=$PWD
mkdir $BUFFER/cam1
mkdir $BUFFER/cam2
cd $BUFFER/cam1
gphoto2  --port "$CAM1" --get-all-files
cd $BUFFER/cam2
gphoto2  --port "$CAM2" --get-all-files
cd $Prev
echo Completed! Press Retun to continue
beep
read

return
