#!/bin/bash
#LightBSC Bootstrap script
# 2015 MCbx

#This script contains main configuration
#It verifies basic functions and calls menu.
#This should be the only .sh file to be modified
# DEVELOPERS: All configuration should be set from here.

#################
# CONFIGURATION #
#################
export BUFFER=~/buffer
export LBVERSION=0.1
export TITLE="LightBSC v. $LBVERSION"


#################
#   BOOTSTRAP   #
#################

echo $BUFFER >/tmp/buffer
echo $TITLE >/tmp/title

#Generate dialog
DIALOG() {
	dialog --backtitle "$TITLE" "$@"
	return $?
}


#To conserve memory, this script sets all
#variables as exports, launches menu
#and then shuts down. If you want to spin
#something, do it in menu.

#Generate dialogrc. This is for color setting
export DIALOGRC=./dialog.rc

#Check buffer. We shouldn't fail it.
echo -n Checking buffer...
if [ -d "$BUFFER" ]; then
	echo OK
else
	mkdir "$BUFFER"
	echo Created
fi

#check packages
echo -n Checking Dialog...
dialog -v >/dev/null 2>&1 || { 
	echo ERROR;
	echo >&2 "Dialog is required. Exiting"; 
	exit 1; 
}
echo OK
#TODO: Other packages?

#Greeter
if [ -f "./welcome.msg" ]; then
	DIALOG --title "Start" --msgbox "$(cat welcome.msg)" 20 70
fi

#spawn menu
source ./M.sh
