//#include <SoftwareSerial.h>

#include "PS2Keyboard.h"
#include "ps2.h"
#include "keymap.h"

//TESTS:
//
// KEYBOARD: OK
// MOUSE: Relative: OK
// MOUSE: Absolute: Not tested
// MOUSE: Keycode mode: Not tested
// JOY: NOT TESTED, only default mode.
//
// TO BE IMPLEMENTED:
//  - Memory
//  - Joystick key mode
//  - Bugfixes! This code has LOTS of bugs!
//
// 2018, MCbx,  GPL. License
// Copying as specified in GPL. 
// Yes, Ki. and Ol., I have an eye on you :).

//DEFINITIONS
#define KEY_DATA 2
#define KEY_CLK 3
#define MOU_DATA 5
#define MOU_CLK 4


#define JOY0_UP 6
#define JOY0_DOWN 7
#define JOY0_LEFT 9
#define JOY0_RIGHT 8
#define JOY0_FIRE 10

#define JOY1_UP A1
#define JOY1_DOWN A2
#define JOY1_LEFT A4
#define JOY1_RIGHT A3
#define JOY1_FIRE A5


#define LED 13

//INFORMATION
//There is a problem getting the proper PS2Keyboard library. 
//the ready-made ZIP is not present anywhere. The version I'm
//using must be supplied with this file. It's 2.4 +Git patches.

//Alternatively there's a code for PS2 lib, but it's locking.
//it should be patched not to be locking.

//GLOBAL ASSIGNMENTS
PS2Keyboard PCKeyboard;
PS2 PCMouse(MOU_DATA, MOU_CLK); //we talk directly to mouse

//GLOBAL VARIABLES

//Mouse
bool mouseAbsolute=0;  //absolute mode
unsigned int absoluteX;
unsigned int absoluteY; //absolute positions
byte x_scale=1;
byte y_scale=1; //absolute: scale ticks
unsigned int absoluteXMax=65535;
unsigned int absoluteYMax=65535; //absolute maximum
byte absoluteClicksX=0;
byte absoluteClicksY=0; //absolute number of comitted mouse clicks in any direction

byte mouseButtonRegister=0; //button FUNCTION register as 0x07

bool mouseRelative=1; //relative mode
byte relativeXThreshold=1; //relative threshold to report
byte relativeYThreshold=1; 

bool mouseKeycode=0; //keycode mode
byte keycodeXThreshold=1; //thresholds for keycode. This ought to be settable?
byte keycodeYThreshold=1;
byte buttonInterrogationState=0; 
bool invertY=0; //From experiment: This is INVERTED iteslf - multiply Y by -1 when 0.

bool prevLeft=0; //previous positions
bool prevRight=0;

//port
bool transmitEnable=1; //shall we spit data at all?

//RTC
unsigned long milRTC=0;
byte ye=0;
byte mo=0;
byte da=0;
byte ho=0;
byte mi=0;
byte se=0; //RTC states, year, month, day, hour, minute, second

//JOY
bool joyReporting=1;
byte joyMonitorRate=0; //0 - not going
bool joyReportFire=0;
bool joyKeycode=0;
byte joyRX=0;
byte joyRY=0;
byte joyTX=0;
byte joyTY=0;
byte joyVX=0;
byte joyVY=0; //for T-F curve, this is NOT IMPLEMENTED.

byte joy1=0;
byte joy0=0; //joy states for packaging

//byte memory[128];

//Decode PS2 code into Atari
void reencode(byte scancode, bool isEscaped, bool isReleased)
{
   byte k=0;
   scancode=scancode-1;
   if (isEscaped)
   {
    scancode=scancode+115;
   }
   k=keymap[scancode];

   if (k==0) //fault fault fault
   {
     return;
   }
   
   if (isReleased) //push bit 7
   {
     k=bitSet(k,7);
   }
    
   if (transmitEnable) Serial.write(k); //finally
 //  Serial.println(k,HEX); //debug
   return;
}

//Atari-compliant reset procedure
void reset()
{
 //reset to default mode and settings. Mouse: Relative, constant reporting.
 mouseButtonRegister=0;
 mouseRelative=1;
 mouseAbsolute=0;
 mouseKeycode=0;
 x_scale=1;
 y_scale=1;
 absoluteX=0;
 absoluteY=0; 
 relativeXThreshold=1;
 relativeYThreshold=1;
 absoluteXMax=65535;
 absoluteYMax=65535;
 keycodeXThreshold=1;
 keycodeYThreshold=1; 
 buttonInterrogationState=0;
 absoluteClicksX=0;
 absoluteClicksY=0;
 invertY=0;

 joyReporting=1;
 joyMonitorRate=0; //0 - not going
 joyReportFire=0;
 joyKeycode=0;
 joyRX=0;
 joyRY=0;
 joyTX=0;
 joyTY=0;
 joyVX=0;
 joyVY=0;

 //for (byte i=0;i<128;i++)
 //{
 // memory[i]=0;
 //}
  
 //TODO: check for stuck keys. If yes, send them as error (is it implemented in Atari?)
 
 digitalWrite(LED,!digitalRead(LED));
 Serial.write(0xF0); //confirmed.

}

//INITIALIZAITON
void setup() {
  pinMode(LED,OUTPUT);
  digitalWrite(LED,HIGH);
 // Serial.begin(9600); //this is for debug
  Serial.begin(7812); //this is for A.
  
  //Initialize keyboard
  PCKeyboard.begin(KEY_DATA,KEY_CLK);
  
  //Initialize mouse
  PCMouse.write(0xff);
  PCMouse.read(); PCMouse.read(); PCMouse.read(); //0xFAck nul nul
  PCMouse.write(0xf0); //remote mode
  PCMouse.read(); //ack
  delayMicroseconds(100); 
  digitalWrite(LED,LOW);

  pinMode(JOY0_DOWN,INPUT_PULLUP);
  pinMode(JOY0_UP,INPUT_PULLUP);
  pinMode(JOY0_LEFT,INPUT_PULLUP);
  pinMode(JOY0_RIGHT,INPUT_PULLUP);
  pinMode(JOY0_FIRE,INPUT_PULLUP);
  pinMode(JOY1_DOWN,INPUT_PULLUP);
  pinMode(JOY1_UP,INPUT_PULLUP);
  pinMode(JOY1_LEFT,INPUT_PULLUP);
  pinMode(JOY1_RIGHT,INPUT_PULLUP);
  pinMode(JOY1_FIRE,INPUT_PULLUP);

PCMouse.write(0xe8); 
PCMouse.write(0x03); //initialize mouse reso. 03 - 8clicks/mm, 02 - 4clicks/mm, 01 - 2clicks/mm, 00 - 1click/mm.
//According to manual it should be around 10, it's 8. a bit slow but works.
  reset();
}


//send relative reporting packet
void sendMousePackage(char x, char y, bool left, bool right)
{
//  digitalWrite(LED,!digitalRead(LED));
  byte a=0xFF;
  a=bitClear(a,2);
  a=bitWrite(a,1,left);
  a=bitWrite(a,0,right);
  Serial.write(a);
 //Serial.println(a,BIN);
  Serial.write(x);
  Serial.write(y);
}

//send absolute reporting packet
void reportAbsolute() //report absolute position of mouse
{
  if (transmitEnable)
  {
      Serial.write(buttonInterrogationState);
      Serial.write(lowByte(absoluteX));
      Serial.write(highByte(absoluteX));
      Serial.write(lowByte(absoluteY));
      Serial.write(highByte(absoluteY));
  }
      buttonInterrogationState=0;
}

///////////////////////////////////
//        M  O  U  S  E          //
//      Mouse support routine    //
// Call this and mouse will work //
///////////////////////////////////
void mouseSupport()
{
   PCMouse.write(0xeb);  // Interrogate mouse
  PCMouse.read();      // ACK
  byte mstat = PCMouse.read();
  char mx = PCMouse.read();
  char my = PCMouse.read();
  if (!invertY) //From Experiment: "Invert Y" works inverted - it's **DO NOT** invert Y.
  {
    my=my*-1;
  }
  
  bool sender=0; //have data changed and shall we send the package?
  
  if ((mx!=0)||(my!=0))  //mouse moved in X or Y
  {
     sender=1;
  }
  absoluteClicksX+=abs(mx); //absolute positioning increase
  absoluteClicksY+=abs(my);
  
  if ((bitRead(mstat,0)!=prevLeft)) //buttons click left
  {
    if (prevLeft==0) //for absolute/interrogation mode - if pressed
    {
      bitSet(buttonInterrogationState,2); //button pressed
      if ((mouseKeycode)||(bitRead(mouseButtonRegister,2)))
      {
        if (transmitEnable) Serial.write(0x74);
      }
      if ((mouseAbsolute)&&(bitRead(mouseButtonRegister,0))) //absolute register made from set at 0x07
      {
        reportAbsolute();
      }
    }
    else //if released
    {
      bitSet(buttonInterrogationState,3);
      if ((mouseKeycode)||(bitRead(mouseButtonRegister,2)))
      {
        if (transmitEnable) Serial.write(0xF4);
      }
      if ((mouseAbsolute)&&(bitRead(mouseButtonRegister,1))) //report absolute when clicked and mode set at 0x07
      {
        reportAbsolute();
      }
    }
    prevLeft=bitRead(mstat,0);
    sender=1;
  }
  
  if ((bitRead(mstat,1))!=prevRight) //right button
  {
    if (prevRight==0) //for absolute/interrogation mode - if PRessed
    {
      bitSet(buttonInterrogationState,0); //button pressed
      if ((mouseKeycode)||(bitRead(mouseButtonRegister,2)))
      {
        if (transmitEnable) Serial.write(0x75);
      }
      if ((mouseAbsolute)&&(bitRead(mouseButtonRegister,0))) //report absolute when clicked and mode set at 0x07
      {
        reportAbsolute();
      }
    }
    else //if released
    {
      bitSet(buttonInterrogationState,1);
      if ((mouseKeycode)||(bitRead(mouseButtonRegister,2)))
      {
        if (transmitEnable) Serial.write(0x75);
      }
      if ((mouseAbsolute)&&(bitRead(mouseButtonRegister,1))) //report absolute when clicked and mode set at 0x07
      {     
        reportAbsolute();           //TODO: Check these 4 cases don't they report previous values.
      }
    }
    prevRight=bitRead(mstat,1);
    sender=1;
  }

if (!transmitEnable) //do not send when trnasmitting is prohibited
  sender=0;
  
  //send relative value is relative mode on
  if((sender)&&(mouseRelative)&&(!mouseAbsolute)&&(!mouseKeycode))
  {
    if ((absoluteClicksX>=relativeXThreshold)||(absoluteClicksY>=relativeYThreshold)||(bitRead(mstat,0))||(bitRead(mstat,1)))
    {
      absoluteClicksX=0;
      absoluteClicksY=0;
      sendMousePackage(mx,my,bitRead(mstat,0),bitRead(mstat,1)); //TODO: mouse threshold before - 0x0B
      sender=0;
    }
  }

//key mode
  if ((sender) && (mouseKeycode))
  {
    if (absoluteClicksX>keycodeXThreshold) //todo - previous position - check
    {
      absoluteClicksX=0;
      if (mx>0)
      {
        Serial.write(0x4D); Serial.write(0xCD);
      } else {
        Serial.write(0x4B); Serial.write(0xCB);
      }
    }
    if (absoluteClicksY>keycodeYThreshold)
    {
      absoluteClicksY=0;
      if (my>0)
      {
        Serial.write(0x48); Serial.write(0xC8);
      } else {
        Serial.write(0x50); Serial.write(0xD0);
      }
    }
  }
  sender=0; //do not preserve sending option

//compute the absolute value
  mx=mx/x_scale;
  my=my/y_scale; //scale is only for absolute mode.
  unsigned int pAbsX=absoluteX;
  absoluteX+=mx;
  if((absoluteX>pAbsX)&&(mx<0))
  {
    absoluteX=0; 
  }
  if((absoluteX<pAbsX)&&(mx>0))
  {
    absoluteX=absoluteXMax; 
  }
  pAbsX=absoluteY;
  absoluteY+=my;
  if((absoluteY>pAbsX)&&(my<0))
  {
    absoluteY=0; 
  }
  if((absoluteY<pAbsX)&&(my>0))
  {
    absoluteY=absoluteYMax; 
  }

}


//MAIN LOOP
void loop() {

/////////////////
//    RTC      //
/////////////////
if (millis()-milRTC>1000)
{

  milRTC=millis();
  se++;
  if (se==60)
  {
    se=0;
    mi++;
  }
  if (mi==60)
  {
    mi=0;
    ho++;
  }
  if (ho==24)
  {
    ho=0;
    da++;
  }
  if ((mo==2)&&(da==29))
  {
    mo++;
    da=1;
  }
  if (((mo==3)||(mo==5)||(mo==7)||(mo==9)||(mo==11)) && (da==31) )
  {
    mo++;
    da=1;
  }
  if (((mo==1)||(mo==4)||(mo==6)||(mo==8)||(mo==10)||(mo==12)) && (da==32) )
  {
    mo++;
    da=1;
  }
  if (mo==13)
  {
    ye++;
    mo=1;
  }
  if (ye==100)
  {
    ye=0;
  }
}

//JOYSTICK - monitor fire or complete
if (joyReportFire)
{
  byte kk=0;
  for (byte bb=0;bb<8;bb++)
  {
    kk=bitWrite(kk,bb,!digitalRead(JOY1_FIRE));
    delayMicroseconds(100);
  }
  Serial.write(kk);
  return; //TODO: Test do we need to monitor serial?
}
if(joyMonitorRate>0)
{
      byte a=0;
      a=bitWrite(a,1,!digitalRead(JOY0_FIRE));
      a=bitWrite(a,0,!digitalRead(JOY1_FIRE));
      Serial.write(a);
      a=bitWrite(a,0,!digitalRead(JOY1_UP));
      a=bitWrite(a,1,!digitalRead(JOY1_DOWN));
      a=bitWrite(a,2,!digitalRead(JOY1_RIGHT));
      a=bitWrite(a,3,!digitalRead(JOY1_LEFT));
      a=bitWrite(a,4,!digitalRead(JOY0_UP));
      a=bitWrite(a,5,!digitalRead(JOY0_DOWN));
      a=bitWrite(a,6,!digitalRead(JOY0_RIGHT));
      a=bitWrite(a,7,!digitalRead(JOY0_LEFT));
      Serial.write(a);
      delay(joyMonitorRate*10);
      return;
}
  
/////////////////
//  KEYBOARD   //
/////////////////
 if (PCKeyboard.available())
 {
    bool escaped=0;
    bool released=0;
    byte scancode=PCKeyboard.readScanCode();
    if (scancode!=0)
    {
      if (scancode==0xF0) //key released
      {
        scancode=0;
        while (scancode==0) //kb controller is thinking spitting zeros
        {
          scancode=PCKeyboard.readScanCode();
        }
        released=1;
      }
     
      if (scancode==0xE0) //escaped
      {
        scancode=0;
        while (scancode==0)
        {
           scancode=PCKeyboard.readScanCode();
        }
        escaped=1;
        if (scancode==0xF0) //Escaped and released
        {
          scancode=0;
          while (scancode==0)
          {
            scancode=PCKeyboard.readScanCode();
          }
          released=1;  
        }
      }
      reencode(scancode,escaped,released);
   //   Serial.println(scancode,HEX);
    }
 }
 
 
/////////////////
//    MOUSE    //
/////////////////
mouseSupport();
 

/////////////////
//  JOYSTICK   //
/////////////////

byte joy1a=0;
joy1a=bitWrite(joy1a,7,!digitalRead(JOY1_FIRE));
joy1a=bitWrite(joy1a,0,!digitalRead(JOY1_UP));
joy1a=bitWrite(joy1a,1,!digitalRead(JOY1_DOWN));
joy1a=bitWrite(joy1a,2,!digitalRead(JOY1_RIGHT));
joy1a=bitWrite(joy1a,3,!digitalRead(JOY1_LEFT));
byte joy0a=0;
joy0a=bitWrite(joy0a,7,!digitalRead(JOY0_FIRE));
joy0a=bitWrite(joy0a,0,!digitalRead(JOY0_UP));
joy0a=bitWrite(joy0a,1,!digitalRead(JOY0_DOWN));
joy0a=bitWrite(joy0a,2,!digitalRead(JOY0_RIGHT));
joy0a=bitWrite(joy0a,3,!digitalRead(JOY0_LEFT));
if (joy0a!=joy0)
{
    if (joyReporting)
    {
      Serial.write(0xFE);
      Serial.write(joy0a);
    }
    if (joyKeycode)
    {
      if (bitRead(joy0a,7))
      {
        //fire?
      }
      if (bitRead(joy0a,0))
      {
        Serial.write(0x48); //up
        Serial.write(0xC8);
      }
      if (bitRead(joy0a,1))
      {
        Serial.write(0x50);
        Serial.write(0xD0);//down
      }
      if (bitRead(joy0a,2))
      {
        Serial.write(0x4D); //right
        Serial.write(0xCD);
      }
      if (bitRead(joy0a,3))
      {
        Serial.write(0x4B); //left
        Serial.write(0xCB);
      }
    }
  joy0a=joy0;
}

if (joy1a!=joy1)
{
    if (joyReporting)
    {
      Serial.write(0xFF);
      Serial.write(joy1a);
    }
  joy1a=joy1;
}


} //loop

uint8_t bcd2bin (uint8_t val) { return val - 6 * (val >> 4); }
uint8_t bin2bcd (uint8_t val) { return val + 6 * (val / 10); }

void sendZeros(byte count)
{
  for (byte i=0;i<count;i++)
  {
    Serial.write(0);
  }
}

//PARSE SERIAL PROTOCOL
//WARNING: It sends VERY slowly. Wait for each byte!
void serialEvent() 
{
  while (Serial.available()) 
  {
    byte k=Serial.read();
    transmitEnable=1;
    if (k==0x80) //RESET ROUTINE
    {
      while(!Serial.available()) { }
      k=Serial.read();
      if (k==0x01)
      {
        reset;
      }
    }
    if (k==0x07) //SET MOUSE BTN REGISTER
    {
      while(!Serial.available()) { }
      k=Serial.read();
      mouseButtonRegister=k;
    }
    if (k==0x08) //SET MOUSE RELATIVE REPORTING
    {
      mouseAbsolute=0;
      mouseKeycode=0;
      mouseRelative=1;
    }
    if (k==0x09) //SET ABSOLUTE MOUSE POSITIONING
    {
      mouseAbsolute=1;
      mouseKeycode=0;
      mouseRelative=0;
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteXMax=k;
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteXMax=absoluteXMax|(k << 8);
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteYMax=k;
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteYMax=absoluteYMax|(k << 8);
    }
    if (k==0x0A) //SET MOUSE KEYCODE MODE
    {
      mouseAbsolute=0;
      mouseKeycode=1;
      mouseRelative=0;
      while(!Serial.available()) { }
      keycodeXThreshold=Serial.read();
      while(!Serial.available()) { }
      keycodeYThreshold=Serial.read();
    }
    if (k==0x0B) //SET RELATIVE MOUSE THRESHOLD
    {
      while(!Serial.available()) { }
      relativeXThreshold=Serial.read();
      while(!Serial.available()) { }
      relativeYThreshold=Serial.read();
    }
    if (k==0x0C) //SET MOUSE SCALE for ABSOLUTE POSITIONING
    {
      while(!Serial.available()) { }
      x_scale=Serial.read();
      while(!Serial.available()) { }
      y_scale=Serial.read();
    }
    if ((k==0x0D)&&(!mouseRelative)&&(mouseAbsolute)&&(!mouseKeycode))  //INTERROGATE MOUSE POSITION
    {
       reportAbsolute();
       buttonInterrogationState=0;
    }
    if (k==0x0E) //LOAD ABSOLUTE MOUSE POSITION
    {
      while(!Serial.available()) { }
      k=Serial.read();
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteX=k;
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteX=absoluteX|(k << 8);
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteY=k;
      while(!Serial.available()) { }
      k=Serial.read();
      absoluteY=absoluteY|(k << 8);
    }
    if (k==0x0F) //INVERT Y - Y ZERO AT BOTTOM
    {
      invertY=1;
    }
    if (k==0x10) //SET Y NORMAL
    {
      invertY=0;
    }
    if (k==0x11) //RESUME SENDING FROM 0x13
    {
      //transmit enable already set when receiving command.
    }
    if (k==0x12) //DISABLE MOUSE
    {
      mouseAbsolute=0;
      mouseKeycode=0;
      mouseRelative=0;
    }
    if (k==0x13) //STOP SENDING
    {
      transmitEnable=0;
    }

    if (k==0x14)  //JOYSTICK EVENT REPORTING
    {
      joyReporting=1;
      joyMonitorRate=0;
      joyReportFire=0;
      joyKeycode=0;
    }
    if (k==0x15) //JOYSTICK INTERROGATION MODE
    {
      joyReporting=0;
      joyMonitorRate=0;
      joyReportFire=0;
      joyKeycode=0;      
    }
    if (k==0x16) //INTERROGATION
    {
      byte a=0;
      a=bitWrite(a,1,!digitalRead(JOY0_FIRE));
      a=bitWrite(a,0,!digitalRead(JOY1_FIRE));
      Serial.write(a);
      a=bitWrite(a,0,!digitalRead(JOY1_UP));
      a=bitWrite(a,1,!digitalRead(JOY1_DOWN));
      a=bitWrite(a,2,!digitalRead(JOY1_RIGHT));
      a=bitWrite(a,3,!digitalRead(JOY1_LEFT));
      a=bitWrite(a,4,!digitalRead(JOY0_UP));
      a=bitWrite(a,5,!digitalRead(JOY0_DOWN));
      a=bitWrite(a,6,!digitalRead(JOY0_RIGHT));
      a=bitWrite(a,7,!digitalRead(JOY0_LEFT));
      Serial.write(a);
    }
    if (k==0x17) //JOYSTICK SET MONITORING
    {
      while(!Serial.available()) { }
      k=Serial.read(); 
      joyMonitorRate=k;
    }
    if (k==0x18)
    {
      joyReporting=0;
      joyMonitorRate=0;
      joyReportFire=1;
      joyKeycode=0;   
    }
    if (k==0x19) //JOYSTICK KEYCODE MODE
    {
      joyReporting=0;
      joyMonitorRate=0;
      joyReportFire=0;
      joyKeycode=1;   
      while(!Serial.available()) { }
      joyRX=Serial.read(); 
      while(!Serial.available()) { }
      joyRY=Serial.read(); 
      while(!Serial.available()) { }
      joyTX=Serial.read(); 
      while(!Serial.available()) { }
      joyTY=Serial.read(); 
      while(!Serial.available()) { }
      joyVX=Serial.read(); 
      while(!Serial.available()) { }
      joyVY=Serial.read(); 
    }
    if(k==0x1A) //DISABLE JOYSTICK
    {
      joyReporting=0;
      joyMonitorRate=0;
      joyReportFire=0;
      joyKeycode=0;  
    }

    if (k==0x1B) //SET RTC. TODO: "Blank" codes
    {
      while(!Serial.available()) { }
      k=Serial.read(); //year
      ye=bcd2bin(k);
      while(!Serial.available()) { }
      k=Serial.read(); //month
      mo=bcd2bin(k);
      while(!Serial.available()) { }
      k=Serial.read(); //day
      da=bcd2bin(k);
      while(!Serial.available()) { }
      k=Serial.read(); //hour
      ho=bcd2bin(k);
      while(!Serial.available()) { }
      k=Serial.read(); //nimute
      mi=bcd2bin(k);
      while(!Serial.available()) { }
      k=Serial.read(); //sec
      se=bcd2bin(k);
    }
    if (k==0x1C) //GET RTC
    {
      Serial.write(bin2bcd(ye));
      Serial.write(bin2bcd(mo));
      Serial.write(bin2bcd(da));
      Serial.write(bin2bcd(ho));
      Serial.write(bin2bcd(mi));
      Serial.write(bin2bcd(se));
    }
    if (k==0x20) //MEMORY UPLOAD
    {
        //TODO: Implement?
    }
    if (k==0x21) //MEMORY DOWNLOAD
    {
        //TODO: Implement?
    }
    if (k==0x21) //CONTROLLER EXECUTE
    {
        //impossible
    }
    
    ///// STATUS INQUIRIES /////
    if (k==0x87) //Mouse BR inquiry
    {
        Serial.write(0xF6); Serial.write(0x07);
        Serial.write(mouseButtonRegister);
        sendZeros(5);
    }
    if (k==0x88) //Mouse BR inquiry
    {
        Serial.write(0xF6); Serial.write(0x08);
        sendZeros(6);
    }
    if (k==0x89) //Mouse BR inquiry
    {
        Serial.write(0xF6); Serial.write(0x09);
        Serial.write(lowByte(absoluteXMax)); //XMSB
        Serial.write(highByte(absoluteXMax)); //XLSB
        Serial.write(lowByte(absoluteYMax)); //YMSB
        Serial.write(highByte(absoluteYMax)); //YLSB
        sendZeros(2); 
    }
    if (k==0x8A) //Mouse BR inquiry
    {
        Serial.write(0xF6); Serial.write(0x0A);
        Serial.write(keycodeXThreshold); 
        Serial.write(keycodeYThreshold); 
        sendZeros(4);
    }
    if (k==0x8B) //rel threshold
    {
        Serial.write(0xF6); Serial.write(0x0B);
        Serial.write(relativeXThreshold); 
        Serial.write(relativeYThreshold); 
        sendZeros(4);
    }
    if (k==0x8C) //scale
    {
        Serial.write(0xF6); Serial.write(0x0C);
        Serial.write(x_scale); 
        Serial.write(y_scale); 
        sendZeros(4); 
    }
    if ((k==0x8F)||(k==0x90)) //this is unknown - inverse Y?
    {
        Serial.write(0xF6); Serial.write(k-0x80);
        if (invertY)
          Serial.write(0x0F); 
        else
          Serial.write(0x10); 
        sendZeros(5);
    }
    if (k==0x92) //mouse disable
    {
        Serial.write(0xF6); Serial.write(0x12);
        if ((!mouseAbsolute)&&(!mouseRelative)&&(mouseKeycode))
          Serial.write(0x12);
        else
          Serial.write(0); 
        sendZeros(5);
    }
    if (k==0x94) //joy event reporting
    {
        Serial.write(0xF6); Serial.write(0x14);
        sendZeros(6);
    }
    if (k==0x99) //joy keycode mode
    {
        Serial.write(0xF6); Serial.write(0x19);
        Serial.write(joyRX); 
        Serial.write(joyRY); 
        Serial.write(joyTX); 
        Serial.write(joyTY); 
        Serial.write(joyVX);
        Serial.write(joyVY); 
    }
    if (k==0x9A) //disable joystick
    {
        Serial.write(0xF6); Serial.write(0x1A);
        if ((!joyReporting)&&(!joyMonitorRate)&&(!joyReportFire)&&(!joyKeycode))
          Serial.write(0x1A);
        else
          Serial.write(0); 
        sendZeros(5);
    }
  }
}

