use warnings;
use strict;


#Transled frame dumper
#MCbx 2015
 
#Load the file
open(my $fh, '<', $ARGV[0]);
my $row = <$fh>;
$row = <$fh>;


my $deltaTime=0; #Time increment in ms
my $intoChunk=0; #are we processing chunk itself or not
my $prevTime=0;  #To compute time increment
my $bitCount=0;      #We must get 124 bits from each chunk
my $line="";	 #one line of picture
my $addr;	#Line number
my @lines= ("","","","","","","",""); #A complete "frame" of picture
my $lineCount=0;		#We need 8 lines for a frame
my $fr=0;				#frame number, for informational purposes

while ($row = <$fh>) {
	chomp $row;
	#print "$row\n";
	my @record=split('\t',$row);
	$deltaTime=($record[0]-$prevTime)*1000;

	if ($intoChunk==0)
	{
		#check are we starting a chunk?
		if ($deltaTime>0.1)
		{
			$intoChunk=1;
			$bitCount=0;
			print "\n";
		}
	}

	if ($intoChunk==1)
	{
		#we are inside chunk. 
		if($record[1]==0)  #Clock goes active - bit is transmitted
		{
			if ($bitCount<=120) #First 120 bits - displayed data
			{
				$line=$line.$record[2];
			}
			elsif ($bitCount<122) #Always one-zero
			{
			}
			elsif ($bitCount<125) #line address
			{
				my $no = $bitCount-121;
				$addr=$addr.$record[2];
			}
						
			$bitCount++;
			if ($bitCount==125)
			{
				
				$intoChunk=0;    #line finished
				$addr=reverse($addr);
				$addr=oct("0b".$addr);
				$addr=-1*($addr-7);  #line number
				$lines[$addr]=$line;  #add line to array
				$lineCount++;		 #increment line count
				$line="";
				$addr="";
				
				if ($lineCount==7) 	#if we have a frame, let's present it to user
				{
					$lineCount=0;
					$fr++;
					foreach my $l (@lines)
					{
						$l =~ tr/1/ /;
						#$l =~ tr/0/O/;
						print $l,"\n";
					}
					print "Frame ",$fr," Press return for next one.\n";
					<STDIN>;
				}
			}
		}
	}

	$prevTime=$record[0];	

}
print $intoChunk;
#get deltas

#get to the next chunk. Chunk is started by delay on clock line
#To get trimmer working, we need to make this delay variable
#Generally, if there's 1/1 on line for >.1ms, we have to expect
#that chunk will be coming

