/*
 * $Workfile: tv_geode.c $
 * $Revision: 4 $
 * $Date: 9/08/00 12:27p $
 *
 * Copyright (c) 1999-2000 National Semiconductor Corporation.
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of National 
 * Semiconductor Corporation. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into
 * with National Semiconductor Corporation.
 * This code is supplied as is.
 *
 * This file contains routines to program the TV encoder when it is 
 * integrated onto a Geode processor.
 */

/*
 *$History: tv_geode.c $
 * 
 * *****************  Version 4  *****************
 * User: Hari         Date: 9/08/00    Time: 12:27p
 * Updated in $/Engineering Releases/Durango/gfx
 * Added the stubs for the tv functionality used for focus chip.
*/


/*-----------------------------------------------------------------------------
 * gfx_set_tv_format
 *
 * This routine sets the TV encoder registers to the specified format
 * and resolution.
 * Currently only NTSC 640x480 is supported.
 *-----------------------------------------------------------------------------
 */
#if GFX_TV_DYNAMIC
int sc1400_set_tv_format(int format, int resolution)
#else
int gfx_set_tv_format(int format, int resolution)
#endif
{
	switch (format) {
		case TV_FORMAT_NTSC :
			switch (resolution) {
				case TV_RES_640_480 :
					/* Horizontal Display start is 138
					// Total number of pixels per line is 857 */
					WRITE_VID32(SC1400_TVOUT_HORZ_TIM, 0x008a0359);
					/* Horizontal Sync Start is 848
					// Horizontal Sync End is 856 */
					WRITE_VID32(SC1400_TVOUT_HORZ_SYNC, 0x03580350);
					/* Vertical Sync Start is 1
					// Vertical Sync End is 2
					// Vertical Display Start Skew is 1
					// Vertical Display End Skew is 1 */
					WRITE_VID32(SC1400_TVOUT_VERT_SYNC, 0x05002001);
					/* Horizontal display end is 940
					// Total number of display lines per field is 240 */
					WRITE_VID32(SC1400_TVOUT_LINE_END, 0x03ac00f0);
					/* Disable vertical down scaling, take all lines */
					WRITE_VID32(SC1400_TVOUT_VERT_DOWNSCALE, 0xffffffff);
					/* HSYNC generated in the TV Encoder module 
					// The interval between resets is once every odd field
					// Flicker Filter takes 1/8 of skipped line
					// Enable Horizontal interpolation
					// Enable Horizontal up scaling 9/8
					// Disable Horizontal downscale */
					WRITE_VID32(SC1400_TVOUT_HORZ_SCALING, 0x10220700);
					/* Enable video timing
					// Reset Sub Carrier every two frames
					// Disable BLANK
					// Enable color burst
					// Add the IRE offset
					// NTSC color encoding
					// video generator timing is 525 lines / 60Hz
					// Enable FrameRef
					// VPHASE is 6, HPHASE is 0 */
					WRITE_VID32(SC1400_TVENC_TIM_CTRL_1, 0xa2e03000);
					/* Subcarrier Frequency is 3.579809MHz */
					WRITE_VID32(SC1400_TVENC_SUB_FREQ, 0x21f12000);
					/* VSTART is 3, HSTART is 113 */
					WRITE_VID32(SC1400_TVENC_DISP_POS, 0x00030071);
					/* Display size: HEIGHT is 239, WIDTH is 719 */
					WRITE_VID32(SC1400_TVENC_DISP_SIZE, 0x00ef02cf);
					break;
				case TV_RES_800_600 :
					return(GFX_STATUS_UNSUPPORTED);
				default :
					return(GFX_STATUS_BAD_PARAMETER);
			}
			break;
		case TV_FORMAT_PAL :
			return(GFX_STATUS_UNSUPPORTED);
		default :
			return(GFX_STATUS_BAD_PARAMETER);
	}
	return(GFX_STATUS_OK);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_output
 *
 * This routine sets the TV encoder registers to the specified output type.
 * Supported output types are : S-VIDEO and Composite.
 *-----------------------------------------------------------------------------
 */
#if GFX_TV_DYNAMIC
int sc1400_set_tv_output(int output)
#else
int gfx_set_tv_output(int output)
#endif
{
	switch (output) {
		case TV_OUTPUT_COMPOSITE :
			/* Analog outputs provide Y, C and CVBS
			// Low Water Mark for Y is 31
			// Low Water Mark for Cb is 15
			// Chrominance Lowpass filter is 1.3MHz
			// HUE is 3 */
			WRITE_VID32(SC1400_TVENC_TIM_CTRL_2, 0x1ff20300);
			break;
		case TV_OUTPUT_S_VIDEO :
			/* Analog outputs provide Y, C and CVBS
			// Chrominance Lowpass filter is 1.8MHz */
			WRITE_VID32(SC1400_TVENC_TIM_CTRL_2, 0x00030000);
			break;
		default :
			return(GFX_STATUS_BAD_PARAMETER);
	}
	return(GFX_STATUS_OK);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_defaults
 *
 * This routine sets all of the TV encoder registers to default values for 
 * the specified format.  Currently only NTSC is supported.
 *-----------------------------------------------------------------------------
 */
#if GFX_TV_DYNAMIC
int geode_set_tv_defaults(int format)
#else
int gfx_set_tv_defaults(int format)
#endif
{
	/* SET DEFAULTS FOR NTSC */

	WRITE_VID32(SC1400_TVOUT_HORZ_TIM, 0x00790359);
	WRITE_VID32(SC1400_TVOUT_HORZ_SYNC, 0x03580350);	
	WRITE_VID32(SC1400_TVOUT_VERT_SYNC, 0x0A002001);		
	WRITE_VID32(SC1400_TVOUT_LINE_END, 0x039C00F0);
	WRITE_VID32(SC1400_TVOUT_VERT_DOWNSCALE, 0xFFFFFFFF);
	WRITE_VID32(SC1400_TVOUT_HORZ_SCALING, 0x10220700);
	WRITE_VID32(SC1400_TVOUT_EMMA_BYPASS, 0x0002D0F0);
	WRITE_VID32(SC1400_TVENC_TIM_CTRL_1, 0xA2E03000);
	WRITE_VID32(SC1400_TVENC_TIM_CTRL_2, 0x1FF20000);
	WRITE_VID32(SC1400_TVENC_TIM_CTRL_3, 0x00000000);
	WRITE_VID32(SC1400_TVENC_SUB_FREQ, 0x21F12000);
	WRITE_VID32(SC1400_TVENC_DISP_POS, 0x00030071);
	WRITE_VID32(SC1400_TVENC_DISP_SIZE, 0x00EF02CF);

	/* ### ADD ### DEFAULTS FOR PAL */
	return(0);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_enable
 *
 * This routine enables or disables the TV output.
 *-----------------------------------------------------------------------------
 */
#if GFX_TV_DYNAMIC
int geode_set_tv_enable(int enable)
#else
int gfx_set_tv_enable(int enable)
#endif
{
	unsigned long value;
	value = READ_VID32(SC1400_DISPLAY_CONFIG);
	if (enable) value |= SC1400_DCFG_TVOUT_EN;
	else value &= ~(SC1400_DCFG_TVOUT_EN);
	WRITE_VID32(SC1400_DISPLAY_CONFIG, value);
	return(0);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_cc_enable
 *
 * This routine enables or disables the use of the hardware CC registers 
 * in the TV encoder.
 *-----------------------------------------------------------------------------
 */
#if GFX_TV_DYNAMIC
int geode_set_tv_cc_enable(int enable)
#else
int gfx_set_tv_cc_enable(int enable)
#endif
{
	unsigned long value;
	value = READ_VID32(SC1400_TVENC_CC_CONTROL);
	value &= ~(0x0005F);
	if (enable) value |= 0x51;
	WRITE_VID32(SC1400_TVENC_CC_CONTROL, value);
	return(0);
}

/*-----------------------------------------------------------------------------
 * gfx_set_tv_cc_data
 *
 * This routine writes the two specified characters to the CC data register 
 * of the TV encoder.
 *-----------------------------------------------------------------------------
 */
#if GFX_TV_DYNAMIC
int geode_set_tv_cc_data(unsigned char data1, unsigned char data2)
#else
int gfx_set_tv_cc_data(unsigned char data1, unsigned char data2)
#endif
{
	unsigned long value;
	value = data1 | (((unsigned long) data2) << 8);
	WRITE_VID32(SC1400_TVENC_CC_DATA, value);
	return(0);
}

#if GFX_TV_DYNAMIC
int geode_get_tv_enable(unsigned int *p_on)
#else
int gfx_get_tv_enable(unsigned int *p_on)
#endif
{

	return 0;
}


// ==========================================================================
//
//	TV standard

#if GFX_TV_DYNAMIC
int geode_get_tv_standard(unsigned long *p_standard)
#else
int gfx_get_tv_standard(unsigned long *p_standard)
#endif
{
	return 0;
}

#if GFX_TV_DYNAMIC
int geode_get_available_tv_standards(unsigned long *p_standards)
#else
int gfx_get_available_tv_standards(unsigned long *p_standards)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_tv_standard(unsigned long standard)
#else
int gfx_set_tv_standard(unsigned long standard)
#endif
{
		return 0;
}

// ==========================================================================
//
//	vga mode as known by the driver
#if GFX_TV_DYNAMIC
int geode_get_tv_vga_mode(unsigned long *p_vga_mode)
#else
int gfx_get_tv_vga_mode(unsigned long *p_vga_mode)
#endif

{
	return 0;
}

#if GFX_TV_DYNAMIC
int geode_get_available_tv_vga_modes(unsigned long *p_vga_modes)
#else
int gfx_get_available_tv_vga_modes(unsigned long *p_vga_modes)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_tv_vga_mode(unsigned long vga_mode)
#else
int gfx_set_tv_vga_mode(unsigned long vga_mode)
#endif
{

	return 0;
}

// ==========================================================================
//
//	tvout mode

#if GFX_TV_DYNAMIC
int geode_get_tvout_mode(unsigned long *p_tvout_mode)
#else
int gfx_get_tvout_mode(unsigned long *p_tvout_mode)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_tvout_mode(unsigned long tvout_mode)
#else
int gfx_set_tvout_mode(unsigned long tvout_mode)
#endif
{
	return 0;

}

// ==========================================================================
//
//	Sharpness

#if GFX_TV_DYNAMIC
int geode_get_sharpness(int *p_sharpness)
#else
int gfx_get_sharpness(int *p_sharpness)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_sharpness(int sharpness)
#else
int gfx_set_sharpness(int sharpness)
#endif
{
	return 0;

}

// ==========================================================================
//
// flicker filter control.

#if GFX_TV_DYNAMIC
int geode_get_flicker_filter(int *p_flicker)
#else
int gfx_get_flicker_filter(int *p_flicker)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_flicker_filter(int flicker)
#else
int gfx_set_flicker_filter(int flicker)
#endif
{

	return 0;
}

// ==========================================================================
//
//	Overscan and Position

#if GFX_TV_DYNAMIC
int geode_get_overscan(int *p_x, int *p_y)
#else
int gfx_get_overscan(int *p_x, int *p_y)
#endif
{

	return 0;
}
                           
#if GFX_TV_DYNAMIC
int geode_set_overscan(int x, int y)
#else
int gfx_set_overscan(int x, int y)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_get_position(int *p_x, int *p_y)
#else
int gfx_get_position(int *p_x, int *p_y)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_position(int x, int y)
#else
int gfx_set_position(int x, int y)
#endif
{

	return 0;
}
// ==========================================================================
//
//	Color, Brightness, and Contrast

#if GFX_TV_DYNAMIC
int geode_get_color(int *p_color)
#else
int gfx_get_color(int *p_color)
#endif
{
	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_color(int color)
#else
int gfx_set_color(int color)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_get_brightness(int *p_brightness)
#else
int gfx_get_brightness(int *p_brightness)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_brightness(int brightness)
#else
int gfx_set_brightness(int brightness)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_get_contrast(int *p_contrast)
#else
int gfx_get_contrast(int *p_contrast)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_contrast(int constrast)
#else
int gfx_set_contrast(int constrast)
#endif
{

	return 0;
}

// ==========================================================================
//
//	YC filters

#if GFX_TV_DYNAMIC
int geode_get_yc_filter(unsigned int *p_yc_filter)
#else
int gfx_get_yc_filter(unsigned int *p_yc_filter)
#endif
{
	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_yc_filter(unsigned int yc_filter)
#else
int gfx_set_yc_filter(unsigned int yc_filter)
#endif
{

	return 0;
}


#if GFX_TV_DYNAMIC
int geode_get_aps_trigger_bits(unsigned int *p_trigger_bits)
#else
int gfx_get_aps_trigger_bits(unsigned int *p_trigger_bits)
#endif
{

	return 0;
}

#if GFX_TV_DYNAMIC
int geode_set_aps_trigger_bits(unsigned int trigger_bits)
#else
int gfx_set_aps_trigger_bits(unsigned int trigger_bits)
#endif
{

	return 0;
}




/* END OF FILE */
