#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void on_fontComboBox_currentIndexChanged(const QString &arg1);

    void on_btnBold_clicked();

    void on_btnItalic_clicked();

    void on_btnUnderline_clicked();

    void on_btnForeColor_clicked();

    void on_btnBackColor_clicked();

    void on_btnLoadText_clicked();

    void on_txInput_textChanged();

    void on_sbChunkSize_valueChanged(int arg1);

    void on_sbWPM_valueChanged(int arg1);

    void on_btnStart_clicked();

    void on_btnRev_clicked();

    void on_hsSlider_valueChanged(int value);

    void proceedBurst();
    void on_sbFontSize_valueChanged(int arg1);

    void on_splitter_splitterMoved(int pos, int index);

    void on_btnOpenTex_clicked();

    void on_cbTexture_clicked(bool checked);

    void on_cbTexCenter_clicked();

    void on_cbTexTile_clicked();

    void on_btnClearClick();

    void on_cbMorphText_clicked(bool checked);

    void on_cbMorphBkg_clicked(bool checked);

    void on_btnBackStart_clicked();

    void on_btnBackEnd_clicked();

    void on_btnTextStart_clicked();

    void on_btnTextEnd_clicked();

private:
    Ui::MainWindow *ui;

    void SaveSettings();
    void LoadSettings();
    void refreshGrads();
};

#endif // MAINWINDOW_H
