#ifndef SHEETEDITOR_H
#define SHEETEDITOR_H

#include <QDialog>
#include "../testsheet.h"
#include <QString>
#include <QKeyEvent>

namespace Ui {
class SheetEditor;
}

class SheetEditor : public QDialog
{
    Q_OBJECT

public:
    explicit SheetEditor(TestSheet *sheet, QWidget *parent = 0);
    ~SheetEditor();

protected:
    void keyPressEvent(QKeyEvent * event);

private slots:
    void on_leName_textChanged(const QString &arg1);

    void on_leDescription_textChanged(const QString &arg1);

    void on_sbPinsNo_valueChanged1(int arg1);

    void on_twFirst_cellDoubleClicked(int row, int column);

    void on_twSecond_cellDoubleClicked(int row, int column);

    void on_twFirst_changed(int row, int column);

    void on_twSecond_changed(int row, int column);
    void on_twFirst_cellClicked();

    void on_twSecond_cellClicked();

    void on_btnInsertReset_clicked();

    void on_btnInsertPower_clicked();

    void on_btnInsertConfig_clicked();

    void on_btnInsertSend_clicked();

    void on_btnInsertRead_clicked();

    void on_btnLineDelete_clicked();

    void on_btnLineToBottom_clicked();

    void on_BtnLineToTop_clicked();

    void on_btnLineDown_clicked();

    void on_btnLineUp_clicked();

    void on_twScript_cellDoubleClicked(int row, int column);

private:
    void done(int r);
    Ui::SheetEditor *ui;
    TestSheet * sheet;
    void repaintPins();
    void repaintScript();
    QString CodeToStr(int code);
    int strToCode(QString str);
    QString CommandToStr(int command);
    int StrToCommand(QString command);
};

#endif // SHEETEDITOR_H
