//Copyright 2014,2015 MCbx, All rights reserved.
//http://mcbx.netne.net/ictester
//This file is part of ICTester.
//ICTester is free software; you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation; either version 2 of the License, or
//(at your option) any later version.
//ICTester is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//You should have received a copy of the GNU General Public License
//along with ICTester; if not, write to the Free Software Foundation,
//Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "r74s287.h"
#include <QByteArray>
#include "../devicedriver.h"
#include <QDebug>
#include <QString>
#include <qglobal.h>
#include "toolkit.h"

//Here you display power requirements. Nothing special, this one just types text and waits for key.
void power74s287()
{
    QTextStream cin(stdin);
    qDebug()<<"Please connect your ground to pin 12 (switch 4 on)\n and Vcc to pin 20 (switch 2 on)";
    qDebug()<<"Press Return to start, Ctrl-C aborts";
    cin.readLine();
}

QByteArray read74s287(DeviceDriver * tester, int debug)
{
    QByteArray rom;
    char readWord;

    tester->setIO("0000000111110001"); //initialize IO
    tester->powerON();

    qDebug()<<"Reading 256 words from 74S287 chip...";
    for (int i=0;i<256;i++)
    {
        QString addr=QString::number(i,2).rightJustified(8,'0'); //generate binary address
        addr=rev(addr);

        QString state=addr.mid(6,1)+addr.mid(5,1)+addr.mid(4,1)+addr.mid(3,1)+addr.mid(0,1)+addr.mid(1,1)+addr.mid(2,1)+"0"
                     +"0000"+"00"+addr.mid(7,1)+"1";

        tester->setData(state); //address and CS low goes in
        qSleep(2);


        //read word
        QString res=tester->getData().mid(4,16);

        res="0000"+res.mid(8,1)+res.mid(9,1)+res.mid(10,1)+res.mid(11,1);
        readWord=res.toInt(NULL,2);
        if ((i+1)%16==0) qDebug()<<i+1;

        if(debug)
        qDebug()<<i<<"("<<addr<<"): "<<res<<" ascii: "<<readWord<<" to "<<QString::number(readWord,2).right(8).rightJustified(8,'0');
        rom.append(readWord);

    }
    tester->reset();
    return rom;
}
