//Copyright 2014,2015..2019 MCbx, All rights reserved.
//http://oldcomputer.info/software/ictester/index.html
//This file is part of ICTester.
//ICTester is free software; you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation; either version 2 of the License, or
//(at your option) any later version.
//ICTester is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//You should have received a copy of the GNU General Public License
//along with ICTester; if not, write to the Free Software Foundation,
//Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef DEVICEDRIVER_H
#define DEVICEDRIVER_H

#include <QtSerialPort/QSerialPort>
#include <QtSerialPort/QSerialPortInfo>
#include <qstring.h>

class DeviceDriver
{
public:
    DeviceDriver(QString portName, int baudRate, int timeout);
    ~DeviceDriver();
    int changeName(QString portName);
    int changeRate(int baudRate);
    void changeTimeout(int timeout);
    int getTimeout();
    void qSleep(int ms);

    //Device handling routines
    int reset();
    int powerON();
    int setIO(QString pins);
    int setData(QString pins);
    QString getData();
    QString deviceVersion();
private:
    QSerialPort *serialConn;
    int openConn(QString portName,int baudRate);
    int Timeout;
    QByteArray getResponse(int expLength);
};

#endif // DEVICEDRIVER_H
