#!/usr/bin/perl

##################
#
# This file was automatically generated by ZooZ.pl v1.2
# on Mon Apr 27 19:04:23 2020.
# Project: Project 1
# File:    /home/mcbx/Pobrane/ZooZ-1.2/mpthree.zooz
#
##################

# SEQUENTIAL FILE COPY UTILITY v. 0.003
# MCbx 2020          GNU GPL
#
# This tool is useful when you need to copy files in order into some filesystem
# and sync every file to write filesystem table. It is useful for maintainig a consistent list  
# of photos on cheap digital photo frames or to have an ordered playlist on these
# cheapest clip-type MP3 players.
#
# Just load files, sort them as you want, set options, destination and copy.
#
# Pre/post-processing takes %f - file name, %i - counter and %n - file number (unresetrable counter). 
# Preprocessing makes copy of the file and expects you to work on the copy available on %f.
# This way, you can e.g. write a program which appends a different number-related comment 
# to every MP3 file so you don't get lost if you copy audiobook.
#
# Postprocessing allows to run own command on destination file or run own routine every file.
#
# Clearing does not remove subdirectories and this is intentional.
#
# In multiuser systems please zero the SYNC_HARD variable - it forces an entire filesystem to be 
# synced between files.
#
# Configuration file is in ~/.config/copyinorderrc.
#
# Warning: This has a bit aggressive syncing policy, so keep this in mind. It has been done intentionally
# as lots of these players need files just in a sequence, but you can zero the SYNC_HARD variable to
# avoid a system-wide syncing every file, and the SYNC_HARDER variable to avoid syncing every 1M-buffer.
# This should then sync every file. These variables are below CONFIGURABLES comment.
#
# KNOWN BUGS:
# - It does not support well UTF-8 in unusual places, in file names too.

#
# Headers
#
use strict;
use warnings;

use utf8;
use Encode::Locale;
use Encode; #For UTF-8 in unusual places.
use File::Basename;
use File::Find;
use File::Copy;
use IO::File;
use IO::Handle;

use Tk 804;
use Tk::ProgressBar;
#use Tk::DropSite;  
#No, DropSite won't work under X11 if not under KDE 2 and ONLY KDE 2. It's 2020 and I use KDE 3 of course <facepalm>.

#
# Global variables
#
my (
     # MainWindow
     $MW,

     # Hash of all widgets
     %ZWIDGETS,
    );

#CONFIGURABLES
my $SYNC_HARD=1;  #Change to zero if you don't want to sync everything as sync-every-file routine.
my $SYNC_HARDER=1; #change to zero if you don't want to sync every 1M-buffer copied
my $BUFFERS=2;  #buffer multiplier. Copy buffer size = 512kB*this variable.
my $CONF_FILE=$ENV{"HOME"}."/.config/copyinorderrc"; #config file 

#USER INTERFACE VARIABLES AND THEIR DEFAULTS
my $destDir = "/tmp/";
my $preString="";
my $postString="";
my $prefixString="";

my $eraseBefore = 0;
my $syncAtEnd = 1;
my $syncBetween = 1;
my $skipExisting = 0;
my $numbering=1;

my $statusBar="Ready";

my $fileProgress=100;
my $allProgress=0;

my @items;
######################
#
# Create the MainWindow
#
######################

$MW = MainWindow->new;
$MW ->resizable(0,0);
$MW ->title("CopyInOrder v. 0.003 MCbx 2020");

######################
#
# Load any images and fonts
#
######################
ZloadImages();
ZloadFonts ();

# GUI definition starts. Scroll down to "Subroutines" to get to its code.

# Widget Button1 isa Button
$ZWIDGETS{'Button1'} = $MW->Button(
   -command => 'main::AddItem',
   -text    => '+',
  )->grid(
   -row    => 0,
   -column => 0,
   -sticky => 'n',
  );

# Widget Listbox1 isa Listbox
#$ZWIDGETS{'Listbox1'} = $MW->Listbox(
$ZWIDGETS{'Listbox1'} = $MW->Scrolled(
	"Listbox",
	-scrollbars => 'oe',
	-selectmode => 'single',
   -exportselection => 1,
   -height          => 20,
   -setgrid         => 0,
   -width           => 80,
   -listvariable => \@items,
  )->grid(
   -row        => 1,
   -column     => 0,
   -columnspan => 13,
   -sticky     => 'nsew',
  );



# Widget Label1 isa Label
$ZWIDGETS{'Label1'} = $MW->Label(
   -takefocus => 0,
   -text      => 'Destination:',
  )->grid(
   -row        => 2,
   -column     => 0,
   -columnspan => 2,
   -sticky     => 'w',
  );

# Widget Label5 isa Label
$ZWIDGETS{'Label5'} = $MW->Label(
   -takefocus => 0,
   -text      => 'Preprocess %f copy:',
  )->grid(
   -row        => 3,
   -column     => 0,
   -columnspan => 2,
   -sticky     => 'w',
  );

# Widget Label7 isa Label
$ZWIDGETS{'Label7'} = $MW->Label(
   -takefocus => 0,
   -text      => 'Postprocess %f  after:',
  )->grid(
   -row        => 4,
   -column     => 0,
   -columnspan => 2,
   -sticky     => 'w',
  );
  
# Widget Label7 isa Label
$ZWIDGETS{'Label8'} = $MW->Label(
   -takefocus => 0,
   -text      => 'Add filename prefix:',
  )->grid(
   -row        => 5,
   -column     => 0,
   -columnspan => 2,
   -sticky     => 'w',
  );

# Widget Checkbutton1 isa Checkbutton
$ZWIDGETS{'Checkbutton1'} = $MW->Checkbutton(
   -indicatoron => 1,
   -justify     => 'left',
   -padx        => 2,
   -text        => 'Clear files before copying',
   -variable    => \$eraseBefore,
  )->grid(
   -row        => 6,
   -column     => 0,
   -columnspan => 4,
   -sticky     => 'sw',
  );

# Widget Checkbutton2 isa Checkbutton
$ZWIDGETS{'Checkbutton2'} = $MW->Checkbutton(
   -anchor      => 'center',
   -indicatoron => 1,
   -justify     => 'left',
   -text        => 'Sync between each file',
   -variable    => \$syncBetween,
  )->grid(
   -row        => 7,
   -column     => 0,
   -columnspan => 4,
   -sticky     => 'sw',
  );

# Widget Checkbutton3 isa Checkbutton
$ZWIDGETS{'Checkbutton3'} = $MW->Checkbutton(
   -text     => 'Sync everything at the end.',
   -variable => \$syncAtEnd,
  )->grid(
   -row        => 8,
   -column     => 0,
   -columnspan => 4,
   -sticky     => 'sw',
  );
  
  # Widget Checkbutton1 isa Checkbutton
$ZWIDGETS{'Checkbutton4'} = $MW->Checkbutton(
   -indicatoron => 1,
   -justify     => 'left',
   -padx        => 2,
   -text        => 'Skip existing files instead of renaming',
   -variable    => \$skipExisting,
  )->grid(
   -row        => 6,
   -column     => 4,
   -columnspan => 8,
   -sticky     => 'sw',
  );
  
    
  # Widget Checkbutton1 isa Checkbutton
$ZWIDGETS{'Checkbutton5'} = $MW->Checkbutton(
   -indicatoron => 1,
   -justify     => 'left',
   -padx        => 2,
   -text        => 'Number 0000.ext instead of name',
   -variable    => \$numbering,
  )->grid(
   -row        => 7,
   -column     => 4,
   -columnspan => 8,
   -sticky     => 'sw',
  );

# Widget Entry3 isa Label
$ZWIDGETS{'StatusBar'} = $MW->Label(
   -background      => '#999999999999',
   -foreground => '#000000000000',
   -justify => 'center',
   -textvariable => \$statusBar,
   -relief => 'groove',
#   -exportselection => 1,
 #  -state           => 'disabled',
   -text => 'ready',
  )->grid(
   -row        => 9,
   -column     => 0,
   -columnspan => 13,
   -sticky     => 'sew',
  );

# Widget ProgressBar1 isa ProgressBar
$ZWIDGETS{'ProgressBar1'} = $MW->ProgressBar(-variable=>\$fileProgress, -from=>0, -to=>100,)->grid(
   -row        => 10,
   -column     => 0,
   -columnspan => 13,
   -sticky     => 'ew',
  );

# Widget ProgressBar2 isa ProgressBar
$ZWIDGETS{'ProgressBar2'} = $MW->ProgressBar(-variable=>\$allProgress, -from=>0, -to=>100,)->grid(
   -row        => 11,
   -column     => 0,
   -columnspan => 13,
   -sticky     => 'sew',
  );

# Widget Button4 isa Button
$ZWIDGETS{'Button4'} = $MW->Button(
   -command => 'main::RemoveItem',
   -text    => '-',
  )->grid(
   -row    => 0,
   -column => 1,
   -sticky => 'nw',
  );

# Widget Label3 isa Label
$ZWIDGETS{'Label3'} = $MW->Label(
   -takefocus => 0,
   -text      => '      ',
  )->grid(
   -row    => 0,
   -column => 2,
   -sticky => 'nsew',
  );

# Widget Entry1 isa Entry
$ZWIDGETS{'Entry1'} = $MW->Entry(
   -textvariable => \$destDir,
   -width        => 20,
  )->grid(
   -row        => 2,
   -column     => 2,
   -columnspan => 10,
   -sticky     => 'ew',
  );

# Widget Entry4 isa Entry
$ZWIDGETS{'Entry4'} = $MW->Entry(
   -textvariable => \$preString,
  )->grid(
   -row        => 3,
   -column     => 2,
   -columnspan => 11,
   -sticky     => 'ew',
  );

# Widget Entry5 isa Entry
$ZWIDGETS{'Entry5'} = $MW->Entry(
   -textvariable => \$postString,
)->grid(
   -row        => 4,
   -column     => 2,
   -columnspan => 11,
   -sticky     => 'ew',
  );

# Widget Entry5 isa Entry
$ZWIDGETS{'Entry6a'} = $MW->Entry(
   -textvariable => \$prefixString,
)->grid(
   -row        => 5,
   -column     => 2,
   -columnspan => 11,
   -sticky     => 'ew',
  );

# Widget Button5 isa Button
$ZWIDGETS{'Button5'} = $MW->Button(
   -command => 'main::MoveUp',
   -text    => '/\\',
  )->grid(
   -row    => 0,
   -column => 3,
   -sticky => 'n'
  );

# Widget Button6 isa Button
$ZWIDGETS{'Button6'} = $MW->Button(
   -command => 'main::MoveDown',
   -text    => '\\/',
  )->grid(
   -row    => 0,
   -column => 4,
   -sticky => 'n',
  );

# Widget Button7 isa Button
$ZWIDGETS{'Button7'} = $MW->Button(
   -command => 'main::MoveTop',
   -text    => '-/\\-',
  )->grid(
   -row    => 0,
   -column => 5,
   -sticky => 'n',
  );

# Widget Button8 isa Button
$ZWIDGETS{'Button8'} = $MW->Button(
   -command => 'main::MoveBottom',
   -text    => '_\\/_',
  )->grid(
   -row    => 0,
   -column => 6,
   -sticky => 'n',
  );

# Widget Label4 isa Label
$ZWIDGETS{'Label4'} = $MW->Label(
   -anchor    => 'e',
   -justify   => 'right',
   -takefocus => 0,
   -text      => 'Sort file name only:',
   -width     => 30,
  )->grid(
   -row    => 0,
   -column => 7,
   -sticky => 'nse',
  );

# Widget Button9 isa Button
$ZWIDGETS{'Button9'} = $MW->Button(
   -command   => 'main::SortFN_AZ',
   -takefocus => 0,
   -text      => '.../A..Z',
  )->grid(
   -row    => 0,
   -column => 8,
   -sticky => 'n',
  );

# Widget Button10 isa Button
$ZWIDGETS{'Button10'} = $MW->Button(
   -command => 'main::SortFN_ZA',
   -text    => '.../Z..A',
  )->grid(
   -row    => 0,
   -column => 9,
  );

# Widget Label6 isa Label
$ZWIDGETS{'Label6'} = $MW->Label(
   -anchor    => 'e',
   -takefocus => 0,
   -text      => '  Sort w/Path:',
  )->grid(
   -row    => 0,
   -column => 10,
  );

# Widget Button3 isa Button
$ZWIDGETS{'Button3'} = $MW->Button(
   -command => 'main::StartProcedure',
   -text    => 'Start Copying',
  )->grid(
   -row        => 6,
   -column     => 10,
   -rowspan    => 2,
   -columnspan => 3,
   -sticky     => 'se',
  );

# Widget Button11 isa Button
$ZWIDGETS{'Button11'} = $MW->Button(
   -command => 'main::Sort_AZ',
   -text    => 'A..Z',
  )->grid(
   -row    => 0,
   -column => 11,
  );

# Widget Button12 isa Button
$ZWIDGETS{'Button12'} = $MW->Button(
   -command => 'main::Sort_ZA',
   -text    => 'Z..A',
  )->grid(
   -row    => 0,
   -column => 12,
  );

# Widget Button2 isa Button
$ZWIDGETS{'Button2'} = $MW->Button(
   -command => 'main::SelectDestDir',
   -text    => '...',
  )->grid(
   -row    => 2,
   -column => 12,
  );
#Populate menu!
	$ZWIDGETS{'Menu'} = $MW->Menu();
	$ZWIDGETS{'Menu'}->add('command', -label => 'Files', -command => 'main::AddFile');
	$ZWIDGETS{'Menu'}->add('command', -label => 'Directory', -command => 'main::AddDir');
	$ZWIDGETS{'Menu'}->add('command', -label => 'Directory + subdirs', -command => 'main::AddSubdirs');
	$ZWIDGETS{'Menu'}->add('command', -label => 'Reset pre/post counter', -command => 'main::ResetPrePost');	
	$ZWIDGETS{'Menu'}->add('separator');
	$ZWIDGETS{'Menu'}->add('command', -label => 'Clear list', -command => 'main::ClearList');	
	$ZWIDGETS{'Menu'}->add('command', -label => 'Save settings', -command => 'main::SaveSettings');
	$ZWIDGETS{'Menu'}->add('separator');
	$ZWIDGETS{'Menu'}->add('command', -label => 'Cancel', -command => 'main::CloseMenu');

###############
#
# MainLoop
#
###############

MainLoop;

#######################
#
# Subroutines
#
#######################


####################
# BOOT UP ROUTINES #
####################

sub ZloadImages {
	
	#LOAD SETTINGS FROM FILE
	
	if ( -e $CONF_FILE )
	{
		open (my $FH,'<',$CONF_FILE);
		my @configu=();
		while (<$FH>)
		{
			$_=~s/\n//g;
			push (@configu,$_);
		}
		close $FH;
		
		if ($#configu>7)
		{
			$destDir = $configu[0];
			$preString = $configu[1];
			$postString = $configu[2];

			$eraseBefore = $configu[3];
			$syncAtEnd = $configu[4];
			$syncBetween = $configu[5];
			$skipExisting = $configu[6];
			$numbering = $configu[7];
			$prefixString= $configu[8];
		}
	}
}

sub ZloadFonts {
}


######################
# INTERFACE ROUTINES #
######################

#Helper routine
sub SaveSettings {
		my $qq=open (my $fh,'>',$CONF_FILE);
		if (!defined $qq)
		{
			$statusBar="ERROR Writing config file: $CONF_FILE";
			return;
		}
		print $fh $destDir."\n";
		print $fh $preString."\n";
		print $fh $postString."\n";
		print $fh $eraseBefore."\n";
		print $fh $syncAtEnd."\n";
		print $fh $syncBetween."\n";
		print $fh $skipExisting."\n";
		print $fh $numbering."\n";	
		print $fh $prefixString."\n";	
		close $fh;
		$statusBar="Settings have been saved to configuration file.";

}

sub ClearList {
	#do not use @items=();! There is a problem with it.
	$ZWIDGETS{"Listbox1"}->selectionClear(0,'end');
	while ($#items>-1)
	{
		splice(@items,0,1);
	} 
	$MW->update; 
}

sub MoveDown {
 my ($lb) = $ZWIDGETS{"Listbox1"};
 my @selection_index = $lb->curselection();
 if( $#selection_index >-1 ) 
 {
	 if ($selection_index[0]==$#items)
	 {
		 return;
	 }
	 
	 my $q=$items[$selection_index[0]+1];
	 $items[$selection_index[0]+1]=$items[$selection_index[0]];
	 $items[$selection_index[0]]=$q;
	 $lb->selectionClear($selection_index[0]);
	 $lb->selectionSet($selection_index[0]+1);
	 $lb->see($selection_index[0]+1);
  };
}

sub RemoveItem {
 my ($lb) = $ZWIDGETS{"Listbox1"};
 my @selection_index = $lb->curselection();
 if( $#selection_index >-1 ) {
		splice(@items,$selection_index[0],1);
	};
}

sub MoveBottom {
 my ($lb) = $ZWIDGETS{"Listbox1"};
 my @selection_index = $lb->curselection();
 if( $#selection_index >-1 ) 
 {
	 if ($selection_index[0]==$#items)
	 {
		 return;
	 }
	 
	 my $q=$items[$selection_index[0]];
	 splice(@items,$selection_index[0],1);
	 push(@items,$q);
	 $lb->selectionClear($selection_index[0]);
	 $lb->selectionSet($#items);
	 $lb->see($#items);
  };
}

sub MoveTop {
 my ($lb) = $ZWIDGETS{"Listbox1"};
 my @selection_index = $lb->curselection();
 if( $#selection_index >-1 ) 
 {
	 if ($selection_index[0]==0)
	 {
		 return;
	 }
	 
	 my $q=$items[$selection_index[0]];
	 splice(@items,$selection_index[0],1);
	 unshift(@items,$q);
	 $lb->selectionClear($selection_index[0]);
	 $lb->selectionSet(0);
	 $lb->see(0);
  };
}

sub MoveUp {
 my ($lb) = $ZWIDGETS{"Listbox1"};
 my @selection_index = $lb->curselection();
 if( $#selection_index >-1 ) 
 {
	 if ($selection_index[0]==0)
	 {
		 return;
	 }
	 
	 my $q=$items[$selection_index[0]-1];
	 $items[$selection_index[0]-1]=$items[$selection_index[0]];
	 $items[$selection_index[0]]=$q;
	 $lb->selectionClear($selection_index[0]);
	 $lb->selectionSet($selection_index[0]-1);
	 $lb->see($selection_index[0]-1);
  };
}

#THIS IS A MENU COMMAND
sub AddItem {
	#open dropdown menu
	$ZWIDGETS{'Menu'}->post($ZWIDGETS{'Button1'}->rootx, $ZWIDGETS{'Button1'}->rooty);
}

#Insert the "Reset pre/post processing counter" command to list.
sub ResetPrePost {
    my @selection_index = $ZWIDGETS{"Listbox1"}->curselection();
    $ZWIDGETS{"Listbox1"}->selectionClear(0,'end');
    if( $#selection_index >-1 ) 
    {
		splice(@items,$selection_index[0]+1,0,"%i=0 #Reset pre/porst processing counter");
		$ZWIDGETS{"Listbox1"}->selectionSet($selection_index[0]+1);
		$ZWIDGETS{"Listbox1"}->see($selection_index[0]+1);
    }
	else
	{
		push (@items,"%i=0 #Reset pre/porst processing counter");
		$ZWIDGETS{"Listbox1"}->selectionSet($#items);
		$ZWIDGETS{"Listbox1"}->see($#items);
	}
}

sub AddFile {
	my $filename="";
	$filename = $MW->getOpenFile(-multiple=>1,);
	
	if ( !defined $filename)
	{
		return;
	}
	
	foreach my $fn (@{$filename})
	{
		my @selection_index = $ZWIDGETS{"Listbox1"}->curselection();
		$ZWIDGETS{"Listbox1"}->selectionClear(0,'end');
		if( $#selection_index >-1 ) 
		{
			splice(@items,$selection_index[0]+1,0,$fn);
			$ZWIDGETS{"Listbox1"}->selectionSet($selection_index[0]+1);
			$ZWIDGETS{"Listbox1"}->see($selection_index[0]+1);
		}
		else
		{
			push (@items,$fn);
			$ZWIDGETS{"Listbox1"}->selectionSet($#items);
			$ZWIDGETS{"Listbox1"}->see($#items);
		}	
	} 	
}

sub AddDir {
	
	my $dir = $MW->chooseDirectory;
	
	if (!defined $dir)
	{
		return;
	}
	
	$statusBar="Adding directory...";

	my $qq=opendir DIR, $dir;
	if (!$qq)
	{
		$statusBar="ERROR opening directory!";
		return;
	}
	
	my @files = grep { !/^\./ && -f "$dir/$_" } readdir(DIR);
	closedir DIR;
    @files=sort(@files);
     
	foreach my $fn (@files)
	{
     #   print "$fn\n"; #HERE UTF8 GREAT.
		my @selection_index = $ZWIDGETS{"Listbox1"}->curselection();
		$ZWIDGETS{"Listbox1"}->selectionClear(0,'end');
		if( $#selection_index >-1 ) 
		{
			splice(@items,$selection_index[0]+1,0,$dir."/".$fn);
			$ZWIDGETS{"Listbox1"}->selectionSet($selection_index[0]+1);
			$ZWIDGETS{"Listbox1"}->see($selection_index[0]+1);
		}
		else
		{
			push (@items,$dir."/".$fn);
			$ZWIDGETS{"Listbox1"}->selectionSet($#items);
			$ZWIDGETS{"Listbox1"}->see($#items);
		}	
	} 
	
	$statusBar="Ready";
}

#Like AddDir but dives recursively
sub AddSubdirs {
	
	my $dir = $MW->chooseDirectory;

	if ( !defined $dir)
	{
		return;
	}

	$statusBar="Adding directory...";
	my @files;
    find(sub { push @files, $File::Find::name }, $dir);
	@files=sort(@files);
	foreach my $fn (@files)
	{
        if (-d $fn)
        {
            next;
        }
        
		my @selection_index = $ZWIDGETS{"Listbox1"}->curselection();
		$ZWIDGETS{"Listbox1"}->selectionClear(0,'end');
		if( $#selection_index >-1 ) 
		{
			splice(@items,$selection_index[0]+1,0,$fn);
			$ZWIDGETS{"Listbox1"}->selectionSet($selection_index[0]+1);
			$ZWIDGETS{"Listbox1"}->see($selection_index[0]+1);
		}
		else
		{
			push (@items,$fn);
			$ZWIDGETS{"Listbox1"}->selectionSet($#items);
			$ZWIDGETS{"Listbox1"}->see($#items);
		}	
	} 
	
	$statusBar="Ready";
}

#Close the menu
sub CloseMenu {
	$ZWIDGETS{'Menu'}->unpost;
}

#Helper routine: Compare the paths by only using their basenames
sub fcmp {
  my $res = basename(lc($a)) cmp basename(lc($b));
    return $res;
}

#Sorting buttons
sub SortFN_AZ {
	@items=sort { fcmp } (@items);
}

sub Sort_AZ {
	@items=sort(@items);
}

sub SortFN_ZA {
		@items=sort { fcmp } (@items);
		@items=reverse(@items);
}

sub Sort_ZA {
	@items=sort(@items);
	@items=reverse(@items);
}

#Select destination directory
sub SelectDestDir {
	my $dir = $MW->chooseDirectory;
	
	if (!defined $dir)
	{
		return;
	}
	
	$destDir = $dir;
}


#The main routine
sub StartProcedure {	
	
	############
	## ACTION ##
	############
	
	##### SANITY CHECKS #####
	
	$destDir =~ s/(?<!\/)$/\//; #append / to directory if needed
	$fileProgress=100;
	
	# 0. Check do we have anything to work with
	if ($#items==-1)
	{
		$statusBar="END: Nothing to process.";
		return;
	}
	
	# 1. Check do we have write permissions in destination directory
	if (! -w $destDir )
    {
		$statusBar="ERROR: No write permissions or bad destination directory!";
		return;
    }
	
	##### CLEAR DIRECTORY #####
	if ($eraseBefore==1)
	{
		$statusBar="Clearing directory";
		$MW->update; 
		unlink glob "'$destDir*.*'";
		#print "'$destDir*.*'";
		
		if (glob "'$destDir*.*'")
		{
			$statusBar="ERROR: Clearing directory left some files.";
			return;
		}
	}

	##### COPYING #####
	
	my $number=0; #current file number
	my $pcounter=0; #current pre-processing counter
	my $fCount=$#items+1;
	my $tempDir="";
	
	
	foreach my $item (@items)
	{
        
        #print "$item\n";
		$number++;
		$pcounter++;
		$allProgress=($number / $fCount )*100;
		$MW->update; 
		
		if (rindex($item,"%i=0",0)==0) #counter reset
		{
			$pcounter=0;
			next;
		}
		
		my $source = $item;
		
        #Filename encoding magic. No idea how it works!
        $source=decode(locale_fs => $source);
        #Theoretically UTF8 shall be UTF8. It is not. So we decide it to ANSI which looks like poo.
        #Now the ANSI looks bad, but can be processed in system.        
        
        my $filename= basename($item);
		
		#Prepare destination name:
		my $destination=$destDir.$filename;
		
		#prepare filename prefix
		if ($prefixString ne "")
		{
				$destination=$destDir.$prefixString.$filename;
		}
		
		#insert filename numbering
        if ($numbering == 1)
		{
			my ($ext) = $filename =~ /(\.[^.]+)$/; #get extension
			$destination = $destDir.sprintf("%04d", $number).$ext;
			if ($prefixString ne "")
			{
				$destination = $destDir.$prefixString.sprintf("%04d", $number).$ext;
			}
		}
        
        #Check does file exists
        if ( ! -e $source)
        {
            $statusBar="ERROR: File does not exist! $source";
            return;
        }
		
		#Preprocessing
		if ($preString ne "")
		{
				$statusBar="Copy for pre-processing";
				$MW->update; 
				
				if ($tempDir eq "" )
				{
					for (0..7) { $tempDir .= chr( int(rand(25) + 65) ); }
					$tempDir="/tmp/seqcopy".$tempDir."/";
					my $qq = mkdir ($tempDir);
					if ($qq==0)
					{
						$statusBar="ERROR: Cannot create temporary folder for pre-processing!";
						return;
					}
				}
				my $qq=copy($source, $tempDir.$filename);
				if ($qq==0)
				{
					$statusBar="ERROR: Cannot copy $filename to temporary directory for preprocessing.";
					return;
				}
				$source=$tempDir.$filename;
				my $string=$preString;
				$string =~ s/\%f/$source/g;
				$string =~ s/\%n/$number/g;
				$string =~ s/\%i/$pcounter/g;
				$statusBar="$number/$fCount ($pcounter): Waiting for preprocessor of $filename";
				$MW->update; 
				$qq = system $string;
				if ($qq != 0)
				{
					$statusBar = "ERROR: Preprocessing $filename gave code $?.";
					return;
				}
#				if ($! != 0)
#				{
#					$statusBar = "ERROR: Preprocessing launch $filename gave code $!.";
#					return;
#				}
				sleep(1);
		}
		
		#check if file exist, if yes, perform proper operations
		if ($skipExisting==0)
		{
			my $n=0;
			my $destination2="";
			if ( -f $destination )
			{
				$n++;
				my ($ext) = $filename =~ /(\.[^.]+)$/; #get extension
			    my($filename, $dirs, $suffix) = fileparse($destination);
				$filename=substr($filename,0,-1*(length($ext)));
				$destination2=$dirs.$filename."_".$n.$ext;
				
				while (-f $destination2)
				{
					$n++;
					my ($ext) = $filename =~ /(\.[^.]+)$/; #get extension
					my($filename, $dirs, $suffix) = fileparse($destination); #suffix doesnt work there is a bug in the system
					$filename=substr($filename,0,-1*(length($ext)));
					$destination2=$dirs.$filename."_".$n.$ext;
					print "EXT: $ext\n";
				}
				print "$destination has been changed to $destination2 \n";
				$destination = $destination2;
			}
			
		}
		else
		{
			print "Skipping existing file: $source \n";
			next;
		}
		
		
		#Copying
		$statusBar="$number/$fCount ($pcounter): Copying $filename...";
		$MW->update; 
		my $fileSize= -s $source;
		$fileProgress=0;
		my $copiedBytes=0;
		my $bufProgress=0;
		
		my $BUFSIZE=524288*$BUFFERS; #buffer size
		
		my $qq=open (my $fhin, '<', $source);
		binmode $fhin;
		if (!defined $qq)
		{
			print $source;
			$statusBar="$number/$fCount: ERROR opening for reading: $filename code $qq.";
			return;
		}
		
		$qq=open (my $fhout, '>', $destination);
		binmode $fhout;
		if (!defined $qq)
		{
			$statusBar="$number/$fCount: ERROR opening for writing: $filename...";
			return;
		}
		$|=1;
		$fhout->autoflush;
		
		#print $fileSize."bytes to copy\n";
		
		my $buffer='';
		
		$bufProgress=1;
		while ($copiedBytes < $fileSize)  #THIS IS MAIN COPY LOOP.
		{
			$bufProgress = read($fhin, $buffer, $BUFSIZE); #Warning: do not use offset here. RTFM, It's not what it seems.
			print $fhout $buffer;
			if ($SYNC_HARDER==1)
			{
				$fhout->sync;
			}
			$buffer="";
			$copiedBytes+=$bufProgress;
			$fileProgress=($copiedBytes / $fileSize) *100;
			$MW->update;
#			print "$bufProgress buffer, $copiedBytes copied of $fileSize, progress: $fileProgress.\n";
		}
		
		$statusBar="$number/$fCount: Finalizing $filename...";
		$MW->update;
		
		close $fhin;
		close $fhout;
		$copiedBytes=0;
		
		#postprocessing. The file sits safely in "$destination" now
		if ($postString ne "")
		{
				my $string=$postString;
				$string =~ s/\%f/$destination/g;
				$string =~ s/\%n/$number/g;
				$string =~ s/\%i/$pcounter/g;
				$statusBar="$number/$fCount: Waiting for postprocessing of $filename";
				$MW->update; 
				$qq = system $string;
				if ($qq != 0)
				{
					$statusBar = "ERROR: Postprocessing $filename gave code $?.";
					return;
				}
				if ($! != 0)
				{
					$statusBar = "ERROR: Postprocessing launch $filename gave code $?.";
					return;
				}
		}
		
		
		#Intermediate syncing 
		if ($syncBetween==1)
		{
			$statusBar="$number/$fCount: Syncing the destination...";
			$MW->update;
			new IO::File($destination, "r+")->sync();
			
			if ($SYNC_HARD==1)
			{
			system("sync");  #Please comment this out on multiuser systems and normal flash drive fstab configurations.
							 #In some FAT32 drivers the sync() for file does not update table properly.
			}
							 
			sleep(1); #A very important delay for old FAT32 filesystem drivers.
		}
		
		#PREPROCESSING: temp cleaning
		if ($preString ne "")
		{
				if (index($source,"/tmp")==0)
				{
					$statusBar="$number/$fCount: Removing temporary file...";
					$MW->update;
#					print $source;
					unlink $source;
				}
		}
		
	}
	
	
	
	##### FINAL HARD SYNC ####
	if ($syncAtEnd==1)
	{
		$statusBar="$number/$fCount: Syncing a whole system...";
		$MW->update;
		
		system("sync");
					
		sleep(1); #A very important delay for old FAT32 filesystem drivers.
	}

	$statusBar="Operation completed. $number files processed.";
}

