# MENU.PL
# Menu utility.                       2019 MCbx, GPL.
# Requires Tk of course! Yes, still poor capabilities.
# LAUNCH:
#  perl menu.pl menufile.rc
# 
# Pops an user-defined menu under cursor for easy launching of your programs. 
#
# Warning for Wayland users: Perl/Tk requires XWayland as Tk is too lightweight for Wayland.
#                            It requires X11 API of course.
#Menufile structure (these records repeat):
#
#[Item's label]
#command
#icon path
#
# or
#
#[SEPARATOR]
#
#Both command and icon are compulsory. Use "" or any other rubbish for no icon.
#If you really want these submenus, just stack these menufiles.

use strict;
use warnings;
use Tk 804;  				   		#GUI Runtime library
use Tk::Photo;						#For adding images
use Tk::PNG;						#For adding PNGs as images
use Tk::Compound;					#For grouping objects to objects (icon+text label) 
use X11::GUITest qw/GetMousePos/; 	#Requires Debian's libx11-guitest-perl for getting X cursor position

my $MW = MainWindow->new(-height=>1,-width=>1,-title=>"Menu"); #This main window is not visible
my $MENU = $MW->Menu(-type=>'normal',-tearoffcommand=>sub{exit;}); #Main menu

if ($#ARGV > -1 ) #Something specified...
{
	if ( $ARGV[0] ne "" )
	{
		my $file = $ARGV[0];
		if ( ! -e $file )     #...but not a valid file. This hack uses menu itself to show error message.
		{
			print "File $file not exists!\n";
			$MENU->add('command', -label => "Error!", -command => sub{ exit; });
			$MENU->add('command', -label => "File $ARGV[0] does not exist!", -command => sub{ exit; });
			$MENU->add('command', -label => "---> Exit <---", -command => sub{ exit; });
			$ARGV[0]="";
		}
		print "Will be read from $ARGV[0]\n";	
	}
} 
else #No file specified at all
{
	print "ERROR: No menufile specified at all...\n";
	$MENU->add('command', -label => "Error!", -command => sub{ exit; });
	$MENU->add('command', -label => "No menu-file specified in argument!", -command => sub{ exit; });
	$MENU->add('command', -label => "---> Exit <---", -command => sub{ exit; });
}
	#read menufile. We can safely pass through empty path.
	open (my $FH,'<',$ARGV[0]);
	my @menufile=();
	while (<$FH>)
	{
		$_=~s/\n//g;
		push (@menufile,$_);
	}
	close $FH;
	
	my $i=0;
	#parse menufile
	while ($i < $#menufile)
	{			
		#separator
		if (uc($menufile[$i]) eq "[SEPARATOR]")
		{
			$MENU->add('separator');
			$i++;
			next;
		}
		
		#item
		if (index($menufile[$i],"[")==0)
		{
			my $label=substr($menufile[$i],1,-1);
			my $command=$menufile[$i+1];
			my $icon=$menufile[$i+2];
			if (index($icon,"\"")==0) #icon is "-surrounded
			{
				$icon=substr($icon,1,-1);
			}
			if (-e $icon) #Now if icon exists, insert it. NO SCALING HERE! Prefer 16x16 by default.
			{
				my $image = $MW->Photo(-file => $icon);
				my $compose=$MW->Compound;
				$compose->Image( -image => $image, -anchor => 'w' );
				$compose->Space( -width => 8 );
				$compose->Text( -text => $label, -underline => 0 );			
				$MENU->add('command', -label => $label, -image=>$compose, -command => sub{ &lance($command); });
			}
			else #No icon needed - just add text
			{
				$MENU->add('command', -label => $label, -command => sub{ &lance($command); });				
			}
			$i++;
			next;
		}
		$i++; #for not hanging if file malformed
	}

$MW->bind('<FocusOut>' => sub{exit;});  #Exit the program when it's not used and menu disappeared

my ($x, $y) = GetMousePos();  #Get cursor position, this is x11 specific

$MENU->post($x,$y); #Menu pop
MainLoop; 			#GUI start
exit;				#Program end

# launcher, one parameter is command.
sub lance
{
	print "launch: $_[0]\n";

	my $child_pid = fork();		  #FORK
	if ( ! defined( $child_pid )) #Does the fork succeeded?
	{
		print "fork failed\n";
	}
	elsif ( $child_pid == 0 ) #We are in child process...
	{ 
		exec( $_[0] );	#We have the same internals so we can use variables.
	}
	
	exit; #Menu's process, parent one, leaves.
}
