#include <iostream>
#include <cstdio>
#include <cstdlib>
#include "romio.h"

using namespace std;

int loadRom(char* filename, char *&buffer, bool visualize)
{
    FILE* fp;
    long lSize;
    fp=fopen(filename,"rb");
    if (!fp)
    {
        if (visualize) cout<<"ERROR: Can't open file!";
        return -63;
    }
    fseek( fp , 0L , SEEK_END);
    lSize = ftell( fp );
    rewind( fp );
    buffer = (char*)calloc( 1, lSize+1 );
    if( !buffer )
    {
        fclose(fp);
        if (visualize) cout<<"ERROR: Error allocating memory for data";
        return -62;
    }
    if( 1!=fread( buffer , lSize, 1 , fp) )
    {
        fclose(fp);
        if (visualize) cout<<"ERROR: Read error!";
        return -61;
    }
    fclose(fp);
    return lSize;
}
