#include <iostream>
#include <iomanip>
#include <string>
#include <cstdlib>
#include <unistd.h>
#include <fstream>
#include <sstream>
#include "../Romcheck/romio.h"
using namespace std;

void printUsage()
{
 cout<<" ________ "<<endl;
 cout<<" |_      \\     ROM deinterlacing (merging) tool "<<endl;
 cout<<" _/  /\\   \\   2013 MCbx                  v. 0.02"<<endl;
 cout<<" ___/__\\___\\  "<<endl;
 cout<<"   /    \\      Usage :"<<endl;
 cout<<"        deinterlace odd.bin even.bin third.bin ... -o out.bin\n";
 cout<<"At least two filenames are needed (input and output).\n";
 return;
}


int main(int argc, char* argv[])
{
    char** buffer;
    long * lSizes;

    if (argc<3)
    {
        printUsage();
        return 0;
    }
    if (argv[argc-2][1]!='o'||argv[argc-2][0]!='-')
    {
        printUsage();
        return 0;
    }

    lSizes = new long[argc-2];
    buffer = new char*[argc-2];

    for (int i=0;i<argc-3;i++)
    {
        //load files into memory
        lSizes[i]=loadRom(argv[i+1],buffer[i],1);
        if (lSizes[i]<=0)
        {
            cout<<"Error loading file: "<<argv[i+1]<<"\n";
            return 64;
        }
        if (i>0 && lSizes[i]!=lSizes[i-1])
        {
          cout<<"Error during loading "<<argv[i+1]<<": File sizes not equal!\n";
          return 63;
        }
    }

    ofstream resultFile;
    resultFile.open(argv[argc-1], ios::out|ios::binary);
    if (!resultFile.is_open())
    {
        cout<<"Error opening file for writing: "<<argv[argc-1]<<" /n";
        return 0;
    }
    for (int j=0;j<lSizes[0];j++)
    {

        for (int i=0;i<argc-3;i++)
        {
            resultFile<<buffer[i][j];
        }
    }

    resultFile.close();
    cout<<"Finished condensing "<<argc-3<<" files!\n";
    return 0;
}
