#include <iostream>
#include <string>
#include <cstdlib>
#include <unistd.h>
#include "../Romcheck/romio.h"
#include "../Romcheck/visualize.h"
using namespace std;

void printUsage()
{
 cout<<" ________ "<<endl;
 cout<<" |_      \\     ROM hex displaying tool "<<endl;
 cout<<" _/  /\\   \\   2013 MCbx                  v. 0.02"<<endl;
 cout<<" ___/__\\___\\  "<<endl;
 cout<<"   /    \\      Usage :"<<endl;
 cout<<"           hexcat -f 0 -t 0 -l file.bin\n";
 cout<<"All parameters except file name are optional\n";
 cout<<"Parameters: \n";
 cout<<" -f X - offset of display start, default 0 (starto f file) \n";
 cout<<" -t X - offset of display end, default 0 (to the end of file) \n";
 cout<<" -l   - do not display as full 16-byte lines, but use -f X as start \n";
 cout<<" -h or -? - this help\n";
 return;
}


int main(int argc, char* argv[])
{

    int from=0;
    int to=0;
    bool partComplete=true;

    if (argc==1)
    {
        printUsage();
        return 0;
    }

    int opt=0;
    static const char *optString = "f:t:lh?";
    opt = getopt( argc, argv, optString );
     while( opt != -1 )
        {
        switch( opt )
        {
        case 'f':
            from=atoi(optarg);
            if (from<0)
            {
                printUsage();
                return 0;
            }
            break;
        case 't':
            to=atoi(optarg);
            if (to<0)
            {
                printUsage();
                return 0;
            }
            break;
        case 'l':
            partComplete=0;
            break;
        case 'h':
        case '?':
            printUsage();
            return 0;
            break;
        }
        opt = getopt( argc, argv, optString );
     }

    char* buffer;
    long lSize=0;
    lSize=loadRom(argv[optind],buffer,false);
    if (lSize<=0)
    {
        cout<<"Error when loading file!\n";
        return -65;
    }

    if (from>lSize)
    {
    cout<<"ERROR: File size: "<<lSize<<" Start offset: "<<from<<" is larger.\n";
    return 0;
    }
    if (to>lSize)
    {
    cout<<"ERROR: File size: "<<lSize<<" To offset: "<<to<<" is larger.\n";
    return 0;
    }
    if (to<from && to>0)
    {
        cout<<"ERROR: End is smaller than start offset.\n";
        return 0;
    }

    to=to-from;
    if (to<=0||to>lSize)
    {
        to=lSize;
    }

    cout<<printHex(buffer,from,to,lSize,partComplete)<<"\n";
    return 0;
}
