#include <iostream>
#include <string>
#include <cstdlib>
#include <unistd.h>
#include <fstream>
#include "../Romcheck/romio.h"
using namespace std;

void printUsage()
{
 cout<<" ________ "<<endl;
 cout<<" |_      \\     ROM rounding-up tool "<<endl;
 cout<<" _/  /\\   \\   2013 MCbx                  v. 0.02"<<endl;
 cout<<" ___/__\\___\\  "<<endl;
 cout<<"   /    \\      Usage :"<<endl;
 cout<<"        roundto -s X -p Y -m Z -c 255 -f aa.bin input.bin output.bin\n";
 cout<<"Filenames and one s/p/m parameter must be specified.\n";
 cout<<"Parameters: \n";
 cout<<" -s X - Round to specific length X\n";
 cout<<" -p Y - Round to the nearest power of Y \n";
 cout<<" -m Z - Round to the nearest multiple of Z \n";
 cout<<" -c K - round with character of DECIMAL code K (default 0)\n";
 cout<<" -f aa.bin - round with contents of the file aa.bin,";
 cout<<" repeating if needed\n";
 cout<<" -h or -? - this help\n";
 return;
}

int pow (int a, int b)
{
    int k=a;
    for (int i=1;i<b;i++)
        k=k*a;
    return k;
}

int main(int argc, char* argv[])
{

    char chFill = 0;
    char* filling=&chFill;
    long fillingLength = 1;
    long roundTo = 0;
    short lMode = 0;
    char* buffer;
    long lSize = 0;

    if (argc<3)
    {
        printUsage();
        return 0;
    }

    int opt=0;
    static const char *optString = "s:p:m:c:f:lh?";
    opt = getopt( argc, argv, optString );
     while( opt != -1 )
        {
        switch( opt )
        {
        case 's':
            roundTo=atoi(optarg);
            lMode=1;
            break;
        case 'p':
            roundTo=atoi(optarg);
            lMode=2;
            break;
        case 'm':
            roundTo=atoi(optarg);
            lMode=3;
            break;
        case 'c':
            chFill=atoi(optarg);
          //  filling = &chFill;
            break;
        case 'f':
            fillingLength=loadRom(optarg,filling,0);
            if (fillingLength<=0)
            {
                cout<<"Error loading filling file!\n";
                return 64;
            }
            break;
        case 'h':
        case '?':
            printUsage();
            return 0;
            break;
        }
        opt = getopt( argc, argv, optString );
     }

    lSize=loadRom(argv[optind],buffer,false);
    if (lSize<=0)
    {
        cout<<"Error when loading file!\n";
        return 65;
    }

    ofstream resultFile;


    //compute rounding to:
    if (lMode==1)
    {
        if (lSize>=roundTo)
        {
            cout<<"Size larger or equal. Copying file!\n";
            resultFile.open(argv[optind+1], ios::out|ios::binary);
            if (!resultFile.is_open())
            {
                cout<<"ERROR: Error while opening destination file for writing.\n";
                return 64;
            }
            resultFile.write(buffer,lSize);
            resultFile.close();
            return 0;
        }
    }
    if (lMode==2)
    {
        int r=0;
        do
        {
            r++;
        } while (pow(roundTo,r)<lSize);
        roundTo=pow(roundTo,r);
        if (roundTo==lSize)
        {
            cout<<"Already a power. Copying file!\n";
            resultFile.open(argv[optind+1], ios::out|ios::binary);
            if (!resultFile.is_open())
            {
                cout<<"ERROR: Error while opening destination file for writing.\n";
                return 64;
            }
            resultFile.write(buffer,lSize);
            resultFile.close();
            return 0;
        }
    }
    if (lMode==3)
    {
        int rem = lSize % roundTo;
        if (rem!=0) roundTo=lSize+roundTo-rem;
        else
        {
            cout<<"Already multiply. Copying file!\n";
            resultFile.open(argv[optind+1], ios::out|ios::binary);
            if (!resultFile.is_open())
            {
                cout<<"ERROR: Error while opening destination file for writing.\n";
                return 64;
            }
            resultFile.write(buffer,lSize);
            resultFile.close();
            return 0;
        }

    }
    cout<<"Changing size "<<lSize<<" to "<<roundTo<<" with ";
    cout<<fillingLength<<"-byte pattern\n";

    //create binary stream s and begin throwing these things to it.
    resultFile.open(argv[optind+1], ios::out|ios::binary);
    if (!resultFile.is_open())
    {
        cout<<"ERROR: Error while opening destination file for writing.\n";
        return 64;
    }

    resultFile.write(buffer,lSize);

    for (int i=0;i<roundTo-lSize;i++)
    {
       resultFile<<filling[i%fillingLength];
    }


    resultFile.close();
    cout<<"Finished.\n";
    return 0;


}
