#  Project Name
PROJECT=target_LPC1768


#  Type of CPU/MCU in target hardware
CPU = cortex-m3

# TinyBasicLike core expects the name of the target header file to be
# passed in a specific macro defined at compile time.
TARGET_MCU_HEADER_FILE = "target_LPC1768.h"


# Build-specific compiler flags
#
# Define flags that only have meaning to the project being built, as opposed to
# the above generic compiler flags.
BUILD_SPECIFIC_COMPILER_FLAGS = -D'TARGET_MCU_HEADER_FILE=$(TARGET_MCU_HEADER_FILE)'



#  Build the list of object files needed.  All object files will be built in
#  the working directory, not the source directories.
#
#  You will need as a minimum your $(PROJECT).o file and the startup_stm32f4xx.o
#  object file.  Depending on where your code sets up the MCU's clocks and
#  PLL, you may also need some kind of initialization file, typically
#  system_stm32f4xx.o.  Finally, you will need whatever STMicros' standard
#  peripherals objects you use, such as stm32f4xx_gpio.o.
OBJECTS	= $(PROJECT).o  \
		startup_LPC17xx.o  \
		TinyBasicLike.o
	      
#  Select the toolchain by providing a path to the top level
#  directory; this will be the folder that holds the
#  arm-none-eabi subfolders.
# TOOLPATH = C:/CodeSourcery/SourceryG++Lite
TOOLPATH = /usr/lib

#  Define an explicit path to the GNU tools used by make, such as gcc
#  and ld.
#
#  If you are ABSOLUTELY sure that your PATH variable is
#  set properly, you can remove the BINPATH variable.
#
BINPATH = /usr/bin
#BINPATH = /usr/lib/arm-none-eabi/bin


#
#  Select the target type.  This is typically arm-none-eabi.
#  If your toolchain supports other targets, those target
#  folders should be at the same level in the toolchain as
#  the arm-none-eabi folders.
TARGETTYPE = arm-none-eabi

#  Describe the various include and source directories needed.
#  These usually point to files from whatever distribution
#  you are using (such as STM32F4 Discovery).  This can also
#  include paths to any needed GCC includes or libraries.
GCC_INC          = $(TOOLPATH)/$(TARGETTYPE)/include




#  All possible source directories other than '.' must be defined in
#  the VPATH variable.  This lets make tell the compiler where to find
#  source files outside of the working directory.  If you need more
#  than one directory, separate them with ':'.
#VPATH = $(STM32F4_BASEPATH)/Libraries/STM32F4xx_StdPeriph_Driver/src

				
#  List of directories to be searched for include files during compilation
INCDIRS  = -I$(GCC_INC)
INCDIRS += -I.


# Name and path to the linker script
# LDSCRIPT = $(PROJECT).ld
# LDSCRIPT = stm32f4_generic.ld
LDSCRIPT = lpc17xx.ld


OPTIMIZATION = 0
DEBUG = -g

#  List the directories to be searched for libraries during linking.
#  Optionally, list archives (libxxx.a) to be included during linking. 
#LIBDIRS  = -L$(TOOLPATH)/$(TARGETTYPE)/newlib
LIBDIRS  = -L$(TOOLPATH)/$(TARGETTYPE)/lib/thumb
LIBDIRS += -L$(LOCAL_LIBRARY)

#  List the libraries to include in building.
#
#  Order is important!  List locally created libraries first, followed by
#  libraries supplied by STMicro.  If you put the STMicro libraries first, you
#  will get unresolved reference errors for any STMicro routines your local
#  libraries call.
LIBS = -lc
#LIBS += -lstm32f4xx

LIBS = -lnosys
#LIBS += -lstm32f4xx
#LIBS += -lusart
#LIBS += -lstm32f4xx


#  Compiler options
#  Note that the value HSE_VALUE is left over from early STM code.  It should
#  be set to the frequency (in Hz) of the external crystal on the target board.
#  For the STM32F4 Discovery board, this frequency is 8 MHz.
#
#  Setting the value BLINK_IN_DEFAULT_HANDLER causes the default IRQ handler to
#  blink an LED; this can help spot a wild interrupt or a mismatch in IRQ handler
#  names.  Refer to startup_stm32f4xx.c for details.
#
GCFLAGS = -Wall -fno-common -mcpu=$(CPU) -mthumb -O$(OPTIMIZATION) $(DEBUG)
GCFLAGS += $(INCDIRS)
GCFLAGS += -D__STARTUP_CLEAR_BSS
GCFLAGS += $(BUILD_SPECIFIC_COMPILER_FLAGS)
#GCFLAGS += -DSTM32F30X


#  Linker options
LDFLAGS  = -nostdlib -nostartfiles -Map=$(PROJECT).map -T$(LDSCRIPT)
LDFLAGS += --cref
LDFLAGS += $(LIBDIRS)
LDFLAGS += $(LIBS)



#  Assembler options
ASLISTING = -alhs
ASFLAGS = $(ASLISTING) -mcpu=$(CPU)

#  Archive options
ARFLAGS = -crs

#  nm options
NMFLAGS = -gnA

CC = $(BINPATH)/arm-none-eabi-gcc
AS = $(BINPATH)/arm-none-eabi-as
AR = $(BINPATH)/arm-none-eabi-ar
LD = $(BINPATH)/arm-none-eabi-ld
NM = nm
OBJCOPY = $(BINPATH)/arm-none-eabi-objcopy
SIZE = $(BINPATH)/arm-none-eabi-size
OBJDUMP = $(BINPATH)/arm-none-eabi-objdump

#  Define a command for removing folders and files during clean.  The
#  simplest such command is Linux' rm with the -f option.  You can find
#  suitable versions of rm on the web.
REMOVE = rm -f

#########################################################################

all:: $(PROJECT).hex $(PROJECT).bin stats dump

$(PROJECT).bin: $(PROJECT).elf
	$(OBJCOPY) -O binary -j .text -j .data $(PROJECT).elf $(PROJECT).bin

$(PROJECT).hex: $(PROJECT).elf
	$(OBJCOPY) -R .stack -O ihex $(PROJECT).elf $(PROJECT).hex


#  Linker invocation
#  Uncomment one of the two lines that begin $(LD).
#  If you use the longer line, any errors will be reformatted for use by the Visual Studio
#  Intellisense application, so you can double-click on the error and go directly to the source
#  line.  If you use the shorter line, you get the regular GCC error format.
$(PROJECT).elf: $(OBJECTS)
#	$(LD) $(OBJECTS) $(LDFLAGS) -o $(PROJECT).elf 2>&1 | sed -e "s/\(\w\+\):\([ 0-9]\+\):/\1(\2):/"
	$(LD) $(OBJECTS) $(LDFLAGS) -o $(PROJECT).elf

stats: $(PROJECT).elf
	$(SIZE) -Ax $(PROJECT).elf
	
dump: $(PROJECT).elf
	$(OBJDUMP) --disassemble --source -h $(PROJECT).elf	 > $(PROJECT).dmp

clean:
	$(REMOVE) *.o
	$(REMOVE) $(PROJECT).hex
	$(REMOVE) $(PROJECT).elf
	$(REMOVE) $(PROJECT).map
	$(REMOVE) $(PROJECT).bin
	$(REMOVE) *.lst
	$(REMOVE) *.dmp


#  The toolvers target provides a sanity check, so you can determine
#  exactly which version of each tool will be used when you build.
#  If you use this target, make will display the first line of each
#  tool invocation.
#  To use this feature, enter from the command-line:
#    make -f $(PROJECT).mak toolvers
toolvers:
	$(CC) --version | sed q
	$(AS) --version | sed q
	$(LD) --version | sed q
	$(AR) --version | sed q
	$(OBJCOPY) --version | sed q
	$(SIZE) --version | sed q
	$(OBJDUMP) --version | sed q
	
#########################################################################
#  Default rules to compile .c and .cpp file to .o
#  and assemble .s files to .o

#  There are two options for compiling .c files to .o; uncomment only one.
#  The shorter option is suitable for making from the command-line.
#  The option with the sed script on the end is used if you want to
#  compile from Visual Studio; the sed script reformats error messages
#  so Visual Studio's IntelliSense feature can track back to the source
#  file with the error.
.c.o :
	@echo Compiling $<, writing to $@...
#	$(CC) $(GCFLAGS) -c $< -o $@
	$(CC) $(GCFLAGS) -c $< 2>&1 | sed -e 's/\(\w\+\):\([ 0-9]\+\):/\1(\2):/'

.cpp.o :
	@echo Compiling $<, writing to $@...
	$(CC) $(GCFLAGS) -c $<

.s.o :
	@echo Assembling $<, writing to $@...
	$(AS) $(ASFLAGS) -o $@ $<  > $(basename $@).lst

#########################################################################
