
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

int convert_crlf( const char* filename );

void usage()
{
	printf( "crlf: converts CR/LF to CR\n" );
}


int main( int argc, char* argv[] )
{
	DIR*		dir;
	struct dirent *direntp;

	if( argc < 2 )
	{
		usage();
		exit(1);
	}

	if( strcmp( argv[ 1 ], "-a" ) == 0 )
	{
		printf( "converting all files...\n" );
		dir = opendir( "." );
		if( dir == NULL )
		{
			printf( "failed to open dir\n" );
			exit(1);
		}

		while( ( direntp = readdir(dir) ) != NULL ) 
		{
			/*printf( "%s\n", direntp->d_name );*/
			if( strcmp( direntp->d_name, "." ) == 0 )
			{
				continue;
			}
			else if( strcmp( direntp->d_name, ".." ) == 0 )
			{
				continue;
			}
			else
			{
				convert_crlf( direntp->d_name );
			}
		}

		closedir( dir );
		exit(0);
	}
	else
	{
		convert_crlf( argv[ 1 ] );
	}

	return 1;
}


int convert_crlf( const char* filename )
{
	FILE*	fr;
	char	r_buffer[ 0xFFFFF ];
	char	w_buffer[ 0xFFFFF ];
	int		wcntr;
	int		rcntr;
	int		i;

	if(!( fr = fopen( filename, "r" )))
	{
		printf( "failed to open for read %s\n", filename );
		return 0;
	}
	
	printf( "converting %s\n", filename );

	wcntr = 0;
	rcntr = fread( r_buffer, 1, sizeof(r_buffer), fr );

	for( i = 0; i < rcntr; i++ )
	{
		if( r_buffer[ i ] != 0x0D )
		{
			w_buffer[ wcntr++ ] = r_buffer[ i ];
		}
	}

	fclose(fr);

	if(!( fr = fopen( filename, "w" )))
	{
		printf( "failed to open for write %s\n", filename );
		return 0;
	}

	fwrite( w_buffer, 1, wcntr, fr );
	
	fclose(fr);
	
	return 1;
}


