//-------------------------------
//   5530 - Defines and Typedefs
//-------------------------------

//
//  Silence to fill the audio buffers
//
#define AUDIO_SILENCE           0

//
//  PCI Config address. 
//  Bits 15..11 specify the PCI device.
//  Bits 7..2 specify reg in PCI device.
//
#define PCI_CADDR         0x0CF8  

//                              
//  PCI Config data reg.
//  After PCI_ADDR set, this reg contains    
//  the corresponding data (the dev reg).
//
#define PCI_CDATA         0x0CFC  

//
//  Device and Vendor IDs
//

//  Following is the PCI Bridge (Func 0) ID.                                      
//  CYRIX's PCI Vendor ID.                                           
//
#define CYRIX_VENDOR_ID     0x1078   
#define NATIONAL_VENDOR_ID  0x100B   

//
//       Audio  Device IDs
//
#define	CX5530_DEV_ID    0x0103
#define	SC1200_DEV_ID    0x0503

//
//  This driver works with Scorpius and Unicorn Platforms
//
#define UNICORN_BRIDGE    (CYRIX_VENDOR_ID+0x1000000)  // 5530+Marmot   PCI code).
#define SCORPIUS_BRIDGE   (CYRIX_VENDOR_ID+0x4000000)  // 5530+Scorpius PCI ID).
#define CARMEL_BRIDGE     (NATIONAL_VENDOR_ID+0x5000000)  // 5540+Carmel PCI ID).

#define UNICORN_BRIDGE_0100   0x0100  // Unicorn PCI ID).

//
// Function 3 of 5530 PCI dev is Audio (ISA idx).
//
#define  PCI_FUNC3_AUDIO     0x300       
#define  PCI_AUDIO_CMD_REG   0x04

//
// Byte offset in mem mapped audio regs.    
//
#define  CODEC_CMD_REG       0x0c                                 

//
//   Bit conversions
//
#define BITS_8_TO_16(x) ( ( (long) ((unsigned char) x - 128) ) << 8 )
#define BITS_16_TO_8(x) ( ( (unsigned char) ((long) x >> 8 ) ) + 128 )

//
// The CODEC commands are actually 16-bit words, into which is inserted
// the codec "target" register, identified by a byte. The 5530 Codec
// controller writes a command unsigned short of 32-bits, that includes the codec
// command unsigned short.
//
#define KAHLUA_CODEC_COMMAND_MASK       0xFF00FFFF
#define KAHLUA_CODEC_NUM                ( 0 << 22)
#define RECORD_DMA_BUFFER_BASE (AUDIO_DMA_BUFFER_BASE + 2 * AUDIO_DMA_PAGE_SIZE)

//
//  The Interaction with the CODEC is a bit cumbersome 
//  because of the serial interface.
//
#define CODEC_STATUS_REG    0x08        // In Audio mem-map.
#define CODEC_CMD_REG       0x0c        // In audio mem-map.
#define CODEC_CMD_VALID     0x010000
#define CODEC_STATUS_VALID  0x00030000  // Bits 17..16. Status valid and new.

//
// Codec register indexes. Note these are all shifted left by 16 bits.
//
#define LM4548_MASTER_VOLUME        0x0200
#define LM4548_VIDEO_VOLUME         0x1400
#define LM4548_TV_VOLUME            0x1600
#define LM4548_PCM_OUT_VOL          0x1800
#define LM4548_EXT_AUDIO_CTRL_STAT  0x2A00
#define LM4548_PCM_FRONT_DAC_RATE   0x2C00
#define LM4548_PCM_LR_ADC_RATE      0x3200

//
// AD1819A registers 
//
#define AD1819A_SER_CONF			0x7400
#define AD1819A_SER_CONF_DRQEN		0x0800
#define AD1819A_MISC				0x7600
#define AD1819A_PCM_SR0				0x7800
#define AD1819A_PCM_SR1				0x7A00
#define AD1819A_VENDORID1			0x7C00
#define AD1819A_VENDORID2			0x7E00

//
//   Physical address of the device
//
#define AUDIO_REGS_BUFFER           0x40011000  

typedef enum 
{
	PCM_TYPE_M8,
	PCM_TYPE_M16,
	PCM_TYPE_S8,
	PCM_TYPE_S16
} PCM_TYPE, *PPCM_TYPE;

typedef struct  
{
	unsigned char sample;              // Unsigned 8-bit sample
} SAMPLE_8_MONO;

typedef struct  
{
	signed short sample;               // Signed 16-bit sample
} SAMPLE_16_MONO;

typedef struct  
{
	unsigned char sample_left;         // Unsigned 8-bit sample
	unsigned char sample_right;        // Unsigned 8-bit sample
} SAMPLE_8_STEREO;

typedef struct  
{
	unsigned short sample_left;        // Signed 16-bit sample
	unsigned short sample_right;       // Signed 16-bit sample
} SAMPLE_16_STEREO;

typedef union 
{
	SAMPLE_8_MONO m8;
	SAMPLE_16_MONO m16;
	SAMPLE_8_STEREO s8;
	SAMPLE_16_STEREO s16;
} PCM_SAMPLE, *PPCM_SAMPLE;


