#ifndef __GALAPI_SEP_20_2000
#define __GALAPI_SEP_20_2000

/* Structures common to API/GAL are defined in galproto.h */
#include "galproto.h"

/* Applications/User mode drivers use this ioctl to
 * send a graphics device request to the frame buffer
 * driver
 */
#define FBIOGAL_API      0x4700

/*
 * Applications must sign the I/O packet with this value
 */

#define FBGAL_SIGNATURE 0xC0C0BABE

/*
 * Version is a 16:16 fixed value
 * Current version is 1.0000
 */
#define FBGAL_VERSION 0x10000

/*
 * Definitions for Graphics Subfunctions
 *
 */
  /* General Adapter level functions */
#define GALFN_GETADAPTERINFO            0
#define GALFN_SETSOFTVGASTATE           1 /* Geode Specific */
#define GALFN_WAITUNTILIDLE             2
#define GALFN_WAITVERTICALBLANK         3
  /* Change/Get Display hardware state */
#define GALFN_ISDISPLAYMODESUPPORTED    10
#define GALFN_SETDISPLAYMODE            11
#define GALFN_GETDISPLAYMODE            12
#define GALFN_SETDISPLAYBPP             13
#define GALFN_GETDISPLAYBPP             14
#define GALFN_SETDISPLAYPITCH           15
#define GALFN_GETDISPLAYPITCH           16
#define GALFN_SETDISPLAYOFFSET          17
#define GALFN_GETDISPLAYOFFSET          18
#define GALFN_DOTCLKTOREFRESH           19 /* Geode Specific */
#define GALFN_GETDISPLAYTIMINGS         20
#define GALFN_SETDISPLAYTIMINGS         21
#define GALFN_SETPALETTE                22
#define GALFN_SETCOMPRESSIONSTATE       23
#define GALFN_SETCOMPRESSIONPARAMS      24
  /* Hardware cursor funtions */
#define GALFN_SETCURSORENABLE           30
#define GALFN_SETCURSORPOSITION         31
#define GALFN_SETCURSORSHAPE            32
#define GALFN_SETCURSORCOLORS           33
  /* grafix rendering funtions */
#define GALFN_SETSOLIDPATTERN           40
#define GALFN_SETRASTEROPERATION        41
#define GALFN_SETSOLIDSOURCE            42
#define GALFN_PATTERNFILL               43
#define GALFN_SETMONOPATTERN            44
#define GALFN_SCREENTOSCREENBLT         45
#define GALFN_SCREENTOSCREENXBLT        46
#define GALFN_BRESENHAMLINE             47
  /* VGA Support functions */
#define GALFN_VGAMODESWITCH             50
#define GALFN_VGACLEARCRTEXT            51
#define GALFN_VGASETPITCH               52
#define GALFN_VGARESTORE                53
#define GALFN_VGASAVE                   54
#define GALFN_VGASETMODE                55

#define GAL_HEADER\
    DWORD  dwSignature;    /* Sign all structs with FBGAL_SIGNATURE    */\
    DWORD  dwSize;         /* Size of struct for that subfunction      */\
    DWORD  dwVersion;      /* Current version of the API               */\
    DWORD  dwSubfunction;  /* GAL subfunction                          */\
    DWORD  dwReturnValue;  /* Return value from subfunction */

typedef struct __GAL_BASE
{
    GAL_HEADER
} GAL_BASE, *PGAL_BASE;

/*
 * #define GALFN_GETADAPTERINFO
 */
typedef struct __GAL_GETADAPTERINFO
{
    GAL_HEADER
    GALAPP_ADAPTERINFO sAppInfo;
} GAL_GETADAPTERINFO, *PGAL_GETADAPTERINFO;

/*
 * #define GALFN_SOFTVGASTATE
 */
typedef struct __GAL_SOFTVGASTATE
{
    GAL_HEADER
    BOOLEAN   bSoftVgaEnable;
} GAL_SOFTVGASTATE, *PGAL_SOFTVGASTATE;

/*
 * #define GALFN_WAITUNTILIDLE
 */
typedef struct __GAL_WAITUNTILIDLE
{
    GAL_HEADER
} GAL_WAITUNTILIDLE, *PGAL_WAITUNTILIDLE;

/*
 * #define GALFN_WAITVERTICALBLANK
 */
typedef struct __GAL_WAITVERTICALBLANK
{
    GAL_HEADER
} GAL_WAITVERTICALBLANK, *PGAL_WAITVERTICALBLANK;

/*
 * #define GALFN_ISDISPLAYMODESUPPORTED
 * #define GALFN_SETDISPLAYMODE
 * #define GALFN_GETDISPLAYMODE
 */
typedef struct __GAL_DISPLAYMODE
{
    GAL_HEADER
    WORD   wXres;
    WORD   wYres;
    WORD   wBpp;
    WORD   wRefresh;
    DWORD  dwSupported;
} GAL_DISPLAYMODE, *PGAL_DISPLAYMODE;

/*
 * #define GALFN_SETBPP
 * #define GALFN_GETBPP
 * #define GALFN_SETPITCH                  
 * #define GALFN_GETPITCH                  
 * #define GALFN_SETOFFSET                 
 * #define GALFN_GETOFFSET                 
 */
typedef struct __GAL_DISPLAYPARAMS
{
    GAL_HEADER
    DWORD  dwOffset;
    WORD   wBpp;
    WORD   wPitch;
} GAL_DISPLAYPARAMS, *PGAL_DISPLAYPARAMS;

/*
 * #define GALFN_DOTCLKTOREFRESH
 */
typedef struct __GAL_DOTCLKTOREFRESH
{
    GAL_HEADER
    DWORD  dwDotClock;
    WORD   wXres;
    WORD   wYres;
    WORD   wBpp;
    WORD   wRefreshRate;
} GAL_DOTCLKTOREFRESH, *PGAL_DOTCLKTOREFRESH;

/*
 * #define GALFN_GETDISPLAYTIMINGS
 * #define GALFN_SETDISPLAYTIMINGS
 */
typedef struct __GAL_DISPLAYTIMING
{
    GAL_HEADER
    GALAPP_DISPLAYTIMING sAppTiming;
} GAL_DISPLAYTIMING, *PGAL_DISPLAYTIMING;

/*
 * #define GALFN_SETPALETTE
 */
typedef struct __GAL_PALETTE
{
    GAL_HEADER
    GALAPP_PALETTE sAppData;
} GAL_PALETTE, *PGAL_PALETTE;

/*
 * #define GALFN_SETCOMPRESSIONSTATE  
 */
typedef struct __GAL_SETCOMPRESSIONSTATE
{
    GAL_HEADER
    BOOLEAN   bCompressionState;
} GAL_SETCOMPRESSIONSTATE, *PGAL_SETCOMPRESSIONSTATE;

/*
 * #define GALFN_SETCOMPRESSIONPARAMS
 */
typedef struct __GAL_SETCOMPRESSIONPARAMS
{
    GAL_HEADER
    DWORD dwFlags;
    DWORD dwCompOffset;
    DWORD dwCompPitch;
    DWORD dwCompSize;
} GAL_SETCOMPRESSIONPARAMS, *PGAL_SETCOMPRESSIONPARAMS;

/*
 * #define GALFN_SETCURSORENABLE
 */
typedef struct __GAL_SETCURSORENABLE
{
    GAL_HEADER
    BOOLEAN   bCursorEnable;
} GAL_SETCURSORENABLE, *PGAL_SETCURSORENABLE;

/*
 * #define GALFN_SETCURSORPOSITION
 */
typedef struct __GAL_SETCURSORPOSITION
{
    GAL_HEADER
    DWORD  dwMemOffset;
    WORD   wXPos;
    WORD   wYPos;
    WORD   wXHot;
    WORD   wYHot;
} GAL_SETCURSORPOSITION, *PGAL_SETCURSORPOSITION;

/*
 * #define GALFN_SETCURSORSHAPE
 */
typedef struct __GAL_SETCURSORSHAPE
{
    GAL_HEADER
    DWORD  dwMemOffset;
    DWORD  dwAndMask[32]; /* Most gfx hardware support only 32x32     */
    DWORD  dwXorMask[32];
} GAL_SETCURSORSHAPE, *PGAL_SETCURSORSHAPE;


/*
 * #define GALFN_SETCURSORCOLORS
 */
typedef struct __GAL_SETCURSORCOLORS
{
    GAL_HEADER
    DWORD  dwBgColor;
    DWORD  dwFgColor;
} GAL_SETCURSORCOLORS, *PGAL_SETCURSORCOLORS;

/*
 * #define GALFN_SETSOLIDPATTERN
 */
typedef struct __GAL_SETSOLIDPATTERN
{
    GAL_HEADER
    DWORD  dwColor;
} GAL_SETSOLIDPATTERN, *PGAL_SETSOLIDPATTERN;

/*
 * #define GALFN_SETRASTEROPERATION
 */
typedef struct __GAL_SETRASTEROPERATION
{
    GAL_HEADER
    CHAR   cRop;
} GAL_SETRASTEROPERATION, *PGAL_SETRASTEROPERATION;

/*
 * #define GALFN_SETSOLIDSOURCE
 */
typedef struct __GAL_SETSOLIDSOURCE
{
    GAL_HEADER
    DWORD  dwColor;
} GAL_SETSOLIDSOURCE, *PGAL_SETSOLIDSOURCE;

/*
 * #define GALFN_PATTERNFILL
 */
typedef struct __GAL_PATTERNFILL
{
    GAL_HEADER
    WORD   wXPos;
    WORD   wYPos;
    WORD   wWidth;
    WORD   wHeight;
} GAL_PATTERNFILL, *PGAL_PATTERNFILL;

/*
 * #define GALFN_SETMONOPATTERN
 */
typedef struct __GAL_SETMONOPATTERN
{
    GAL_HEADER
    DWORD  dwBgColor;
    DWORD  dwFgColor;
    DWORD  dwData0;
    DWORD  dwData1;
    CHAR   cTransparency;
} GAL_SETMONOPATTERN, *PGAL_SETMONOPATTERN;

/*
 * #define GALFN_SCREENTOSCREENBLT
 */
typedef struct __GAL_SCREENTOSCREENBLT
{
    GAL_HEADER
    WORD   wXStart;
    WORD   wYStart;
    WORD   wXEnd;
    WORD   wYEnd;
    WORD   wWidth;
    WORD   wHeight;
} GAL_SCREENTOSCREENBLT, *PGAL_SCREENTOSCREENBLT;


/*
 * #define GALFN_SCREENTOSCREENXBLT
 */
typedef struct __GAL_SCREENTOSCREENXBLT
{
    GAL_HEADER
    WORD   wXStart;
    WORD   wYStart;
    WORD   wXEnd;
    WORD   wYEnd;
    WORD   wWidth;
    WORD   wHeight;
    WORD   wColor;
} GAL_SCREENTOSCREENXBLT, *PGAL_SCREENTOSCREENXBLT;

/*
 * #define GALFN_BRESENHAMLINE
 */
typedef struct __GAL_BRESENHAMLINE
{
    GAL_HEADER
    WORD   wX1;
    WORD   wY1;
    WORD   wLength;
    WORD   wErr;
    WORD   wE1;
    WORD   wE2;
    WORD   wFlags;
} GAL_BRESENHAMLINE, *PGAL_BRESENHAMLINE;

/*
 * #define GALFN_VGAMODESWITCH 
 * #define GALFN_VGACLEARCRTEXT
 * #define GALFN_VGASETPITCH   
 * #define GALFN_VGARESTORE
 * #define GALFN_VGASAVE   
 * #define GALFN_VGASETMODE
 */
typedef struct __GAL_VGAMODEDATA
{
    GAL_HEADER
    DWORD  dwFlags;       /* Flags for this subfunction */
    GALAPP_VGAREGS sVgaRegs;     /* CRT+SEQ+SEQ register data block */
    WORD   wXres;
    WORD   wYres;
    WORD   wBpp;
    WORD   wRefresh;
} GAL_VGAMODEDATA, *PGAL_VGAMODEDATA;
#endif
