#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include <fcntl.h>
#include <scanner.h>
#include <stdio.h>
#include <unistd.h>
#include <vga.h>

char point(int x,char buf[1024]) {
  return (buf[x >> 3] & (0x80 >> (x & 7)))!=0;
}

void main() {
  struct modeinfo_struct info;

  int fd,bpl,cc,y,a;

  char buf[1024];
  int pal[768];

  if ((fd=open("/dev/gs4500",O_RDONLY))<0) 
    perror("open");

  if (ioctl(fd,HSIOCMODE,SCM_SINGLESHOT)<0) 
    perror("ioctl");

  if (ioctl(fd,HSIOCGMOD,&info)<0) 
    perror("ioctl");

  vga_init();

  vga_setmode(G640x480x256);

  for (a=0; a<255;a++) {
    pal[a*3]=pal[a*3+1]=pal[a*3+2]=a >> 2;
  }

  vga_setpalvec(0,256,pal);

  bpl = info.bpl;

  y=0;

  while (1) {

    read(fd,buf,bpl);

    for (cc=0; cc<640; cc++) {
      
      a = point(cc,buf);

      vga_setcolor(a*253);
      vga_drawpixel(cc,y);
    }
        
    y++;
    if (y==480) y=0;

  }


  close(fd);

}







