#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/Xaw/Command.h>    /* Athena Command Widget */
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Reports.h>

#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

#define MAXSCANLINES 4000	/* Maximum Number of scannlines (Default) */
#define MAXWIDTH     1200

typedef struct {	/*	structure for own resources */
	int MaxScanLines;
} XscanApp;
 
extern Colormap default_cmap;
extern char **linebuf;	
extern Display *disp;
extern Window  win;
extern Screen *screen;
extern int screennum;
extern int pixmapdepth;
extern int lines_scanned;
extern int bytes_per_line;
extern XtAppContext app_context;
extern Widget topLevel, quit;
extern Widget cell8, cell4, cell2;
extern Widget InputBox,SelectBox,ScanBox;
extern Widget ResLabel,ShowLabel;
extern Widget ScanW, SaveW;
extern Widget Canvas,DrawArea;
extern Pixmap DrawPix;
extern GC DrawGC, ClrGC;
extern long colors[65];
extern Dimension pixmap_width;
extern Dimension pixmap_heigh;
extern char ScanLabel[40];
extern int scaninprog;
extern Dimension slider_width, slider_height;
extern Position slider_x, slider_y;
extern int cellsize;
extern int oldcell;
extern int bufcnt;
extern int fd;				/* filedescriptor for scann-device   */
extern XtInputId AppId;
extern int canvas_line;
extern XscanApp XscanAppData;
extern XImage *scanlineimg;

void QRedraw(int line);
void Scan(Widget w, XtPointer client_data, XtPointer call_data);
void Redraw(Widget w, XtPointer p1, XtPointer p2 );
void ClrDraw(void);
void PopupScanDialog(void);
void PopdownScanDialog(Widget w, XtPointer client_data, XtPointer call_data);
void PopdownSaveDialog(Widget w, XtPointer client_data, XtPointer call_data);
void Save(char *filen);
void PopdownSDialog(Widget w, XEvent *unused,String *unused1,Cardinal *unused2);void RedrawCanvas(Widget w, XEvent *unused,String *unused1, Cardinal *unused2);
void FreePixMap(void);
void MakePixMap(void); 
void Make(void);
void Message(char *txt);
void MessageOff(void);
void FlushEvents(void);
void get_line(XtPointer *unused, int fid, XtInputId *id);
void ScanInfo(int *bpl, int *dpi);

void WaitCursor(void);
void NormalCursor(void);



