         TITLE 'EAG   3.0 * EAGSTCR stub'
***********************************************************************
*
* Module name:       EAGSTCR
*
* Descriptive name:  REXX/370 stub for either C/370 "OS" linkage or
*		     REXX EFPL parm lists.
*
* Author:            Thorsten Schaper, IBM
*                    thorsten.schaper@de.ibm.com
*
* Created:           07/19/2000
* Last modfication: 11/30/2000
*
* Function:
*   This stub decides at runtime from where it has been called, C/C++
*   or REXX, and branches (BASR) to the appropriate specialized stub.
*
* Build:
*   This code must be assembled and linked with the EAGSTC and
*   EAGSTEFP stub load modules so that the external references to them
*   are resolved.
*
***********************************************************************

EAGSTUB  AMODE 31
EAGSTUB  RMODE ANY
EAGSTUB  CSECT
         ENTRY EAGSTUB
         EXTRN EAGSTC
         EXTRN EAGSTEFP
                                                                SPACE 1
         STM   R14,R12,12(R13)      Save regs in caller's save area
         LR    R12,R15              Set base reg to start of load mod
         USING EAGSTUB,R12          CSECT EAGSTUB addressability
                                                                SPACE 1
         LR    R2,R1                Get parm list pointer in R2
         LR    R3,R0                Get ENVBLOCK pointer in R3 (only
*                                   if called from REXX environment)
         LA    R0,STSIZE
         GETMAIN RU,LV=(0)
         ST    R13,4(,R1)           Save caller's SA addr in my SA
         ST    R1,8(R13)            Save my SA addr in caller's SA
         LR    R13,R1               Let R13 point to gotten storage
         USING STORAGE,R13          DSECT STORAGE addressability
         ST    R0,STORLEN           Keep size of gotten storage
                                                                SPACE 1
TEST1    DS   0H
         LTR   R1,R2                ...no parm list pointer at all?
         BNZ   TEST2
         L     R15,ASTC             -> must be void C parmlist
         BASR  R14,R15
         B     TIDYUP
                                                                SPACE 1
TEST2    DS   0H
         L     R4,0(,R1)            get first word of parmlist
         LTR   R4,R4                ...word of zeros found?
         BNZ   TEST3
         LR    R0,R3
         L     R15,ASTEFP
         BASR  R14,R15              -> must be EFPL parmlist
*                                      XXX this not really sure !!!
         B     TIDYUP
                                                                SPACE 1
TEST3    DS   0H
         L     R15,ASTC
         BASR  R14,R15              -> if not EFPL then C parmlist
                                                                SPACE 1
TIDYUP   DS   0H
         L     R10,4(,R13)          Get addr of caller's save area
         ST    R15,16(,R10)         Store addr of return string in it
         L     R0,STORLEN           Get size of storage gotten in R0
         LR    R1,R13               Get addr of storage gotten in R1
         DROP  R13
         LR    R13,R10              Restore R13 to point to caller's SA
         FREEMAIN RC,LV=(0),A=(1)   Release the allocated memory
         DROP  R12
         LM    R14,R12,12(R13)      Restore registers from caller's SA
         BR    R14                  Return to caller
                                                                EJECT
***********************************************************************
* CONSTANTS
***********************************************************************
                                                                SPACE 1
ASTC     DC    V(EAGSTC)            Address of CREXX stub
ASTEFP   DC    V(EAGSTEFP)          Address of EFPL  stub
                                                                SPACE 1
***********************************************************************
* DSECT and EQU stuff:
* - Build up STSTORAG DSECT.
* - Register EQUs.
***********************************************************************
                                                                SPACE 1
STORAGE  DSECT
STSAVE   DS    18F                  My save area
STORLEN  DS    F                    length of getmained storage
         DS   0D
STSIZE   EQU   *-STORAGE
                                                                SPACE 1
R0       EQU   0
R1       EQU   1
R2       EQU   2
R3       EQU   3
R4       EQU   4
R5       EQU   5
R6       EQU   6
R7       EQU   7
R8       EQU   8
R9       EQU   9
R10      EQU   10
R11      EQU   11
R12      EQU   12
R13      EQU   13
R14      EQU   14
R15      EQU   15
                                                                SPACE 1
EAGSTUB  CSECT
         DS   0D
EAGSTBL  EQU   *-EAGSTUB            Determine stub code length
         END
