/*REXX
 * purpose: Submit a job using FTP client and commands on stack.
 * systems: VM/CMS, MVS/TSO, MVS/USS
 */

PARSE ARG host uid pwd jclIn jclOut ftpOut

PARSE UPPER SOURCE src
os1 = word(src, 1)
os2 = word(src, words(src))

say 'running on OS:'
say '  'os1 '[' os2 ']'
say 'plan is to:'
say '   logon to machine               :' host
say '         with user ID             :' uid
say '   submit JCL job in remote file  :' jclIn
say '   store JCL output in local file :' jclOut
say '   store FTP msgs in local file   :' ftpOut
say

QUEUE host
QUEUE uid pwd
QUEUE 'site filetype=JES'
QUEUE 'site jesrecfm=F'
QUEUE 'site jeslrecl=80'
QUEUE 'get' jclIn jclOut '(REPLACE'
QUEUE 'quit'

SELECT

   WHEN os1 = 'TSO' & os2 = 'OPENMVS' THEN DO

      call syscalls 'SIGOFF'
      ADDRESS LINKMVS 'FTP'
      END

   WHEN os1 = 'TSO' THEN DO

      ADDRESS TSO
      'ALLOC DA('ftpOut') DD(OUTPUT) SHR REU'
      'FTP'
      'FREE DD(OUTPUT)'
      END

   WHEN os1 = 'CMS' THEN DO

      ADDRESS CMS
      'FILEDEF OUTPUT DISK' ftpout 'DATA A'
      'FTP'
      'FILEDEF OUTPUT CLEAR'
      END

   OTHERWISE

      say 'sorry, but your OS:' os1 'is not supported.'

END
