/*****************************************************************************/
/* (C) Copyright IBM Corporation 1998.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/
  parse arg type, list, who
  parse var list 'amount='amount'&interest='interest'&years='years'&fyear='fyear'&submit='submit

  NUMERIC DIGITS 14   /* determines the degree of accuracy */
  html = .HTML~new
  if arg(4,'o') = 0 then html~queue = arg(4) /* only needed for client-server CGI */
  html~title('Loan amortization calculated with Object REXX')
  html~h2('Loan amortization input')
  html~p('Please enter the following values and press "Calculate" to calculate the payment figures.')
  html~p
  if interest~DataType("N") = 0 then interest = 9
  if fyear~DataType("N") = 0 then fyear = date()~right(4)
  /* input form aligned in a table */
  html~form("/cgi-bin/orxwww/www2")
  html~table("border=0 cellpadding=1")
  html~tr;  html~td("Loan principal amount:");
  html~td;  html~input("Text","amount",amount);  html~etd
  html~td("US$");
  html~tr;  html~td("Annual interest rate:");
  html~td;  html~input("Text","interest",interest);  html~etd
  html~td("%");
  html~tr;  html~td("Loan period in years:");
  html~td;  html~input("Text","years",years);  html~etd
  html~tr;  html~td("Base year of loan:");
  html~td;  html~input("Text","fyear",fyear);  html~etd
  html~tr;  html~td
  html~td;  html~input("Submit", "submit", "Calculate");  html~etd
  html~etable
  html~eform
  if submit = 'Calculate' then do   /* Calculate button was pushed */
      html~ingohome
      q = 1 + interest/100/12
      ann = amount*q**(years*12)*(q-1)/(q**(years*12)-1)
      tot_pay = ann*12*years
      
      html~h2('Payment overview')
      html~strong('The following figures are for monthly payment afterwards.')
      html~p

      /* do key figures table */
      html~table('border=5 cellpadding=5')
      html~~tr~~td("Annual loan payments:")         ~td('$'Format(ann*12,,2),'align=right')
      html~~tr~~td("Monthly loan payments:")        ~td('$'ann~format(,2),'align=right')
      html~~tr~~td("Interest over term of loan:   ")~td('$'Format(tot_pay-amount,,2),'align=right')
      html~~tr~~td("Sum of all payments:")          ~td('$'tot_pay~format(,2),'align=right')
      html~etable

      /* amortization table with as many rows as the loan period */       
      html~h2('Amortization table')
      html~p
      html~table('border=1 cellpadding=4')
      html~tr  /* new table row */
      html~~th('Year')~~th('Balance')~~th('Payments')~~th('Principal')~~th('Interest')
      html~~th('Cum. Principal')~~th('Cum. Interest')~~th('Ending Balance')

      bal = amount
      c_principal = 0
      c_int = 0
      
      do y = fyear+1 to fyear+years
         html~tr
         html~td(y,'align=center')
         html~td(bal~format(,2),'align=right')  /* format with 2 digits after the . */
         bal_e = bal*q**12 - ann*(q**12-1)/(q-1)
         a_int = ann*12-(bal-bal_e)
         html~td(Format(ann*12,,2),'align=right')
         html~td(Format(bal-bal_e,,2),'align=right')
         html~td(a_int~format(,2),'align=right')
         c_principal = c_principal + bal-bal_e
         html~td(c_principal~format(,2),'align=right')
         c_int = c_int + a_int
         html~td(c_int~format(,2),'align=right')
         html~td(bal_e~format(,2),'align=right')
         bal = bal_e
      end 
      html~etable
      html~pc; html~tt("This sample is based on a Lotus 123 example and was adapted by Ingo Holder.")
      html~pc; html~tt("All information is supplied without liability!")
  end    
  html~sign
  html~send  /* send the HTML to the internet server */
  return

::requires html.cls
