/*--------------------------------------------------------------------------*/
/*                                                                          */
/*  NetCentric Computing with Object Rexx                                   */
/*  Programming Example                                                     */
/*                                                                          */
/*    Kurt Maerker       Kurt_Maerker@vnet.ibm.com                          */
/*                                                              03/03/97    */
/*  Chat_s.cmd  -  A TCP/IP Server with Interacting Clients                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/

aChatServer = .ChatServer~new(1924)    /* Create a chat server at port 1924 */ 
aChatServer~startAccepting             /* Listen at socket for clients      */    
aChatServer~shutdown                   /* server shutdown                   */    
                                       
/****************************************************************************/

::REQUIRES "servers.frm"               /* Load the servers framework        */   

/*--------------------------------------------------------------------------*/
/* ChatServer Class definition                                              */
/*--------------------------------------------------------------------------*/
::CLASS ChatServer SUBCLASS tcpServer PUBLIC

/*--------------------------------------------------------------------------*/
::METHOD init
  expose KnownPort Table
  use arg KnownPort

  self~init:super(KnownPort)           /* Run the superclass init           */
  Table = .Conversation~new            /* Create a Table with empty seats   */                                          
                                          
/*--------------------------------------------------------------------------*/
::METHOD NewClient UNGUARDED           /* Over-write superclass' method     */    
  expose Table
  use arg cSocket   

  Table~takeSeat(cSocket)              /* A new client takes a seat         */


/*--------------------------------------------------------------------------*/
/* Conversation Class definition                                            */
/*--------------------------------------------------------------------------*/
::CLASS Conversation                   /* A place to have a chat            */    

/*--------------------------------------------------------------------------*/
::METHOD init                      
  expose Talkers              

  Talkers = .bag~new                   /* A collection of conversationalists*/

/*--------------------------------------------------------------------------*/
::METHOD takeSeat                      /* Seat a client at the table        */
  expose Talkers              
  use arg cSocket   
                 
  aTalker = .Talker~new(cSocket, self) /* Create a new talker and register  */
  Talkers~put(aTalker)                 /* it in the talkers collection      */

/*--------------------------------------------------------------------------*/
::METHOD leaveSeat                     /* Seat a client at the table        */
  expose Talkers              
  use arg aTalker  
          
  Talkers~remove(aTalker)              /* Remove the talker from collection */

/*--------------------------------------------------------------------------*/
::METHOD ISay                          /* A client speaks up                */
  expose Talkers              
  use arg WhatHeSaid 
          
  do aTalker over Talkers              /* Let all clients hear it           */      
    aTalker~HeSaid(WhatHeSaid)
  end


/*--------------------------------------------------------------------------*/
/* Talker Class definition                                                  */
/*--------------------------------------------------------------------------*/
::CLASS Talker                         /* One is created for each client    */    

/*--------------------------------------------------------------------------*/
::METHOD init                      
  expose mySocket theGroup IAm
  use arg mySocket, theGroup

  IAm = mySocket~HostName              /* So the'll knoe who is speaking    */
  self~Listen

/*--------------------------------------------------------------------------*/
::METHOD Listen UNGUARDED              /* When client speaks through socket */
  expose mySocket theGroup IAm
  reply                                /* Frees up other concurrent work    */ 
                                       /* Process the rest in another thread*/
  do until input = "quit"              /* Repeat until the input is 'quit'  */    
    input = mySocket~ReceiveData
    if \mySocket~stillOpen then leave
    theGroup~ISay(IAm":" input)
  end

  theGroup~leaveSeat(self)             /* client leaves seat at the table   */ 
  mySocket~Close                       /* close client's socket             */ 
  
/*--------------------------------------------------------------------------*/
::METHOD HeSaid                        /* Other speaker's words be sent here*/
  expose mySocket 
  use arg theWords
              
  mySocket~SendData(theWords)          /* then send the words               */

