/******************************************************************************/
/* Object REXX                                                     zapini.cmd */
/*                                                                            */
/* Licensed Materials - Property of IBM                                       */
/* (C) Copyright IBM Corp. 1996. All Rights Reserved.                         */
/*                                                                            */
/* U.S. Government Users Restricted Rights - Use, duplication or disclosure   */
/* restricted by GSA ADP Schedule Contract with IBM Corp.                     */
/*                                                                            */
/* Remove old entries of Object REXX from Software Installer INI files in     */
/* case of problems.                                                          */
/*                                                                            */
/* Calling parameters:                                                        */
/*      ZAPINI d:                                                             */
/*         where d: is the drive where EPFIS.INI is located (defaults to C:)  */
/*                                                                            */
/******************************************************************************/

Parse Arg DriveLetter

If DriveLetter = '' Then
  DriveLetter = 'C:\'

If SubStr(DriveLetter, Length(DriveLetter), 1) != '\' Then
  DriveLetter = DriveLetter || '\'

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

SearchFileSpec = DriveLetter || 'EPFIS.INI'
Call SysFileTree SearchFileSpec, 'FILES.', 'FS'

If Files.0 = 0 Then
  Do
    Say "Couldn't locate EPFIS.INI in drive/directory" DriveLetter
    Say "Please specify the drive or directory where this file is located"
    Say "(normally your boot drive) as the first parameter to ZAPINI.CMD."
    Exit
  End

Parse Var Files.1 Date Time Size Attribs FileName
Drop Files
FileName = Strip(FileName)

If SysIni(FileName, 'ALL:', 'APPS') \= 'ERROR:' Then
  Do
    Do i = 1 To APPS.0
      If POS('Object REXX', APPS.i) \= 0 Then
        Do
          If SysIni(FileName, APPS.i, 'DELETE:') \= 'ERROR:' Then
            Say "Object REXX entries successfully deleted from EPFIS.INI"
          Else
            Say "Error deleting Object REXX entries from EPFIS.INI."

          Exit
        End
    End
  End

Say "No entry for Object REXX found in EPFIS.INI"
