/********************************************************/
/*                                                      */
/* CONCURR3.CMD - IBM Object REXX Sample Program        */
/*                                                      */
/* Sample program to demonstrate the GUARD OFF WHEN     */
/* instruction of Object REXX.                          */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1997 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/
myObj = .Waiter~new
myObj~Wait
myObj~Increment

::CLASS Waiter
::METHOD Init
  Expose Counter
  Counter = 0 /* needs to be initialized */

::METHOD Increment
  Expose Counter
  Counter = 0
  Say "Start counting"

  Do Counter = 1 To 100000
    If Counter // 10000 = 0 Then
      Say "Counter is at" Counter
  End

::METHOD Wait
  Expose Counter
  Say "Waiting for Counter exceeding 50000"
  Reply

  /* suspend execution until counter reaches 50000 */
  Guard Off When Counter > 50000

  /* now the method runs unguarded */
  Say "Counter exceeded 50000 and has a value of" Counter
