#!/usr/local/orexx/bin/rexx
/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  NetCentric Computing with Object Rexx                                    */
/*  Programming Example                                                      */
/*                                                                           */
/*  (c) Copyright IBM Corporation 1999                                       */
/*                                                                           */
/*  cgi-rexx.cmd - CGI REXX Interface processor                              */
/*                                                                           */
/*  Requirements:                                                            */
/*    html.frm  - HTML Support Framework, a Base HTML Support Class          */
/*    All html schripts have to reside in the directory "orxwww"             */
/*                                                                           */
/*  This code is sample code, provided "AS IS", without warranty of any kind */
/*                                                                           */
/*---------------------------------------------------------------------------*/
--use arg script                       /* use this only for debugging        */

parse source . . path                  /* get the path of this script        */
path = path~changestr('\', '/')        /* transform path to unix style       */
sourcedir = path~left(path~lastpos('/') - 1)
                                       /* env. variables set by Web server   */
script = value('SCRIPT_NAME', , environment)  /* script name                 */
who    = value('REMOTE_ADDR', , environment)  /* IP-address of the sender    */
plist  = value('QUERY_STRING', , environment) /* parameter string            */

Signal on syntax name error            /* establish error handler            */

parse var script '/cgi-bin/' type      /* extract cgi request type           */
list = translate(plist, ' ', '+'||'090D0A'x) /* Whitespace, etc.             */

if left(type,7) = 'orxwww/' then do     
  dir = directory(sourcedir)           /* change directory to sourcedir      */
  cscr = script~substr(script~lastpos('/') + 1) /* get the script name       */  

  call (cscr) type, list, who          /* call requested script              */
  html = result                        /* get the resulting html object      */ 
  do line over html                    /* put out html object line by line   */
    say line                  
  end
end 
else 
  call error
return

/*---------------------------------------------------------------------------*/
error:                                 /* return the error in HTML format    */
  say 'Content-Type: text/html'
  say ''
  say '<html><head><title>Automatically Generated Error Report</title></head>'
  say '<body>'
  say '<h1>Error report</h1>'
  say '<hr>'
  say '<p><b>Invalid request of type:' type '</b>' 
  say '<p>Who   :' who
  say '<br>Script :' script
  say '<br>Type :' type
  say '<br>pList :' plist
  say '<p><tt>-------------------- begin of error message -------------------' 
  except = condition('o')              /* report the problem                */ 
  say '<br>Error in "'except~program'" line' except~position':'  
  do traceline over except~traceback 
    say '<br>'traceline
  end 
  say '<br>Error' except~rc except~errortext 
  say '<br>Error' except~code except~message
  say '<br>-------------------- end of error message ---------------------</tt><p>' 
                                       /* embed the footing from file        */                     
  stream = .stream~new('\www\orxwww\footing.htm')
  stream~open(READ)
  do line over stream
    say line
  end 
  stream~close  
  say '</body></html>'   
  return

