/*****************************************************************************/
/* Another Form with Select List                                   form2.cmd */ 
/*                                                                           */
/* (C) Copyright IBM Corporation 1999.                                       */
/*                                                                           */
/* This code is sample code, provided "AS IS", without warranty of any kind  */
/*****************************************************************************/

use arg type, list, address            /* get the arguments                  */

parm = .parmdir~new(list)              /* create parameter directory         */

html = .myHtml~new                     /* create an html object              */          
html~title('Another Form with Object REXX')
html~h1('Another' big(brown('Form')) 'with Select Lists')

if 'Process' = parm['submit'] then do   
  html~p("You entered:")
  html~p("Name = "green(parm['name']))
  html~br("Profession = "green(parm['profession']))
  html~br("Location = "green(parm['city']))
  html~br("Hobbies = "green(parm~list('hobbies')))
  html~p('Your comment:')
  html~br(green(breaks(parm['comment'])))

  html~form("/cgi-bin/orxwww/form2")   /* cgi-form with 'Again' button       */ 
  html~submit("submit", "Again")
  html~eform
end
else do
  cities = .array~of("London","Berlin","Washington","Tokyo","Vienna", "Boeblingen")
  hobbies = .array~of('skiing','swimming','horseback riding','bowling','skating','sailing','other') 
  selected = .array~of(2, 5)

  html~p('Enter the values and press "Process" to continue.')

  html~form("/cgi-bin/orxwww/form2")   /* cgi-form with 'Process' button     */
  html~b("Name:")~itext("name", "")
  html~b(" Profession:")~itext("profession", "")
  html~p~b("Location:")~select("city", cities, 'size=4', 'pick one!')
  html~t~b("Hobbies:")~selectm("hobbies", hobbies, 'size=4', selected, 'pick some!')
  html~p~b('Comments:')
  html~br~textarea('comment', 3 48, 'wrap=off', 'Type your comments here!') 

  html~p~submit("submit", "Process")
  html~eform
end   

html~footing("/orxwww/form2.cmd")      /* footing with code reference        */
return html~end                        /* end HTML document and return it    */

::requires "myhtml.cls"                /* load myHtml class                  */
