/* REXX ****************************************************************/
/*   (c) Copyright International Business Machines Corp. 1998, 2000    */
/*                        ALL RIGHTS RESERVED                          */
/* Author: Reiner Micke                               Date: 28.03.2000 */
/*---------------------------------------------------------------------*/
/* This SAMPLE REXX procedure does a backup of all members of a PDS    */
/* Partitioned Data Set with record format fixed blocked from a MVS    */
/*    server system via the FTP application interface of REXX.         */
/* After a backup only new files or updated files will be transferred, */
/* if this REXX procedure is called again.                             */
/* The following parameters must be set: MVS host, user ID, the PDS    */
/*     for backup, and the backup directory on your AIX or Windows     */
/*     or OS/2 or LINUX system with (Object) REXX running on.          */
/* NOTE: The statistics must be activated for all members in your PDS. */
/*---------------------------------------------------------------------*/
RemHost    = "hostname";               /* Name of remote MVS host      */
RemHostUID = "uid";                    /* User ID of remote MVS host   */
RemHostDIR = "'uid.qua1.qual2.qual3'"; /* Backup directory on MVS host */
SubDirBack = "BACKFB80";               /* Local Subdirectory for backup*/
/*---------------------------------------------------------------------*/
RetCode    = 0;                        /* Set return code to 0         */
SeeLogFile = 0;                        /* Indicate error in log file   */
TransCntl  = 0;                        /* File transfer counter        */

/* Load the necessary REXX API libraries    ---------------------------*/
If RxFuncQuery("SysLoadFuncs") Then
  Do
    RetCode = RxfuncAdd('SysLoadFuncs','rexxutil','SysLoadFuncs');
    RetCode = SysLoadFuncs();
End
If RxFuncQuery("FtpLoadFuncs") Then
  Do
    RetCode = RxFuncAdd("FtpLoadFuncs","rxftp","FtpLoadFuncs");
    RetCode = FtpLoadFuncs();
End
If RetCode <> 0 then
  Do
    say " *** ERROR: Could not load >rxftp< API library! RC = "RetCode;
    Exit(99);
End

/* Get the operating system for directory delimiter ------------------*/
parse upper source  OpSys .
If OpSys = "AIX" | OpSys = "LINUX" then
  Do
   DirChar = "/";                               /* directory delimiter*/
   EnterKey = "0A";                             /* Hex code for CR    */
End
else
  Do
   DirChar = "\";                               /* directory delimiter*/
   EnterKey = "0D";                             /* Hex code for LF    */
End

/* Get the password for the remote host     ---------------------------*/
password = '';
say ""
say " Please enter the PASSWORD for user >"RemHostUID"< "
say " at remote host >"RemHost"<  and press the <ENTER> key."
do forever
    key = sysGetKey('noecho')
    if c2x(key) = EnterKey then leave  /* terminate with CR at <ENTER> */
    password = password||key
end;
password = strip(password);
If length(password) < 2 then
  Do
    say " *** ERROR: No password entered!"
    exit(88);
End

/* Prepare for data transfer ------------------------------------------*/
SaveDir = Directory();
RetCode = Directory(SubDirBack);
If RetCode = SaveDir | RetCode = '' Then
  Do
    RetCode = SysMkDir(SubDirBack);
    If ( RetCode <> 0 ) Then
      Do
        Say " *** ERROR: No access to the backup directory: "SubDirBack,
            " ! RC = "RetCode;
        Exit(77);
    End
End
else
  Call Directory SaveDir;

If FtpSetUser( RemHost, RemHostUID, password ) <> 1 Then
  Do
    RetCode = 66;
    Call Terminate " *** ERROR: Connection failed to host: "RemHost";"
end

If OpSys <> "OS/2" then
  RetCode =  FtpSetActiveMode("1");

If FtpChDir(RemHostDir) <> 0 Then
  Do
    RetCode = 55;
    Call Terminate " *** ERROR: Could not change to the directory: "RemHostDir";"
End

/* Save the list of files from the directory for backup ----------------------*/
say " Saving the list of files to "SubDirBack||DirChar||"Dir4Back.sav";
RetCode = SysFileDelete( SubDirBack||DirChar||"Dir4Back.sav");

Do While (lines(SubDirBack||DirChar||"Dir4Back.lst") = 1)
    filedat = linein(SubDirBack||DirChar||"Dir4Back.lst");
    RetCode = lineout( SubDirBack||DirChar||"Dir4Back.sav", filedat);
End

RetCode = lineout( SubDirBack||DirChar||"Dir4Back.lst");  /* Close the file   */
RetCode = SysFileDelete( SubDirBack||DirChar||"Dir4Back.lst");
RetCode = lineout( SubDirBack||DirChar||"Dir4Back.sav");  /* Close the file   */

/* Perform the transfer of new or updataed files -----------------------------*/
RetCodeLog = 0;

If FtpDir( "*", "RemoteDir.") = 0 Then
  Do i = 2 To RemoteDir.0
--  Say RemoteDir.i
    RetCode = lineout( SubDirBack||DirChar||"Dir4Back.lst",  RemoteDir.i );
  End
Else
  Do
    RetCode = 55;
    Call Terminate " *** ERROR:  Could not get directory listing of "RemHostDir";"
End

RetCode = lineout( SubDirBack||DirChar||"Dir4Back.lst" );   /* Close the file */

/* Loop to transfer all new or updated files from host -----------------------*/
Do While (lines(SubDirBack||DirChar||"Dir4Back.lst") = 1)
    filedat = linein(SubDirBack||DirChar||"Dir4Back.lst");
    parse var filedat fname . . fchgdat fchgtime fsize .

    CmpRC =  CmpFileDate(fname, fchgdat, fchgtime);  /* Compare date and time */

    If CmpRC = 1 Then
      Do
        say " Getting file: "fname" with size of "fsize;

        RetCode = FtpGet(SubDirBack||DirChar||fname, fname, "Binary");

        If RetCode <> 0 then
          Do
             say " *** ERROR: Could not get file: "fname;
             say "    FtpGET: "ftperrno RetCode
             RetCodeLog = lineout( SubDirBack||DirChar||"Dir4Back.log", Date(),
                       " "Time()" FtpGet RC = "RetCode" of file named: "fname);
             SeeLogFile = SeeLogFile + 1;
        End
        Else
         Do
             TransCntl = TransCntl + 1;
             say " File number "TransCntl" transferred  from host: "RemHost;
        End
    End
End
RetCodeLog = lineout( SubDirBack||DirChar||"Dir4Back.log"); /* Close the file */

If RetCodeLog <> 0 then
  say " *** ERROR: No log file: "SubDirBack||DirChar||"Dir4Back.log"

If SeeLogFile <> 0 then
  say " *** See error log file: "SubDirBack||DirChar||"Dir4Back.log for ",
        SeeLogFile" error(s)."

If ( TransCntl > 0 ) Then
    Say " >"TransCntl"< file(s) transferred  from remote host: "RemHost;
  Else
    Say " NO File transferred  from remote host: "RemHost;

Call Terminate " The REXX FTP API ends with last RC = "RetCode;

Exit RetCode;  /* END of the REXX main procedure ----------------------*/
/*=====================================================================*/
/* Procedure to compare date and time of a file -----------------------*/
CmpFileDate:
 Procedure expose SubDirBack DirChar;
 Parse Arg CmpFName, CmpFDate, CmpFTime;

 CmpRC = 1;

 Do While (lines(SubDirBack||DirChar||"Dir4Back.sav") = 1)
     sfiledat = linein(SubDirBack||DirChar||"Dir4Back.sav");
     parse var sfiledat sfname . . sfchgdat sfchgtime sfsize .
     If sfname = CmpFName Then
       Do
        fDatTime = CmpFDate||CmpFTime;
        fBACKDatTime = sfchgdat||sfchgtime;
        If ( fBACKDatTime >>= fDatTime ) then
          Do
            CmpRC = 0;
            leave;                          /* End of while loop       */
        End
     End
 End
 RetCode = lineout(SubDirBack||DirChar||"Dir4Back.sav"); /* Close file */

 return CmpRC;

/* Terminate the REXX FTP API -----------------------------------------*/
Terminate:
  Parse Arg Message

  Say Message
  If RetCode <> 0 Then
    Say "       *** Program is terminating.";
  Call FtpLogoff
  Call FtpDropFuncs
  Call EndLocal
  Exit RetCode

