/*___________________________________________________________________*/
/*       !!!      There is 1 global variable named         !!!       */
/*       !!!      "rpcSock" that MUST NOT BE ALTERED       !!!       */
/**/

/*_____________________________________________________________________
 * You HAVE TO USE the following call to initialize the RPC environment
 * before you're going to call a remote function.
 */
rpcSock = initRPC('127.0.0.1', 5000);  /* initialize RPC connection  */

/*REXX STRSRV-------------------------------------------------------------------*/

call reverseString testString                   /* test with call statement.    */
say result

result = reverseString(result);                 /* test with function call.     */
say result

result = multiplyString_1(2, result)            /* test with    ',' in parmlist.*/
say result

result = multiplyString_2(2  result)            /* test without ',' in parmlist.*/
say result

say'press enter to close connection...'         /* wait for user to press enter.*/
pull .

exit 0


/*______________________________________________________________________
 * You SHOULD USE the following call to nicely de-initialize the RPC
 * environment before you're exiting your program.
 */
call deInitRPC;                       /* shutdown RPC connection.     */

exit 0;

/*=====================================================================*/
/*  REXX RPC Client-Stub                    (AIX, Linux, WIN32, OS/2)  */
/*                                                                     */
/*  prepareRemoteCall:                                                 */
/*  remoteCall: procedure expose rpcSock;                              */
/*  initRPC: procedure                                                 */
/*  deInitRPC: procedure expose rpcSock;                               */
/*  connectToRPCServer: procedure                                      */
/*  createRPCSocket: procedure                                         */
/*                                                                     */
/*=====================================================================*/
reverseString:
    cmd = 'reverseString';
    signal prepareRemoteCall;
multiplyString_1:
    cmd = 'multiplyString_1';
    signal prepareRemoteCall;
multiplyString_2:
    cmd = 'multiplyString_2';
    signal prepareRemoteCall;
prepareRemoteCall:
    parms = '';
    do i = 1 to arg()
        parms = parms "'"arg(i)"'";
        if i < arg() then parms = parms || ',';
    end;
    return remoteCall(cmd'('parms')');

/*_________________________________________________________remoteCall__
 *
 * !!! requires that '~~' does not appear in the function call !!!
 */
remoteCall: procedure expose rpcSock;
    parse arg callTxt;

    callTxt = callTxt||'~~';           /* send message to server stub*/
    rc = SockSend(rpcSock, callTxt);

    retVal = '';                       /* receive return value       */
    retTxt = '';
    do while pos('~~', retVal) = 0
        rc = SockRecv(rpcSock, 'retTxt', 1024);
        retVal = retVal || retTxt;
    end
    retVal = left(retVal, length(retVal) - 2);

    return retVal;

/*____________________________________________________________initRPC__
 * return codes:
 *  >0  : socket number
 *  -1  : error occured
 */
initRPC: procedure
    parse arg host, port;

    call RxFuncAdd 'SockLoadFuncs', 'rxsock', 'SockLoadFuncs';
    call SockLoadFuncs;

    if host = '' | symbol('host') \= 'VAR' then /* host name or dotted IP addr. */
        host = 127.0.0.1;
    if port = '' | symbol('port') \= 'VAR' then /* port number of RPC service.  */
        port = 5000;

    return connectToRPCServer(host, port);

/*__________________________________________________________deInitRPC__
 */
deInitRPC: procedure expose rpcSock;

    say 'shutting down socket:';
    if SockShutdown(rpcSock, 0) = 0 then
        ext = 'is down.';
    else
        ext = 'had problems -> RC = 'rc;
    say right(rpcSock, 5)': 'ext;
    return;

/*_________________________________________________connectToRPCServer__
 */
connectToRPCServer: procedure
    parse arg host, port;

    socket = createRPCSocket();        /* create socket for          */
                                       /* communication with server. */

    if socket > 0 then do
       address.family  = 'AF_INET';    /* build server address from  */
       address.addr    = host;         /* command line parameters.   */
       address.port    = port;

       say "...now trying to connect to server '"host"'";
       say "                         on port   '"port"'";
       rc = SockConnect(socket, address.);      /* Try to connect.   */
       if rc <> 0 then
           return -1;
    end

    return socket;

/*____________________________________________________createRPCSocket__
 */
createRPCSocket: procedure

   /* create a new socket for the TCP/IP protocol.
    */
    socket = SockSocket('AF_INET', 'SOCK_STREAM', 'IPPROTO_TCP');
    if rc < 0 then
        return -1;

   /* 'keep-alive' ensures that the connection won't get closed
    *          even if there has been no traffic for a longer time.
    */
    rc = SockSetSockOpt(socket, 'SOL_SOCKET', 'SO_KEEPALIVE', 1);
    if rc <> 0 then
        return -1;

   /* 'linger' mode makes sure that data that is still to be sent
    *          won't get lost when a closeSocket call occurs.
    *          -> it blocks the application at socket closing for
    *             the specified amount of seconds.
    */
    rc = SockSetSockOpt(socket, 'SOL_SOCKET', 'SO_LINGER', 1 0);
    if rc <> 0 then
        return -1;

   /* DISabled(0) 'non-blocking' mode makes I/O statements block
    *             the execution of the program until they've been
    *             satisfied, because I/O has been TCP/IP-acknowledged
    *             or an optionally specified timeout has been reached.
    *
    * ENabled(1) 'non-blocking' mode makes I/O statements return
    *             promptly a RC = -1 instead of blocking execution.
    */
    rc = SockIOCtl(socket, 'FIONBIO', 0);
    if rc <> 0 then
        return -1;

    return socket;
