/********************************************************/
/*                                                      */
/* MSERVER.CMD - IBM REXX Sample Program                */
/*                                                      */
/* Mirror server program. The program waits for a client*/
/* to connect, reads in the sent string and returns the */
/* mirrored (reversed) string to the client.            */
/*                                                      */
/* Parameters:                                          */
/*   None                                               */
/*                                                      */
/* ---------------------------------------------------- */
/* (C) Copyright IBM Corp. 1996 - All Rights Reserved.  */
/*                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed]  */
/* code is sample code created by IBM Corporation. This */
/* sample code is not part of any standard or IBM       */
/* product and is provided to you solely for the        */
/* purpose of assisting you in the development of your  */
/* applications.  The code is provided "AS IS", without */
/* warranty of any kind.  IBM shall not be liable for   */
/* any damages arising out of your use of the sample    */
/* code,  even if they have been advised of the         */
/* possibility of such damages.                         */
/*                                                      */
/********************************************************/

/* Load REXX Socket library if not already loaded       */
If RxFuncQuery("SockLoadFuncs") Then
 Do
   Call RxFuncAdd "SockLoadFuncs","RXSOCK","SockLoadFuncs"
   Call SockLoadFuncs
 End

/* create a TCP socket for client connection requests   */
Socket = SockSocket("AF_INET", "SOCK_STREAM", "0")

/* find out local IP address                            */
Host.!addr = SockGetHostId()

/* Bind socket to well known port 1996                  */
Host.!family = "AF_INET"
Host.!port = 1996
Call SockBind Socket, "Host.!"

/* create a connection queue for 1 client               */
Call SockListen Socket, 1

/* wait for a client to connect                         */
Say "Waiting for a client to connect..."
ClientSocket = SockAccept(Socket)
Say "Client has established connection."

/* we don't want any more clients, close request socket */
Call SockShutDown Socket, 2
Call SockClose Socket

/* read string from client, reverse it and send it back */
Call SockRecv ClientSocket, "InpString", 256
Say "String read from client: '" || InpString || "'"
OutString = Reverse(InpString)
Call SockSend ClientSocket, OutString

/* close client socket                                  */
Call SockShutDown ClientSocket, 2
Call SockClose ClientSocket
