#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name: genRTree.cmd                                                       */
/* Type: Object REXX Script                                                 */     
/*                                                                          */     
/* Requirement:  xFtp.cls                                                   */
/****************************************************************************/      

ftp = .xFtp~new                         -- create xftp object
ftp~debug = .true                       -- show debug messages
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- show remote system type
say 'local slash' ftp~lslash            -- local slash    
say 'local dir:' directory()
say 'remote dir:' ftp~pwd

say '-----cd(usr)---------------'
rc = ftp~cd('usr')                      -- change remote directory to "usr"
say 'remote dir:' ftp~pwd

say '-----dir()-----------------'
paths1 = ftp~dir('*')                   -- show what's in there
if paths1 \= -1 & paths1 \= 0 then  
do p over paths1; say p; end

say '-----genRDirTree ----------'
paths = .array~of('aaa/uuu/xxx/', 'aaa/uuu/yyy/', 'aaa/bbb/', 'aaa/bbb/vvv/', 'aaa/ccc/')
say ftp~genRDirTree(paths)              -- generate remote directory tree
say 'logoff:' ftp~logoff                -- logoff from server

exit 0 

::REQUIRES "xftp.cls" 