#! /usr/local/orexx/bin/rexx
/****************************************************************************/
/* Name:        getRList.cmd                                                */
/* Function:    Get a directory list of remote directory                    */
/* Type:        Object REXX Script                                          */     
/*                                                                          */     
/* Requirement: xFtp.cls and ftp framework ftp.frm                          */
/****************************************************************************/      

ftp = .xFtp~new                         -- create ftp object
ftp~debug = .true                       -- request debug messages 
                                        -- connect to server
if ftp~connect('host', 'userid', 'password') \= 0 then exit 
say ftp~sys(sys)                        -- determine ftp-server type
say 'with slash' ftp~rslash             -- remote slash    
say 'local dir:' directory()
say 'remote dir:' ftp~pwd               -- show current remote dir 
say
say '-----dir()-----------------'
say 'gets a list of entries of files and directories'      
say '---- begin of list --------'
list = ftp~dir()                        -- use base ftp method
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----dir(*r*)--------------'
say 'gets a list of entries of files and directories matching pattern'      
say '---- begin of list --------'
list = ftp~dir('*r*')                   -- use base ftp method
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----dir(usr)--------------'
say 'gets a list of entries of files and directories in "usr"'      
say '---- begin of list --------'
list = ftp~dir('usr')                   -- use base ftp method
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList()---------'
say 'gets a list of <t name> entries (with t: 0 - file, 1 - dir)'      
say '---- begin of list --------'
list = ftp~getRDirList()                 -- use xftp method on current dir
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(*p*)------'
say 'gets a list of <t name> entries (with t: 0 - file, 1 - dir) matching pattern'      
say '---- begin of list --------'
list = ftp~getRDirList('*p*')            -- use xftp method with pattern
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(,F)-------'
say 'gets a list of <name> entries with file names'      
say '---- begin of list --------'
list = ftp~getRDirList(,'F')             -- use xftp method on files only 
if list \= -1 & list \= 0 then
do p over list; say p; end 
say
say '-----getRDirList(m*,F)-----'
say 'gets a list of <name> entries with file names matching pattern'      
say '---- begin of list --------'
list = ftp~getRDirList('m*','F')         -- use xftp method with pattern on files only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(,D)-------'
say 'gets a list of <name> entries with directory names'      
say '---- begin of list --------'
list = ftp~getRDirList(,'D')             -- use xftp method on directories only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(u*,D)-----'
say 'gets a list of <name> entries with directory names matching pattern'      
say '---- begin of list --------'
list = ftp~getRDirList('u*','D')         -- use xftp method with pattern on dirs only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(usr)------'
say 'gets a list of <t name> entries (with t: 0 - file, 1 - dir)'      
say '---- begin of list --------'
list = ftp~getRDirList('usr')            -- use xftp method in dir 'usr'
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(usr,F)----'
say 'gets a list of <name> entries with file names in directory "usr"'      
say '---- begin of list --------'
list = ftp~getRDirList('usr','F')        -- use xftp method on files only in dir 'usr'
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say '-----getRDirList(usr,D)----'
say 'gets a list of <name> entries with directory names in directory "usr"'      
say '---- begin of list --------'
list = ftp~getRDirList('usr','D')        -- use xftp method on directories only
if list \= -1 & list \= 0 then  
do p over list; say p; end 
say
say 'logoff:' ftp~logoff                -- logoff from server
exit 0 

::REQUIRES "xftp.cls" 