/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

class hlcpEditorPane
extends JEditorPane
implements Scrollable,
Printable,
Pageable,
Serializable {
    int lineheight;
    int lineascent;
    int linesPerPage;
    View nbv;
    Pager pg;
    PageFormat tbPageFormat = new PageFormat();
    hlcPrintStatus printProgress;
    String footerLeft = new String();
    String footerRight = new String();

    public hlcpEditorPane() {
        this.setEditable(false);
        this.setContentType("text/html");
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        this.setEditorKit(hTMLEditorKit);
        this.setDocument(hTMLDocument);
    }

    public void scrollTo(String string) {
        this.scrollToReference(string);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        super.scrollRectToVisible(rectangle);
    }

    public void turnOnDoubleBuffering() {
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(true);
    }

    public Printable getPrintable(int n) {
        return this;
    }

    public PageFormat getPageFormat(int n) {
        return this.tbPageFormat;
    }

    public int getNumberOfPages() {
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = dimension.height;
        double d3 = this.tbPageFormat.getImageableHeight();
        double d4 = this.tbPageFormat.getImageableWidth();
        double d5 = d4 / d;
        int n = (int)(d4 / d5);
        int n2 = (int)(d3 / d5);
        int n3 = n2 - (int)(0.06 * (double)n2);
        if (this.nbv == null) {
            View view;
            this.nbv = view = this.getUI().getRootView(this);
            this.pg = new Pager(this.nbv, n, n3);
            this.pg.paginate();
        }
        return this.pg.pageCount();
    }

    public void openPrintStatus(hlcPrintStatus hlcPrintStatus2) {
        this.printProgress = hlcPrintStatus2;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.printProgress.updateStatus(n + 1);
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        Dimension dimension = this.getSize();
        double d = dimension.width;
        double d2 = dimension.height;
        double d3 = pageFormat.getImageableHeight();
        double d4 = pageFormat.getImageableWidth();
        double d5 = d4 / d;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n2 = (int)(d4 / d5);
        int n3 = (int)(d3 / d5);
        int n4 = n3 - (int)(0.06 * (double)n3);
        graphics2D.scale(d5, d5);
        if (this.nbv == null) {
            object = this.getUI().getRootView(this);
            this.nbv = object;
            this.pg = new Pager(this.nbv, n2, n4);
            this.pg.paginate();
        }
        object = new Rectangle(0, 0, n2, n3);
        graphics2D.setClip((Shape)object);
        graphics2D.translate(0, -this.pg.getPageStart(n));
        this.paint(graphics2D);
        graphics2D.setColor(Color.white);
        graphics2D.drawRect(0, this.pg.getPageStart(n) + this.pg.getPageHeight(n) + 1, n2, n3 - this.pg.getPageHeight(n));
        graphics2D.fillRect(0, this.pg.getPageStart(n) + this.pg.getPageHeight(n) + 1, n2, n3 - this.pg.getPageHeight(n));
        Font font = new Font("SansSerif", 0, 10);
        graphics2D.setFont(font);
        int n5 = graphics2D.getFontMetrics().getMaxDescent();
        int n6 = graphics2D.getFontMetrics().getMaxAscent() + n5;
        graphics2D.setColor(Color.black);
        String string = new String("Page " + (n + 1));
        int n7 = graphics2D.getFontMetrics().stringWidth(string);
        int n8 = graphics2D.getFontMetrics().stringWidth(this.footerLeft);
        int n9 = graphics2D.getFontMetrics().stringWidth(this.footerRight);
        graphics2D.drawString(string, (int)((double)n2 / 2.0 - (double)n7 / 2.0), this.pg.getPageStart(n) + n3 - n5 - 1);
        graphics2D.drawString(this.footerLeft, 0, this.pg.getPageStart(n) + n3 - n5 - 1);
        graphics2D.drawString(this.footerRight, n2 - n9 - 1, this.pg.getPageStart(n) + n3 - n5 - 1);
        if (this.pg.exists(n)) {
            return 0;
        }
        this.nbv = null;
        this.printProgress.dispose();
        return 1;
    }

    public void setFooters(String string, String string2) {
        this.footerLeft = string;
        this.footerRight = string2;
    }

    class Pager {
        Vector pageBreaks;
        Rectangle pagerRect;
        View rootView;

        public Pager(View view, int n, int n2) {
            this.rootView = view;
            this.pageBreaks = new Vector();
            this.pagerRect = new Rectangle(0, 0, n, n2);
        }

        private boolean recurseView(View view, Rectangle rectangle, Rectangle rectangle2) {
            Rectangle rectangle3 = new Rectangle(rectangle);
            boolean bl = false;
            int n = 0;
            while (n < view.getViewCount()) {
                Rectangle rectangle4 = (Rectangle)view.getChildAllocation(n, rectangle3);
                if (rectangle4.y >= rectangle2.y && rectangle4.y + rectangle4.height < rectangle2.y + rectangle2.height) {
                    if (rectangle4.width != 0 && rectangle4.height != 0) {
                        bl = true;
                    }
                } else if (rectangle4.y >= rectangle2.y && rectangle4.y < rectangle2.y + rectangle2.height) {
                    int n2 = view.getView(n).getViewCount();
                    if (n2 > 0) {
                        bl |= this.recurseView(view.getView(n), rectangle4, rectangle2);
                    } else {
                        rectangle2.height = rectangle4.y - rectangle2.y + 1;
                    }
                } else {
                    bl |= this.recurseView(view.getView(n), rectangle4, rectangle2);
                }
                ++n;
            }
            return bl;
        }

        public void paginate() {
            Rectangle rectangle = new Rectangle(this.pagerRect);
            while (this.recurseView(this.rootView, this.pagerRect, rectangle)) {
                int n = rectangle.y + rectangle.height;
                this.pageBreaks.addElement(new Integer(n));
                rectangle.setBounds(this.pagerRect);
                rectangle.y = n;
            }
        }

        public int getPageStart(int n) {
            if (n == 0) {
                return 0;
            }
            if (n < this.pageBreaks.size()) {
                return (Integer)this.pageBreaks.elementAt(n - 1) + 1;
            }
            return -1;
        }

        public int getPageHeight(int n) {
            if (n < this.pageBreaks.size()) {
                if (n == 0) {
                    return (Integer)this.pageBreaks.elementAt(n);
                }
                return (Integer)this.pageBreaks.elementAt(n) - (Integer)this.pageBreaks.elementAt(n - 1);
            }
            return -1;
        }

        public int pageCount() {
            return this.pageBreaks.size() + 1;
        }

        public boolean exists(int n) {
            return n < this.pageBreaks.size();
        }
    }
}

