/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class hlctopicHistory
extends JDialog {
    private Vector historyList;
    private hlcHelperList historyBox;
    private JScrollPane sp;
    private Vector history = new Vector();
    public static final String SELECTED_PROPERTY = "SELECTED_PROPERTY";

    public hlctopicHistory(JFrame f, hlcjbook J, Vector hist) {
        super(f);
        int j;
        this.setTitle("Topics Seen");
        this.setSize(400, 450);
        for (j = hist.size() - 1; j >= 0; --j) {
            this.history.addElement(hist.elementAt(j));
        }
        this.historyList = new Vector();
        for (j = 0; j < this.history.size(); ++j) {
            this.historyList.addElement(J.getTopicTitleText((Integer)this.history.elementAt(j)));
        }
        this.historyBox = new hlcHelperList();
        this.historyBox.setListData(this.historyList);
        this.sp = new JScrollPane(this.historyBox);
        this.getContentPane().add(this.sp);
        Rectangle r = f.getBounds();
        int w = f.getSize().width;
        int h = f.getSize().height;
        int xFrame = (int)r.getX();
        int yFrame = (int)r.getY();
        this.setLocation(xFrame + 10, yFrame + h - this.getHeight() - 10);
        this.setVisible(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    hlctopicHistory.this.setVisible(false);
                    hlctopicHistory.this.dispose();
                }
            }
        });
        this.historyBox.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    hlctopicHistory.this.setCursor(new Cursor(3));
                    int selectedTopic = hlctopicHistory.this.historyBox.getSelectedIndex();
                    if (selectedTopic >= 0) {
                        hlctopicHistory.this.historyBox.firePropertyChangeEvent(hlctopicHistory.SELECTED_PROPERTY, "", hlctopicHistory.this.history.elementAt(selectedTopic));
                    }
                    hlctopicHistory.this.setCursor(new Cursor(0));
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.historyBox.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.historyBox.removePropertyChangeListener(l);
    }

    public void addTopic(Object topic, int selectedTopic) {
        this.historyList.insertElementAt(topic, 0);
        this.history.insertElementAt(this.history.elementAt(selectedTopic), 0);
        this.historyBox.setListData(this.historyList);
        if (selectedTopic > -1) {
            this.historyBox.setSelectedIndex(selectedTopic + 1);
        }
    }
}

