/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bpe.staff;

import com.ibm.bpe.api.ProcessException;
import com.ibm.bpe.api.StaffQueryResult;
import com.ibm.bpe.plugins.DataAnotherElementExpectedException;
import com.ibm.bpe.plugins.DataAttributeMissingException;
import com.ibm.bpe.plugins.DeployedStaffQuery;
import com.ibm.bpe.plugins.DeploymentDescriptor;
import com.ibm.bpe.plugins.DeploymentElementNotFoundException;
import com.ibm.bpe.plugins.ProcessDeploymentException;
import com.ibm.bpe.plugins.StaffPluginCannotAccessWMMEJBException;
import com.ibm.bpe.plugins.StaffPluginDeploymentException;
import com.ibm.bpe.plugins.StaffPluginDuplicateReturnTypeException;
import com.ibm.bpe.plugins.StaffPluginDuplicateSearchAttributeException;
import com.ibm.bpe.plugins.StaffPluginEmptyAttributeValueException;
import com.ibm.bpe.plugins.StaffPluginGroupWINotEnabledException;
import com.ibm.bpe.plugins.StaffPluginInvalidAttributeValueException;
import com.ibm.bpe.plugins.StaffPluginInvalidIntermediateResultContentException;
import com.ibm.bpe.plugins.StaffPluginMultiValueNotSupportedException;
import com.ibm.bpe.plugins.StaffPluginNoConfigurationParametersException;
import com.ibm.bpe.plugins.StaffPluginNoFurtherStaffQueryAllowedException;
import com.ibm.bpe.plugins.StaffPluginNoInitialContextException;
import com.ibm.bpe.plugins.StaffPluginNotAvailableException;
import com.ibm.bpe.plugins.StaffPluginRuntimeException;
import com.ibm.bpe.plugins.StaffPluginWrongNameSpaceURIException;
import com.ibm.bpe.plugins.StaffResolutionPlugin;
import com.ibm.bpe.staff.DeployedWMMStaffQuery;
import com.ibm.bpe.staff.StaffPluginUtil;
import com.ibm.bpe.staff.StaffQueryResultImpl;
import com.ibm.bpe.util.MessageLogger;
import com.ibm.bpe.util.TraceEventType;
import com.ibm.bpe.util.TraceLogger;
import com.ibm.task.core.UserDataImpl;
import com.ibm.task.util.TraceLog;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl;
import com.ibm.websphere.wmm.MemberService;
import com.ibm.websphere.wmm.adapter.datatype.ExternalMemberIdentifier;
import com.ibm.websphere.wmm.datatype.Attribute;
import com.ibm.websphere.wmm.datatype.AttributeFactory;
import com.ibm.websphere.wmm.datatype.AttributeSearchConditions;
import com.ibm.websphere.wmm.datatype.AttributeSearchConditionsFactory;
import com.ibm.websphere.wmm.datatype.GroupScope;
import com.ibm.websphere.wmm.datatype.GroupScopeFactory;
import com.ibm.websphere.wmm.datatype.Member;
import com.ibm.websphere.wmm.datatype.MemberIdentifier;
import com.ibm.websphere.wmm.datatype.MemberIdentifierFactory;
import com.ibm.websphere.wmm.datatype.MemberSet;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMap;
import com.ibm.websphere.wmm.datatype.MemberTypeAttributeMapFactory;
import com.ibm.websphere.wmm.datatype.SearchConditionFactory;
import com.ibm.websphere.wmm.datatype.SearchCriteria;
import com.ibm.websphere.wmm.datatype.SearchCriteriaFactory;
import com.ibm.websphere.wmm.datatype.StringSet;
import com.ibm.websphere.wmm.datatype.StringSetFactory;
import com.ibm.websphere.wmm.exception.MemberNotFoundException;
import com.ibm.websphere.wmm.exception.WMMApplicationException;
import com.ibm.websphere.wmm.exception.WMMException;
import com.ibm.websphere.wmm.objects.MemberServiceHome;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.util.AuthData;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MemberManagerStaffResolutionPlugin
implements StaffResolutionPlugin {
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
    private static final StaffPluginUtil.QueryMap[] ALLOWED_QUERY_TYPES = new StaffPluginUtil.QueryMap[]{new StaffPluginUtil.QueryMap("advancedSearch", 10002), new StaffPluginUtil.QueryMap("everybody", 1), new StaffPluginUtil.QueryMap("membersOfGroup", 10003), new StaffPluginUtil.QueryMap("nobody", 0), new StaffPluginUtil.QueryMap("search", 4), new StaffPluginUtil.QueryMap("user", 5), new StaffPluginUtil.QueryMap("userID", 2), new StaffPluginUtil.QueryMap("usersOfGroup", 6), new StaffPluginUtil.QueryMap("groupID", 8)};
    private static final StaffPluginUtil.QueryMap[] ALLOWED_QUERY_TYPES_WITH_INTERMEDIATE_RESULT = new StaffPluginUtil.QueryMap[]{new StaffPluginUtil.QueryMap("advancedSearch", 10002), new StaffPluginUtil.QueryMap("everybody", 1), new StaffPluginUtil.QueryMap("intermediateResult", 10001), new StaffPluginUtil.QueryMap("membersOfGroup", 10003), new StaffPluginUtil.QueryMap("nobody", 0), new StaffPluginUtil.QueryMap("search", 4), new StaffPluginUtil.QueryMap("user", 5), new StaffPluginUtil.QueryMap("userID", 2), new StaffPluginUtil.QueryMap("usersOfGroup", 6), new StaffPluginUtil.QueryMap("remove", 7), new StaffPluginUtil.QueryMap("groupID", 8)};
    private static final String STAFF_NAMESPACE = "http://www.ibm.com/schemas/workflow/wswf/plugins/staff/membermanager";
    private String _authenticationAlias;
    private String _contextFactory;
    private InitialContext _context = null;
    private ConfigurationParameters _currentConfig;
    private String _providerURL;
    private String _timeout;
    private MemberService _wmm = null;
    private String _wmmEJBHomeName;

    private String convertResultToString(Object object) {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object)object);
        }
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Timestamp) {
            string = ((Timestamp)object).toString();
        } else if (object instanceof Long) {
            string = ((Long)object).toString();
        } else if (object instanceof Integer) {
            string = ((Integer)object).toString();
        } else if (object instanceof Double) {
            string = ((Double)object).toString();
        } else if (object instanceof MemberIdentifier) {
            string = ((MemberIdentifier)object).getMemberDN();
        } else if (object instanceof ExternalMemberIdentifier) {
            string = ((ExternalMemberIdentifier)object).getMemberDN();
        } else {
            string = object.toString();
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Unknown attribute result class:" + object.getClass().getName() + ", using its toString() method which returns:" + object.toString()));
            }
            StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.UnknownResultType", new Object[]{object.getClass().getName()});
        }
        if (TraceLog.isTracing) {
            TraceLog.exit((Object)string);
        }
        return string;
    }

    private DeployedWMMStaffQuery.WMMQuery deployAdvancedSearch(Element element, List list, boolean bl, String string, String string2) throws ProcessDeploymentException {
        String string3 = "accountName";
        if (element.hasAttribute("returnAttribute")) {
            string3 = element.getAttribute("returnAttribute");
        }
        String string4 = "person";
        if (element.hasAttribute("returnType")) {
            string4 = element.getAttribute("returnType");
        }
        DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType(string3, string4);
        ArrayList<DeployedWMMStaffQuery.ReturnType> arrayList = new ArrayList<DeployedWMMStaffQuery.ReturnType>(1);
        arrayList.add(returnType);
        String string5 = null;
        if (element.hasAttribute("timeout")) {
            string5 = element.getAttribute("timeout");
        }
        ArrayList<DeployedWMMStaffQuery.SearchAttribute> arrayList2 = new ArrayList<DeployedWMMStaffQuery.SearchAttribute>();
        NodeList nodeList = element.getElementsByTagNameNS("*", "searchAttribute");
        int n = nodeList.getLength();
        if (n < 1) {
            throw new DeploymentElementNotFoundException(new Object[]{"searchAttribute"});
        }
        for (int i = 0; i < n; ++i) {
            Element element2;
            DeployedWMMStaffQuery.SearchAttribute searchAttribute;
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Deploying WMM searchAttribute no. " + i));
            }
            if ((searchAttribute = this.deploySearchAttribute(element2 = (Element)nodeList.item(i), list)).isRegistered(arrayList2)) {
                throw new StaffPluginDuplicateSearchAttributeException(new Object[]{searchAttribute.getName()});
            }
            arrayList2.add(searchAttribute);
        }
        return new DeployedWMMStaffQuery.SearchQuery(arrayList2, string5, bl, string, string2, arrayList, null);
    }

    private void deployComplexCondition(Element element, List list, List list2) throws ProcessDeploymentException {
        Short s;
        if (!element.getNamespaceURI().equals(STAFF_NAMESPACE)) {
            throw new StaffPluginWrongNameSpaceURIException(new Object[]{"complexCondition", element.getNamespaceURI(), STAFF_NAMESPACE});
        }
        if (!element.hasAttribute("operator")) {
            throw new DataAttributeMissingException(new Object[]{"operator", "complexCondition"});
        }
        String string = element.getAttribute("operator");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node;
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Deploying complex condition no. " + i));
            }
            if ((node = nodeList.item(i)).getNodeType() != 1) continue;
            ++n2;
            Element element2 = (Element)node;
            if (element2.getLocalName().equals("complexCondition")) {
                this.deployComplexCondition(element2, list, list2);
                continue;
            }
            if (element2.getLocalName().equals("complexCondition")) {
                DeployedWMMStaffQuery.Condition condition = this.deploySimpleCondition(element2, list);
                list2.add(condition);
                continue;
            }
            throw new DataAnotherElementExpectedException(new Object[]{"complexCondition || simpleCondition", element2.getLocalName()});
        }
        if (n2 < 2) {
            throw new DeploymentElementNotFoundException(new Object[]{"2 * (complexCondition || simpleCondition)"});
        }
        if (string.equals("and")) {
            s = AttributeSearchConditions.OPERATOR_AND;
        } else if (string.equals("or")) {
            s = AttributeSearchConditions.OPERATOR_OR;
        } else {
            throw new StaffPluginInvalidAttributeValueException(new Object[]{"operator", "'and', 'or'"});
        }
        list2.add(s);
    }

    private DeployedWMMStaffQuery.WMMQuery deployMembersOfGroup(Element element, List list, boolean bl, String string, String string2) throws ProcessDeploymentException {
        if (!element.hasAttribute("id")) {
            throw new DataAttributeMissingException(new Object[]{"id", "usersOfGroup"});
        }
        String string3 = element.getAttribute("id");
        StaffPluginUtil.extractVariableNames((String)string3, (List)list);
        String string4 = "memberDN";
        if (element.hasAttribute("idType")) {
            string4 = element.getAttribute("idType");
        }
        String string5 = "yes";
        if (element.hasAttribute("recursive")) {
            string5 = element.getAttribute("recursive");
        }
        NodeList nodeList = element.getElementsByTagNameNS("*", "returnType");
        int n = nodeList.getLength();
        ArrayList<DeployedWMMStaffQuery.ReturnType> arrayList = null;
        if (n > 0) {
            arrayList = new ArrayList<DeployedWMMStaffQuery.ReturnType>(n);
            for (int i = 0; i < n; ++i) {
                Element element2;
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Deploying WMM returnType no. " + i));
                }
                if (!(element2 = (Element)nodeList.item(i)).getNamespaceURI().equals(STAFF_NAMESPACE)) {
                    throw new StaffPluginWrongNameSpaceURIException(new Object[]{"returnType", element2.getNamespaceURI(), STAFF_NAMESPACE});
                }
                if (!element2.hasAttribute("name")) {
                    throw new DataAttributeMissingException(new Object[]{"name", element2.getLocalName()});
                }
                String string6 = element2.getAttribute("name");
                if (string6.equals("groupRecursive")) {
                    throw new StaffPluginInvalidAttributeValueException(new Object[]{"name", "'group', 'organization', 'organizationalUnit', 'person'", string6});
                }
                if (!element2.hasAttribute("attribute")) {
                    throw new DataAttributeMissingException(new Object[]{"attribute", element2.getLocalName()});
                }
                String string7 = element2.getAttribute("attribute");
                DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType(string6, string7);
                if (returnType.isRegistered(arrayList)) {
                    throw new StaffPluginDuplicateReturnTypeException(new Object[]{string6, string7});
                }
                arrayList.add(returnType);
            }
        } else {
            arrayList = new ArrayList(1);
            DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType("accountName", "person");
            arrayList.add(returnType);
        }
        return new DeployedWMMStaffQuery.UsersOfGroupQuery(string3, string4, string5, bl, string, string2, arrayList);
    }

    private DeployedWMMStaffQuery.WMMQuery deploySearch(Element element, List list, boolean bl, String string, String string2) throws ProcessDeploymentException {
        if (!element.hasAttribute("searchAttribute")) {
            throw new DataAttributeMissingException(new Object[]{"searchAttribute", "search"});
        }
        String string3 = element.getAttribute("searchAttribute");
        if (!element.hasAttribute("operator")) {
            throw new DataAttributeMissingException(new Object[]{"operator", "search"});
        }
        String string4 = element.getAttribute("operator");
        if (!element.hasAttribute("referenceValue")) {
            throw new DataAttributeMissingException(new Object[]{"referenceValue", "search"});
        }
        String string5 = element.getAttribute("referenceValue");
        StaffPluginUtil.extractVariableNames((String)string5, (List)list);
        if (!element.hasAttribute("referenceType")) {
            throw new DataAttributeMissingException(new Object[]{"referenceType", "search"});
        }
        String string6 = element.getAttribute("referenceType");
        String string7 = "accountName";
        if (element.hasAttribute("returnAttribute")) {
            string7 = element.getAttribute("returnAttribute");
        }
        String string8 = "person";
        if (element.hasAttribute("returnType")) {
            string8 = element.getAttribute("returnType");
        }
        String string9 = null;
        if (element.hasAttribute("searchBase")) {
            string9 = element.getAttribute("searchBase");
        }
        DeployedWMMStaffQuery.Condition condition = new DeployedWMMStaffQuery.Condition(string4, string5, string6, "search");
        ArrayList<DeployedWMMStaffQuery.Condition> arrayList = new ArrayList<DeployedWMMStaffQuery.Condition>(1);
        arrayList.add(condition);
        DeployedWMMStaffQuery.SearchAttribute searchAttribute = new DeployedWMMStaffQuery.SearchAttribute(string3, arrayList);
        ArrayList<DeployedWMMStaffQuery.SearchAttribute> arrayList2 = new ArrayList<DeployedWMMStaffQuery.SearchAttribute>(1);
        arrayList2.add(searchAttribute);
        DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType(string7, string8);
        ArrayList<DeployedWMMStaffQuery.ReturnType> arrayList3 = new ArrayList<DeployedWMMStaffQuery.ReturnType>(1);
        arrayList3.add(returnType);
        return new DeployedWMMStaffQuery.SearchQuery(arrayList2, null, bl, string, string2, arrayList3, string9);
    }

    private DeployedWMMStaffQuery.SearchAttribute deploySearchAttribute(Element element, List list) throws ProcessDeploymentException {
        if (!element.getNamespaceURI().equals(STAFF_NAMESPACE)) {
            throw new StaffPluginWrongNameSpaceURIException(new Object[]{"searchAttribute", element.getNamespaceURI(), STAFF_NAMESPACE});
        }
        if (!element.hasAttribute("name")) {
            throw new DataAttributeMissingException(new Object[]{"name", element.getLocalName()});
        }
        String string = element.getAttribute("name");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<DeployedWMMStaffQuery.Condition> arrayList = new ArrayList<DeployedWMMStaffQuery.Condition>();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Node node;
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Deploying WMM SearchAttribute condition no. " + i));
            }
            if ((node = nodeList.item(i)).getNodeType() != 1) continue;
            bl = true;
            Element element2 = (Element)node;
            if (!element2.getNamespaceURI().equals(STAFF_NAMESPACE)) {
                throw new StaffPluginWrongNameSpaceURIException(new Object[]{element2.getLocalName(), element2.getNamespaceURI(), STAFF_NAMESPACE});
            }
            if (element2.getLocalName().equals("complexCondition")) {
                this.deployComplexCondition(element2, list, arrayList);
                continue;
            }
            if (element2.getLocalName().equals("complexCondition")) {
                DeployedWMMStaffQuery.Condition condition = this.deploySimpleCondition(element2, list);
                arrayList.add(condition);
                continue;
            }
            throw new DataAnotherElementExpectedException(new Object[]{"complexCondition || simpleCondition", element2.getLocalName()});
        }
        if (!bl) {
            throw new DeploymentElementNotFoundException(new Object[]{"complexCondition || simpleCondition"});
        }
        return new DeployedWMMStaffQuery.SearchAttribute(string, arrayList);
    }

    private DeployedWMMStaffQuery.Condition deploySimpleCondition(Element element, List list) throws ProcessDeploymentException {
        if (!element.getNamespaceURI().equals(STAFF_NAMESPACE)) {
            throw new StaffPluginWrongNameSpaceURIException(new Object[]{"simpleCondition", element.getNamespaceURI(), STAFF_NAMESPACE});
        }
        if (!element.hasAttribute("operator")) {
            throw new DataAttributeMissingException(new Object[]{"operator", "simpleCondition"});
        }
        String string = element.getAttribute("operator");
        if (!element.hasAttribute("referenceValue")) {
            throw new DataAttributeMissingException(new Object[]{"referenceValue", "simpleCondition"});
        }
        String string2 = element.getAttribute("referenceValue");
        StaffPluginUtil.extractVariableNames((String)string2, (List)list);
        if (!element.hasAttribute("referenceType")) {
            throw new DataAttributeMissingException(new Object[]{"referenceType", "simpleCondition"});
        }
        String string3 = element.getAttribute("referenceType");
        return new DeployedWMMStaffQuery.Condition(string, string2, string3, "simpleCondition");
    }

    public DeployedStaffQuery deployStaffQuery(DeploymentDescriptor deploymentDescriptor, Node node) throws ProcessDeploymentException {
        DeployedWMMStaffQuery deployedWMMStaffQuery;
        Object object;
        NodeList nodeList;
        int n;
        if (TraceLog.isTracing) {
            TraceLog.entry((Object)deploymentDescriptor, (Object)node);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Element element = (Element)node;
        element.normalize();
        if (!element.getLocalName().equals("staffQueries")) {
            throw new DataAnotherElementExpectedException(new Object[]{"staffQueries", element.getLocalName()});
        }
        if (!element.getNamespaceURI().equals(STAFF_NAMESPACE)) {
            throw new StaffPluginWrongNameSpaceURIException(new Object[]{"staffQueries", element.getNamespaceURI(), STAFF_NAMESPACE});
        }
        String string = null;
        if (element.hasAttribute("threshold")) {
            string = element.getAttribute("threshold");
        }
        if ((n = (nodeList = element.getChildNodes()).getLength()) < 1) {
            StaffPluginUtil.throwInvalidQueryTypeException((StaffPluginUtil.QueryMap[])ALLOWED_QUERY_TYPES_WITH_INTERMEDIATE_RESULT, (boolean)true, (String)"");
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            Object object2;
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Deploying node no. " + i));
            }
            object = null;
            StaffPluginUtil.StaffQueryElement staffQueryElement = StaffPluginUtil.processStaffQuery((Node)nodeList.item(i), (String)STAFF_NAMESPACE, (StaffPluginUtil.QueryMap[])ALLOWED_QUERY_TYPES_WITH_INTERMEDIATE_RESULT);
            if (staffQueryElement == null) continue;
            int n2 = staffQueryElement.getQueryType();
            Element element2 = staffQueryElement.getQueryElement();
            boolean bl4 = false;
            String string2 = null;
            if (n2 == 10001) {
                bl4 = true;
                if (element2.hasAttribute("name")) {
                    string2 = element2.getAttribute("name");
                }
                if (element2.hasAttribute("threshold")) {
                    object = element2.getAttribute("threshold");
                }
                object2 = element2.getChildNodes();
                int n3 = object2.getLength();
                StaffPluginUtil.StaffQueryElement staffQueryElement2 = null;
                for (int j = 0; j < n3; ++j) {
                    StaffPluginUtil.StaffQueryElement staffQueryElement3 = StaffPluginUtil.processStaffQuery((Node)object2.item(j), (String)STAFF_NAMESPACE, (StaffPluginUtil.QueryMap[])ALLOWED_QUERY_TYPES);
                    if (staffQueryElement3 == null) continue;
                    if (staffQueryElement2 != null) {
                        StaffPluginUtil.throwInvalidQueryTypeException((StaffPluginUtil.QueryMap[])ALLOWED_QUERY_TYPES, (boolean)false, null);
                        continue;
                    }
                    staffQueryElement2 = staffQueryElement3;
                }
                if (staffQueryElement2 == null) {
                    StaffPluginUtil.throwInvalidQueryTypeException((StaffPluginUtil.QueryMap[])ALLOWED_QUERY_TYPES, (boolean)false, null);
                }
                n2 = staffQueryElement2.getQueryType();
                element2 = staffQueryElement2.getQueryElement();
                if (n2 == 1 || n2 == 0 || n2 == 2 || n2 == 8) {
                    throw new StaffPluginInvalidIntermediateResultContentException(null);
                }
            }
            if (bl2 || bl || bl3) {
                throw new StaffPluginNoFurtherStaffQueryAllowedException(null);
            }
            if (n2 == 1) {
                if (arrayList3.size() > 0) {
                    throw new StaffPluginNoFurtherStaffQueryAllowedException(null);
                }
                bl2 = true;
                continue;
            }
            if (n2 == 0) {
                if (arrayList3.size() > 0) {
                    throw new StaffPluginNoFurtherStaffQueryAllowedException(null);
                }
                bl = true;
                continue;
            }
            object2 = null;
            if (n2 == 10003) {
                object2 = this.deployMembersOfGroup(element2, arrayList, bl4, string2, (String)object);
            }
            if (n2 == 10002) {
                object2 = this.deployAdvancedSearch(element2, arrayList, bl4, string2, (String)object);
            }
            if (n2 == 4) {
                object2 = this.deploySearch(element2, arrayList, bl4, string2, (String)object);
            }
            if (n2 == 5) {
                object2 = this.deployUser(element2, arrayList, bl4, string2, (String)object);
            }
            if (n2 == 2) {
                if (!element2.hasAttribute("name")) {
                    throw new DataAttributeMissingException(new Object[]{"name", element2.getLocalName()});
                }
                String string3 = element2.getAttribute("name");
                if (string3.length() == 0) {
                    throw new StaffPluginEmptyAttributeValueException(new Object[]{"name", element2.getLocalName()});
                }
                StaffPluginUtil.extractVariableNames((String)string3, arrayList);
                object2 = new DeployedWMMStaffQuery.UserIDQuery(string3);
            }
            if (n2 == 6) {
                object2 = this.deployUsersOfGroup(element2, arrayList, bl4, string2, (String)object);
            }
            if (n2 == 7) {
                object2 = this.deployRemove(element2, arrayList, bl4, string2, (String)object);
            }
            if (n2 == 8) {
                if (arrayList3.size() > 0) {
                    throw new StaffPluginNoFurtherStaffQueryAllowedException(null);
                }
                bl3 = true;
                if (!deploymentDescriptor.isGroupWorkItemEnabled()) {
                    throw new StaffPluginGroupWINotEnabledException(null);
                }
                if (!element2.hasAttribute("name")) {
                    throw new DataAttributeMissingException(new Object[]{"name", element2.getLocalName()});
                }
                String string4 = element2.getAttribute("name");
                if (string4.length() == 0) {
                    throw new StaffPluginEmptyAttributeValueException(new Object[]{"name", element2.getLocalName()});
                }
                StaffPluginUtil.extractVariableNames((String)string4, arrayList);
                object2 = new DeployedWMMStaffQuery.GroupIDQuery(string4);
            }
            if (object2 == null) {
                throw new StaffPluginDeploymentException(new Object[]{"Internal error in staff plugin deployment."});
            }
            arrayList3.add(object2);
            if (bl4) {
                arrayList2.add(string2);
            }
            if (!TraceLog.isTracing) continue;
            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Deployed: " + object2));
        }
        if (arrayList3.isEmpty() && !bl && !bl2 && !bl3) {
            StaffPluginUtil.throwInvalidQueryTypeException((StaffPluginUtil.QueryMap[])ALLOWED_QUERY_TYPES, (boolean)true, (String)"");
        }
        if (bl) {
            deployedWMMStaffQuery = new DeployedWMMStaffQuery(0);
        } else if (bl2) {
            deployedWMMStaffQuery = new DeployedWMMStaffQuery(1);
        } else if (bl3) {
            object = (DeployedWMMStaffQuery.GroupIDQuery)arrayList3.get(0);
            deployedWMMStaffQuery = new DeployedWMMStaffQuery(arrayList, (DeployedWMMStaffQuery.GroupIDQuery)object);
        } else {
            arrayList.removeAll(arrayList2);
            deployedWMMStaffQuery = new DeployedWMMStaffQuery(arrayList, arrayList3, string);
        }
        if (TraceLog.isTracing) {
            TraceLog.exit((Object)deployedWMMStaffQuery);
        }
        return deployedWMMStaffQuery;
    }

    private DeployedWMMStaffQuery.WMMQuery deployUser(Element element, List list, boolean bl, String string, String string2) throws ProcessDeploymentException {
        if (!element.hasAttribute("id")) {
            throw new DataAttributeMissingException(new Object[]{"id", "user"});
        }
        String string3 = element.getAttribute("id");
        StaffPluginUtil.extractVariableNames((String)string3, (List)list);
        String string4 = "memberDN";
        if (element.hasAttribute("idType")) {
            string4 = element.getAttribute("idType");
        }
        String string5 = null;
        if (element.hasAttribute("realm")) {
            string5 = element.getAttribute("realm");
        }
        String string6 = "accountName";
        if (element.hasAttribute("attribute")) {
            string6 = element.getAttribute("attribute");
        }
        DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType(string6, "person");
        ArrayList<DeployedWMMStaffQuery.ReturnType> arrayList = new ArrayList<DeployedWMMStaffQuery.ReturnType>(1);
        arrayList.add(returnType);
        return new DeployedWMMStaffQuery.UserQuery(string3, string4, string5, bl, string, string2, arrayList);
    }

    private DeployedWMMStaffQuery.WMMQuery deployUsersOfGroup(Element element, List list, boolean bl, String string, String string2) throws ProcessDeploymentException {
        if (!element.hasAttribute("id")) {
            throw new DataAttributeMissingException(new Object[]{"id", "usersOfGroup"});
        }
        String string3 = element.getAttribute("id");
        StaffPluginUtil.extractVariableNames((String)string3, (List)list);
        String string4 = "memberDN";
        if (element.hasAttribute("idType")) {
            string4 = element.getAttribute("idType");
        }
        String string5 = "yes";
        if (element.hasAttribute("recursive")) {
            string5 = element.getAttribute("recursive");
        }
        String string6 = "accountName";
        if (element.hasAttribute("attribute")) {
            string6 = element.getAttribute("attribute");
        }
        DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType(string6, "person");
        ArrayList<DeployedWMMStaffQuery.ReturnType> arrayList = new ArrayList<DeployedWMMStaffQuery.ReturnType>(1);
        arrayList.add(returnType);
        return new DeployedWMMStaffQuery.UsersOfGroupQuery(string3, string4, string5, bl, string, string2, arrayList);
    }

    private DeployedWMMStaffQuery.WMMQuery deployRemove(Element element, List list, boolean bl, String string, String string2) throws ProcessDeploymentException {
        if (!element.hasAttribute("value")) {
            throw new DataAttributeMissingException(new Object[]{"value", "remove"});
        }
        String string3 = element.getAttribute("value");
        StaffPluginUtil.extractVariableNames((String)string3, (List)list);
        DeployedWMMStaffQuery.ReturnType returnType = new DeployedWMMStaffQuery.ReturnType("value", "person");
        ArrayList<DeployedWMMStaffQuery.ReturnType> arrayList = new ArrayList<DeployedWMMStaffQuery.ReturnType>(1);
        arrayList.add(returnType);
        return new DeployedWMMStaffQuery.RemoveQuery(string3, bl, string, string2, arrayList);
    }

    private synchronized MemberSet getGroupMembers(final MemberIdentifier memberIdentifier, final GroupScope groupScope, final MemberTypeAttributeMap memberTypeAttributeMap, final MemberService memberService) throws RemoteException, WMMException, PrivilegedActionException {
        try {
            return (MemberSet)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, WMMException, PrivilegedActionException {
                    try {
                        return (MemberSet)WSSubject.doAs((Subject)MemberManagerStaffResolutionPlugin.this._currentConfig._subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(this){
                            private final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run() throws RemoteException, WMMException {
                                return 1.access$500(this.this$1).getGroupMembers(1.access$200(this.this$1), 1.access$300(this.this$1), 1.access$400(this.this$1));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof WMMException) {
                            throw (WMMException)exception;
                        }
                        if (exception instanceof RemoteException) {
                            throw (RemoteException)exception;
                        }
                        throw privilegedActionException;
                    }
                }

                static /* synthetic */ MemberIdentifier access$200(1 var0) {
                    return var0.memberIdentifier;
                }

                static /* synthetic */ GroupScope access$300(1 var0) {
                    return var0.groupScope;
                }

                static /* synthetic */ MemberTypeAttributeMap access$400(1 var0) {
                    return var0.memberTypeAttributeMap;
                }

                static /* synthetic */ MemberService access$500(1 var0) {
                    return var0.memberService;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof WMMException) {
                throw (WMMException)exception;
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw privilegedActionException;
        }
    }

    private synchronized Member getMember(final MemberIdentifier memberIdentifier, final StringSet stringSet, final MemberService memberService) throws RemoteException, WMMException, PrivilegedActionException {
        try {
            return (Member)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, WMMException, PrivilegedActionException {
                    try {
                        return (Member)WSSubject.doAs((Subject)MemberManagerStaffResolutionPlugin.this._currentConfig._subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run() throws RemoteException, WMMException {
                                return 3.access$800(this.this$1).getMember(3.access$600(this.this$1), 3.access$700(this.this$1));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof WMMException) {
                            throw (WMMException)exception;
                        }
                        if (exception instanceof RemoteException) {
                            throw (RemoteException)exception;
                        }
                        throw privilegedActionException;
                    }
                }

                static /* synthetic */ MemberIdentifier access$600(3 var0) {
                    return var0.memberIdentifier;
                }

                static /* synthetic */ StringSet access$700(3 var0) {
                    return var0.stringSet;
                }

                static /* synthetic */ MemberService access$800(3 var0) {
                    return var0.memberService;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof WMMException) {
                throw (WMMException)exception;
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw privilegedActionException;
        }
    }

    private synchronized Member getPersonByAccountName(final String string, final String string2, final StringSet stringSet, final MemberService memberService) throws RemoteException, WMMException, PrivilegedActionException {
        try {
            return (Member)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, WMMException, PrivilegedActionException {
                    try {
                        return (Member)WSSubject.doAs((Subject)MemberManagerStaffResolutionPlugin.this._currentConfig._subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run() throws RemoteException, WMMException {
                                return 5.access$1200(this.this$1).getPersonByAccountName(5.access$900(this.this$1), 5.access$1000(this.this$1), 5.access$1100(this.this$1));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof WMMException) {
                            throw (WMMException)exception;
                        }
                        if (exception instanceof RemoteException) {
                            throw (RemoteException)exception;
                        }
                        throw privilegedActionException;
                    }
                }

                static /* synthetic */ String access$900(5 var0) {
                    return var0.string;
                }

                static /* synthetic */ String access$1000(5 var0) {
                    return var0.string2;
                }

                static /* synthetic */ StringSet access$1100(5 var0) {
                    return var0.stringSet;
                }

                static /* synthetic */ MemberService access$1200(5 var0) {
                    return var0.memberService;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof WMMException) {
                throw (WMMException)exception;
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw privilegedActionException;
        }
    }

    private void initialize(ConfigurationParameters configurationParameters) throws ProcessException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object)configurationParameters);
        }
        if (configurationParameters == null) {
            if (this._currentConfig == null) {
                StaffPluginNoConfigurationParametersException staffPluginNoConfigurationParametersException = new StaffPluginNoConfigurationParametersException(null);
                throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginNoConfigurationParametersException);
            }
            configurationParameters = this._currentConfig;
            this._currentConfig = null;
            this._wmm = null;
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Relogin WMM access subject");
            }
            configurationParameters.reloginSubject();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", configurationParameters._contextFactory);
        try {
            String string;
            Object object;
            InitialContext initialContext;
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Initializing connection: " + hashtable));
            }
            if ((initialContext = new InitialContext(hashtable)) == null) {
                StaffPluginNoInitialContextException staffPluginNoInitialContextException = new StaffPluginNoInitialContextException(null);
                throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginNoInitialContextException);
            }
            if (TraceLog.isTracing) {
                object = configurationParameters._subject.getPrincipals().iterator();
                string = ((Object)object.next()).toString();
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(NEWLINE + "XXXX    contextFactory: " + configurationParameters._contextFactory + NEWLINE + "XXXX    wmmEJBHomeName: " + configurationParameters._wmmEJBHomeName + NEWLINE + "XXXX    principal name: " + string));
            }
            object = this.getWMMEJB(configurationParameters._subject, initialContext, configurationParameters._wmmEJBHomeName);
            System.out.println("    after lookup, before casting to wmmHome");
            string = (MemberServiceHome)PortableRemoteObject.narrow((Object)object, (Class)MemberServiceHome.class);
            this._wmm = this.createWMMHome(configurationParameters._subject, (MemberServiceHome)string);
            this._currentConfig = configurationParameters;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"initialize_1");
            throw new StaffPluginNotAvailableException(null, (Throwable)namingException);
        }
        catch (CreateException createException) {
            FFDCFilter.processException((Throwable)createException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"initialize_2");
            throw new StaffPluginNotAvailableException(null, (Throwable)createException);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"initialize_3");
            throw new StaffPluginNotAvailableException(null, (Throwable)remoteException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"initialize_4");
            throw new StaffPluginNotAvailableException(null, (Throwable)privilegedActionException);
        }
    }

    private MemberService createWMMHome(final Subject subject, final MemberServiceHome memberServiceHome) throws RemoteException, CreateException, PrivilegedActionException {
        try {
            return (MemberService)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, CreateException, PrivilegedActionException {
                    try {
                        return (MemberService)WSSubject.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(this){
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run() throws RemoteException, CreateException {
                                return 7.access$1600(this.this$1).create();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof CreateException) {
                            throw (CreateException)exception;
                        }
                        if (exception instanceof RemoteException) {
                            throw (RemoteException)exception;
                        }
                        throw privilegedActionException;
                    }
                }

                static /* synthetic */ MemberServiceHome access$1600(7 var0) {
                    return var0.memberServiceHome;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof CreateException) {
                throw (CreateException)((Object)exception);
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw privilegedActionException;
        }
    }

    private Object getWMMEJB(final Subject subject, final InitialContext initialContext, final String string) throws RemoteException, NamingException, PrivilegedActionException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, NamingException, PrivilegedActionException {
                    try {
                        return WSSubject.doAs((Subject)subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(this){
                            private final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run() throws RemoteException, NamingException, PrivilegedActionException {
                                return 9.access$1800(this.this$1).lookup(9.access$1700(this.this$1));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof NamingException) {
                            throw (NamingException)exception;
                        }
                        if (exception instanceof RemoteException) {
                            throw (RemoteException)exception;
                        }
                        throw privilegedActionException;
                    }
                }

                static /* synthetic */ String access$1700(9 var0) {
                    return var0.string;
                }

                static /* synthetic */ InitialContext access$1800(9 var0) {
                    return var0.initialContext;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw privilegedActionException;
        }
    }

    private void registerIntermediateResult(Set set, Map map, String string) {
        int n;
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{set, map, string});
        }
        if ((n = set.size()) == 0) {
            StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.EmptyIntermediateResult", (Object)string);
            map.put(string, null);
            return;
        }
        int n2 = 0;
        String[] stringArray = new String[n];
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            UserDataImpl userDataImpl = (UserDataImpl)iterator.next();
            stringArray[n2] = userDataImpl.getUserName();
            ++n2;
        }
        map.put(string, stringArray);
        if (TraceLog.isTracing) {
            TraceLog.exit((Object)map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void resolveMember(String var1_1, DeployedWMMStaffQuery.UserQuery var2_2, int var3_3, HashSet var4_4) throws ProcessException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{var1_1, var2_2, new Integer(var3_3), var4_4});
        }
        if (var4_4.size() >= var3_3) {
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)"Threshold reached");
            }
            return;
        }
        var5_5 = 0;
        while (true) {
            try {
                var6_6 = var2_2.getReturnTypes()[0];
                var7_9 /* !! */  = StringSetFactory.getInstance((int)1);
                var7_9 /* !! */ .add(var6_6.getAttribute());
                if (var2_2.getIDType() == 4) {
                    try {
                        if (TraceLog.isTracing) {
                            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(MemberManagerStaffResolutionPlugin.NEWLINE + "WMM method invokation:" + MemberManagerStaffResolutionPlugin.NEWLINE + "   method: getPersonByAccountName(id, realm, stringSet, _wmm)" + MemberManagerStaffResolutionPlugin.NEWLINE + "       id       : " + var1_1 + MemberManagerStaffResolutionPlugin.NEWLINE + "       stringSet: " + var7_9 /* !! */ ));
                        }
                        var8_10 = this.getPersonByAccountName(var1_1, null, var7_9 /* !! */ , this._wmm);
                        if (!TraceLog.isTracing) ** GOTO lbl71
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(MemberManagerStaffResolutionPlugin.NEWLINE + "WMM resulting member: " + var8_10 + MemberManagerStaffResolutionPlugin.NEWLINE));
                    }
                    catch (MemberNotFoundException var9_11) {
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("WMM member not found. id: " + var1_1 + MemberManagerStaffResolutionPlugin.NEWLINE + (Object)var9_11));
                        }
                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.MemberNotFound", (Object)var1_1, (Object)var9_11.getLocalizedMessage());
                        return;
                    }
                    catch (WMMApplicationException var9_12) {
                        FFDCFilter.processException((Throwable)var9_12, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMember_1");
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("WMM getPersonByAccountName input parameter error. query: " + var2_2 + MemberManagerStaffResolutionPlugin.NEWLINE + (Object)var9_12));
                        }
                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"getPersonByAccountName", var1_1, var9_12.getLocalizedMessage()});
                        return;
                    }
                    catch (PrivilegedActionException var9_13) {
                        FFDCFilter.processException((Throwable)var9_13, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMember_2");
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("Access denied to secured WMM EJB." + MemberManagerStaffResolutionPlugin.NEWLINE + var9_13));
                        }
                        var10_15 = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)var9_13);
                        throw new StaffPluginNotAvailableException(null, (Throwable)var10_15);
                    }
                } else {
                    var9_14 = null;
                    if (var2_2.getIDType() == 1) {
                        var9_14 = MemberIdentifierFactory.getInstance((String)var1_1, null);
                    } else if (var2_2.getIDType() == 3) {
                        var9_14 = MemberIdentifierFactory.getInstance(null, (String)var1_1);
                    } else {
                        throw new StaffPluginRuntimeException(new Object[]{"Internal error: invalid query id type."});
                    }
                    try {
                        if (TraceLog.isTracing) {
                            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(MemberManagerStaffResolutionPlugin.NEWLINE + "WMM method invocation:" + MemberManagerStaffResolutionPlugin.NEWLINE + "   method: getMember(memberID, stringSet, _wmm)" + MemberManagerStaffResolutionPlugin.NEWLINE + "       memberID : " + var9_14 + MemberManagerStaffResolutionPlugin.NEWLINE + "       stringSet: " + var7_9 /* !! */ ));
                        }
                        var8_10 = this.getMember(var9_14, var7_9 /* !! */ , this._wmm);
                        if (TraceLog.isTracing) {
                            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(MemberManagerStaffResolutionPlugin.NEWLINE + "WMM resulting member: " + var8_10 + MemberManagerStaffResolutionPlugin.NEWLINE));
                        }
                    }
                    catch (MemberNotFoundException var10_16) {
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("WMM member not found. id: " + var1_1 + MemberManagerStaffResolutionPlugin.NEWLINE + (Object)var10_16));
                        }
                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.MemberNotFound", (Object)var1_1, (Object)var10_16.getLocalizedMessage());
                        return;
                    }
                    catch (WMMApplicationException var10_17) {
                        FFDCFilter.processException((Throwable)var10_17, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMember_3");
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("WMM getMember input parameter error. query: " + var2_2 + MemberManagerStaffResolutionPlugin.NEWLINE + (Object)var10_17));
                        }
                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"getMember", var1_1, var10_17.getLocalizedMessage()});
                        return;
                    }
                    catch (PrivilegedActionException var10_18) {
                        FFDCFilter.processException((Throwable)var10_18, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMember_4");
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("Access denied to secured WMM EJB." + MemberManagerStaffResolutionPlugin.NEWLINE + var10_18));
                        }
                        var11_20 = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)var10_18);
                        throw new StaffPluginNotAvailableException(null, (Throwable)var11_20);
                    }
                }
lbl71:
                // 3 sources

                if (var8_10 == null) {
                    if (TraceLog.isTracing) {
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Member=null received: " + var1_1 + MemberManagerStaffResolutionPlugin.NEWLINE));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.MemberIsNullRcved", (Object)var1_1, (Object)"");
                }
                if ((var9_14 = var8_10.getAttribute(var6_6.getAttribute())) == null) {
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("Return attribute not found: " + var6_6.getAttribute() + MemberManagerStaffResolutionPlugin.NEWLINE));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.ReturnAttributeNotFound", (Object)var6_6.getAttribute(), (Object)"");
                    return;
                }
                var10_19 = var9_14.getValues();
                var11_21 = var10_19.iterator();
                while (var11_21.hasNext()) {
                    var12_22 = this.convertResultToString(var11_21.next());
                    var4_4.add(new UserDataImpl(var12_22, (Locale)null, (String)null));
                    if (var4_4.size() < var3_3) continue;
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)"Threshold reached");
                    }
                    return;
                }
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)var4_4);
                }
                return;
            }
            catch (WMMException var6_7) {
                if (var5_5 == 1) {
                    FFDCFilter.processException((Throwable)var6_7, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMember_5");
                    throw new StaffPluginNotAvailableException(null, (Throwable)var6_7);
                }
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Trying to reinitialize WMM session.");
                }
                var7_9 /* !! */  = this;
                synchronized (var7_9 /* !! */ ) {
                    this.initialize(null);
                }
                ++var5_5;
                continue;
            }
            catch (RemoteException var6_8) {
                if (var5_5 == 1) {
                    FFDCFilter.processException((Throwable)var6_8, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMember_6");
                    throw new StaffPluginNotAvailableException(null, (Throwable)var6_8);
                }
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Trying to reinitialize WMM session.");
                }
                var7_9 /* !! */  = this;
                synchronized (var7_9 /* !! */ ) {
                    this.initialize(null);
                }
                ++var5_5;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveMembersOfGroup(String string, DeployedWMMStaffQuery.UsersOfGroupQuery usersOfGroupQuery, int n, HashSet hashSet) throws ProcessException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{string, usersOfGroupQuery, new Integer(n), hashSet});
        }
        if (hashSet.size() >= n) {
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)"Threshold reached");
            }
            return;
        }
        int n2 = 0;
        while (true) {
            MemberManagerStaffResolutionPlugin memberManagerStaffResolutionPlugin;
            try {
                MemberSet memberSet;
                DeployedWMMStaffQuery.ReturnType returnType;
                MemberIdentifier memberIdentifier = null;
                if (usersOfGroupQuery.getIDType() == 1) {
                    memberIdentifier = MemberIdentifierFactory.getInstance((String)string, null);
                } else if (usersOfGroupQuery.getIDType() == 3) {
                    memberIdentifier = MemberIdentifierFactory.getInstance(null, (String)string);
                } else {
                    throw new StaffPluginRuntimeException(new Object[]{"Internal error: invalid query id type."});
                }
                memberManagerStaffResolutionPlugin = GroupScopeFactory.getInstance((short)(usersOfGroupQuery.isRecursive() ? (short)1 : 0));
                MemberTypeAttributeMap memberTypeAttributeMap = MemberTypeAttributeMapFactory.getInstance();
                int n3 = usersOfGroupQuery.getReturnTypes().length;
                for (int i = 0; i < n3; ++i) {
                    returnType = usersOfGroupQuery.getReturnTypes()[i];
                    memberTypeAttributeMap.addAttributeName(returnType.getType(), returnType.getAttribute());
                }
                try {
                    if (TraceLog.isTracing) {
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("WMM getGroupMembers invoked: getGroupMembers(groupId, scope, taMap, _wmm) groupId: " + memberIdentifier + "scope: " + memberManagerStaffResolutionPlugin + "taMap: " + memberTypeAttributeMap.toString() + NEWLINE));
                    }
                    memberSet = this.getGroupMembers(memberIdentifier, (GroupScope)memberManagerStaffResolutionPlugin, memberTypeAttributeMap, this._wmm);
                    if (TraceLog.isTracing) {
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("WMM resulting memberSet: " + memberSet + NEWLINE));
                    }
                }
                catch (MemberNotFoundException memberNotFoundException) {
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("WMM getGroupMembers input parameter error. query: " + usersOfGroupQuery + NEWLINE + (Object)((Object)memberNotFoundException)));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"getGroupMembers", memberIdentifier, memberNotFoundException.getLocalizedMessage()});
                    return;
                }
                catch (WMMApplicationException wMMApplicationException) {
                    FFDCFilter.processException((Throwable)wMMApplicationException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMembersOfGroup_1");
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("WMM getGroupMembers input parameter error. query: " + usersOfGroupQuery + NEWLINE + (Object)((Object)wMMApplicationException)));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"getGroupMembers", memberIdentifier, wMMApplicationException.getLocalizedMessage()});
                    return;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMembersOfGroup_2");
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("Access denied to secured WMM EJB." + NEWLINE + privilegedActionException));
                    }
                    StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)privilegedActionException);
                    throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
                }
                if (memberSet == null) {
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("MemberSet is NULL received " + NEWLINE));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.MemberSetIsNullRcved", (Object)"", (Object)"");
                }
                returnType = memberSet.iterator();
                while (returnType.hasNext()) {
                    Member member = returnType.next();
                    Attribute attribute = null;
                    short s = member.getMemberType();
                    DeployedWMMStaffQuery.ReturnType returnType2 = null;
                    for (int i = 0; i < n3; ++i) {
                        returnType2 = usersOfGroupQuery.getReturnTypes()[i];
                        if (returnType2.getType() != s) continue;
                        attribute = member.getAttribute(returnType2.getAttribute());
                    }
                    if (attribute == null) {
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("Return attribute not found: " + returnType2.getAttribute() + NEWLINE));
                        }
                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.ReturnAttributeNotFound", (Object)returnType2.getAttribute(), (Object)"");
                        return;
                    }
                    List list = attribute.getValues();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String string2 = this.convertResultToString(iterator.next());
                        hashSet.add(new UserDataImpl(string2, (Locale)null, (String)null));
                        if (hashSet.size() < n) continue;
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)"Threshold reached");
                        }
                        return;
                    }
                }
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)hashSet);
                }
                return;
            }
            catch (WMMException wMMException) {
                if (n2 == 1) {
                    FFDCFilter.processException((Throwable)wMMException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMembersOfGroup_3");
                    throw new StaffPluginNotAvailableException(null, (Throwable)wMMException);
                }
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Trying to reinitialize WMM session.");
                }
                memberManagerStaffResolutionPlugin = this;
                synchronized (memberManagerStaffResolutionPlugin) {
                    this.initialize(null);
                }
                ++n2;
                continue;
            }
            catch (RemoteException remoteException) {
                if (n2 == 1) {
                    FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"resolveMembersOfGroup_4");
                    throw new StaffPluginNotAvailableException(null, (Throwable)remoteException);
                }
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Trying to reinitialize WMM session.");
                }
                memberManagerStaffResolutionPlugin = this;
                synchronized (memberManagerStaffResolutionPlugin) {
                    this.initialize(null);
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaffQueryResult resolveStaff(DeployedStaffQuery deployedStaffQuery, Map map) throws ProcessException {
        StaffQueryResultImpl staffQueryResultImpl;
        int n;
        if (TraceLog.isTracing) {
            TraceLog.entry((Object)deployedStaffQuery, (Object)map);
        }
        if ((n = ((DeployedWMMStaffQuery)deployedStaffQuery).getType()) == 1) {
            StaffQueryResultImpl staffQueryResultImpl2 = new StaffQueryResultImpl((Collection)null, null, n);
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)staffQueryResultImpl2);
            }
            return staffQueryResultImpl2;
        }
        if (n == 0) {
            StaffQueryResultImpl staffQueryResultImpl3 = new StaffQueryResultImpl((Collection)null, null, n);
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)staffQueryResultImpl3);
            }
            return staffQueryResultImpl3;
        }
        HashSet hashSet = this;
        synchronized (hashSet) {
            if (this._wmm == null) {
                this.start();
            }
        }
        hashSet = new HashSet(100);
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet2 = new HashSet<String>();
        DeployedWMMStaffQuery.WMMQuery[] wMMQueryArray = ((DeployedWMMStaffQuery)deployedStaffQuery).getQueries();
        int n2 = ((DeployedWMMStaffQuery)deployedStaffQuery).getThreshold();
        if (((DeployedWMMStaffQuery)deployedStaffQuery).getType() == 3) {
            for (int i = 0; i < wMMQueryArray.length; ++i) {
                int n3;
                DeployedWMMStaffQuery.ReusableQuery reusableQuery;
                DeployedWMMStaffQuery.WMMQuery wMMQuery = wMMQueryArray[i];
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing query no. " + i + " :" + NEWLINE + wMMQuery));
                }
                if (wMMQuery instanceof DeployedWMMStaffQuery.UserIDQuery) {
                    MemberManagerStaffResolutionPlugin.repalecement4StaffpluginUtil_processUserID(((DeployedWMMStaffQuery.UserIDQuery)wMMQuery).getUserID(), hashSet, map, n2);
                    continue;
                }
                if (!(wMMQuery instanceof DeployedWMMStaffQuery.ReusableQuery)) continue;
                int n4 = ((DeployedWMMStaffQuery.ReusableQuery)wMMQuery).getIntermediateResultThreshold();
                HashSet hashSet3 = ((DeployedWMMStaffQuery.ReusableQuery)wMMQuery).isIntermediateResult() ? new HashSet(100) : hashSet;
                if (wMMQuery instanceof DeployedWMMStaffQuery.SearchQuery) {
                    reusableQuery = (DeployedWMMStaffQuery.SearchQuery)wMMQuery;
                    int n5 = reusableQuery.isIntermediateResult() && n4 > 0 ? n4 : n2;
                    this.search(map, hashMap, n5, (DeployedWMMStaffQuery.SearchQuery)reusableQuery, hashSet3);
                    if (!reusableQuery.isIntermediateResult()) continue;
                    this.registerIntermediateResult(hashSet3, hashMap, reusableQuery.getResultName());
                    continue;
                }
                if (wMMQuery instanceof DeployedWMMStaffQuery.UserQuery) {
                    reusableQuery = (DeployedWMMStaffQuery.UserQuery)wMMQuery;
                    String[] stringArray = StaffPluginUtil.replaceVariables((String)((DeployedWMMStaffQuery.UserQuery)reusableQuery).getID(), (Map)map, hashMap);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (reusableQuery.isIntermediateResult() && n4 > 0) {
                            this.resolveMember(stringArray[n3], (DeployedWMMStaffQuery.UserQuery)reusableQuery, n4, hashSet3);
                            continue;
                        }
                        this.resolveMember(stringArray[n3], (DeployedWMMStaffQuery.UserQuery)reusableQuery, n2, hashSet3);
                    }
                    if (!reusableQuery.isIntermediateResult()) continue;
                    this.registerIntermediateResult(hashSet3, hashMap, reusableQuery.getResultName());
                    continue;
                }
                if (wMMQuery instanceof DeployedWMMStaffQuery.UsersOfGroupQuery) {
                    reusableQuery = (DeployedWMMStaffQuery.UsersOfGroupQuery)wMMQuery;
                    String[] stringArray = StaffPluginUtil.replaceVariables((String)((DeployedWMMStaffQuery.UsersOfGroupQuery)reusableQuery).getGroupID(), (Map)map, hashMap);
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (reusableQuery.isIntermediateResult() && n4 > 0) {
                            this.resolveMembersOfGroup(stringArray[n3], (DeployedWMMStaffQuery.UsersOfGroupQuery)reusableQuery, n4, hashSet3);
                            continue;
                        }
                        this.resolveMembersOfGroup(stringArray[n3], (DeployedWMMStaffQuery.UsersOfGroupQuery)reusableQuery, n2, hashSet3);
                    }
                    if (!reusableQuery.isIntermediateResult()) continue;
                    this.registerIntermediateResult(hashSet3, hashMap, reusableQuery.getResultName());
                    continue;
                }
                if (!(wMMQuery instanceof DeployedWMMStaffQuery.RemoveQuery)) continue;
                reusableQuery = (DeployedWMMStaffQuery.RemoveQuery)wMMQuery;
                String[] stringArray = ((DeployedWMMStaffQuery.RemoveQuery)reusableQuery).getValue().split(",");
                n3 = stringArray.length;
                for (int j = 0; j < n3; ++j) {
                    String[] stringArray2 = StaffPluginUtil.replaceVariables((String)stringArray[j], (Map)map, hashMap);
                    for (int k = 0; k < stringArray2.length; ++k) {
                        String string = stringArray2[k].trim();
                        hashSet3.remove(string);
                        if (TraceLog.isTracing) {
                            TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("value to remove: " + string));
                        }
                        if (reusableQuery.isIntermediateResult()) continue;
                        hashSet2.add(string);
                    }
                }
                if (!reusableQuery.isIntermediateResult()) continue;
                this.registerIntermediateResult(hashSet3, hashMap, reusableQuery.getResultName());
            }
            staffQueryResultImpl = new StaffQueryResultImpl((Collection)hashSet, (String)null, 3);
        } else if (((DeployedWMMStaffQuery)deployedStaffQuery).getType() == 4) {
            String string;
            String[] stringArray;
            DeployedWMMStaffQuery.GroupIDQuery groupIDQuery = (DeployedWMMStaffQuery.GroupIDQuery)wMMQueryArray[0];
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("Processing groupid query:" + NEWLINE + groupIDQuery));
            }
            if ((stringArray = StaffPluginUtil.replaceVariables((String)(string = groupIDQuery.getGroupID()), (Map)map, null)).length > 1) {
                throw new StaffPluginMultiValueNotSupportedException(new Object[]{"groupID"});
            }
            staffQueryResultImpl = stringArray.length < 1 ? new StaffQueryResultImpl((Collection)null, (String)null, 0) : new StaffQueryResultImpl((Collection)null, stringArray[0], 4);
        } else {
            throw new StaffPluginRuntimeException(new Object[]{"Internal error."});
        }
        if (map != null) {
            map.put("HTM_REMOVED_USERS", hashSet2.toArray(new String[hashSet2.size()]));
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("removed users: " + hashSet2));
            }
            if (hashMap != null) {
                map.putAll(hashMap);
            }
            if (TraceLog.isTracing) {
                TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("added intermediate results to context map: " + hashMap));
            }
        }
        if (TraceLog.isTracing) {
            TraceLog.exit((Object)staffQueryResultImpl);
        }
        return staffQueryResultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Map map, Map map2, int n, DeployedWMMStaffQuery.SearchQuery searchQuery, HashSet hashSet) throws ProcessException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object[])new Object[]{map, searchQuery, new Integer(n), hashSet});
        }
        if (hashSet.size() >= n) {
            if (TraceLog.isTracing) {
                TraceLog.exit((Object)"Threshold reached");
            }
            return;
        }
        int n2 = 0;
        while (true) {
            Object object;
            try {
                MemberSet memberSet;
                Object object2;
                Iterator iterator;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                AttributeSearchConditions attributeSearchConditions;
                DeployedWMMStaffQuery.SearchAttribute searchAttribute;
                short s;
                Object object7;
                DeployedWMMStaffQuery.ReturnType returnType = searchQuery.getReturnTypes()[0];
                object = returnType.getAttribute();
                String string = null;
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)("WMM search: deployed result attribute name" + (String)object));
                }
                if (((String)object).equals("_DN")) {
                    if (TraceLog.isTracing) {
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"WMM search: _DN expected as search result");
                    }
                    if (searchQuery.getSearchAttributes().length > 0) {
                        object7 = searchQuery.getSearchAttributes()[0];
                        object = ((DeployedWMMStaffQuery.SearchAttribute)object7).getName();
                        string = "_DN";
                    }
                }
                object7 = StringSetFactory.getInstance((int)1);
                object7.add((String)object);
                GroupScope groupScope = null;
                MemberTypeAttributeMap memberTypeAttributeMap = null;
                if (returnType.getType() == 2000) {
                    s = 1;
                    groupScope = GroupScopeFactory.getInstance((short)1);
                    memberTypeAttributeMap = MemberTypeAttributeMapFactory.getInstance();
                    memberTypeAttributeMap.addAttributeName((short)0, (String)object);
                } else {
                    s = returnType.getType();
                }
                int n3 = searchQuery.getTimeout() > 0 ? searchQuery.getTimeout() : this._currentConfig._timeout;
                SearchCriteria searchCriteria = SearchCriteriaFactory.getInstance();
                String string2 = searchQuery.getSearchBase();
                StringSet stringSet = null;
                if (string2 != null) {
                    stringSet = StringSetFactory.getInstance((int)1);
                    stringSet.add(string2);
                    searchCriteria.setSearchBases(stringSet);
                }
                for (int i = 0; i < searchQuery.getSearchAttributes().length; ++i) {
                    searchAttribute = searchQuery.getSearchAttributes()[i];
                    attributeSearchConditions = AttributeSearchConditionsFactory.getInstance((String)searchAttribute.getName());
                    int n4 = searchAttribute.getConditionSequence().length;
                    for (int j = 0; j < n4; ++j) {
                        object6 = searchAttribute.getConditionSequence()[j];
                        if (object6 instanceof Short) {
                            attributeSearchConditions.addLogicalOperator((Short)object6);
                            continue;
                        }
                        if (object6 instanceof DeployedWMMStaffQuery.Condition) {
                            object5 = (DeployedWMMStaffQuery.Condition)object6;
                            object4 = StaffPluginUtil.replaceVariables((String)((DeployedWMMStaffQuery.Condition)object5).getReferenceValue(), (Map)map, (Map)map2);
                            if (((String[])object4).length != 1) {
                                throw new StaffPluginMultiValueNotSupportedException(new Object[]{"returnAttribute"});
                            }
                            object3 = object4[0];
                            switch (((DeployedWMMStaffQuery.Condition)object5).getReferenceType()) {
                                case 5: {
                                    try {
                                        iterator = new Double((String)object3);
                                        break;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_1");
                                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.TypeConversion", new Object[]{object3, "Double", numberFormatException.getLocalizedMessage()});
                                        return;
                                    }
                                }
                                case 4: {
                                    try {
                                        iterator = new Integer((String)object3);
                                        break;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_2");
                                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.TypeConversion", new Object[]{object3, "Integer", numberFormatException.getLocalizedMessage()});
                                        return;
                                    }
                                }
                                case 3: {
                                    try {
                                        iterator = new Long((String)object3);
                                        break;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_3");
                                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.TypeConversion", new Object[]{object3, "Long", numberFormatException.getLocalizedMessage()});
                                        return;
                                    }
                                }
                                case 1: {
                                    iterator = object3;
                                    break;
                                }
                                case 2: {
                                    try {
                                        iterator = Timestamp.valueOf((String)object3);
                                        break;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_4");
                                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.TypeConversion", new Object[]{object3, "Timestamp", illegalArgumentException.getLocalizedMessage()});
                                        return;
                                    }
                                }
                                case 6: {
                                    iterator = MemberIdentifierFactory.getInstance((String)object3, null);
                                    break;
                                }
                                default: {
                                    throw new StaffPluginRuntimeException(new Object[]{"Internal error: Invalid referenceType for search attribute: " + searchAttribute.getName()});
                                }
                            }
                            object2 = SearchConditionFactory.getInstance((short)((DeployedWMMStaffQuery.Condition)object5).getOperator(), (Object)iterator);
                            attributeSearchConditions.addSearchCondition(object2);
                            continue;
                        }
                        throw new StaffPluginRuntimeException(new Object[]{"Internal error: Invalid condition sequence member type."});
                    }
                    searchCriteria.addAttributeSearchConditions(attributeSearchConditions);
                }
                try {
                    if (TraceLog.isTracing) {
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(NEWLINE + "WMM method invokation:" + NEWLINE + "   method: search(memberType, searchCriteria, resultAttributes, timeout, 0, _wmm)" + NEWLINE + "       memberType    : " + s + NEWLINE + "       searchCriteria: " + searchCriteria + NEWLINE + "       resultAttributes: " + object7));
                    }
                    memberSet = this.search(s, searchCriteria, (StringSet)object7, n3, 0, this._wmm);
                    if (TraceLog.isTracing) {
                        TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)(NEWLINE + "WMM resulting memberSet: " + memberSet + NEWLINE));
                    }
                }
                catch (MemberNotFoundException memberNotFoundException) {
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("WMM search input parameter error. query: " + searchQuery + NEWLINE + (Object)((Object)memberNotFoundException)));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"search", searchQuery.toString(), memberNotFoundException.getLocalizedMessage()});
                    return;
                }
                catch (WMMApplicationException wMMApplicationException) {
                    FFDCFilter.processException((Throwable)wMMApplicationException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_5");
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("WMM search input parameter error. query: " + searchQuery + NEWLINE + (Object)((Object)wMMApplicationException)));
                    }
                    StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"search", searchQuery.toString(), wMMApplicationException.getLocalizedMessage()});
                    return;
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_5");
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)("Access denied to secured WMM EJB." + NEWLINE + privilegedActionException));
                    }
                    attributeSearchConditions = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)privilegedActionException);
                    throw new StaffPluginNotAvailableException(null, (Throwable)attributeSearchConditions);
                }
                searchAttribute = memberSet.iterator();
                while (searchAttribute.hasNext()) {
                    Attribute attribute;
                    attributeSearchConditions = searchAttribute.next();
                    if (returnType.getType() != 2000) {
                        if (returnType.getType() == attributeSearchConditions.getMemberType()) {
                            if (string != null && string.equals("_DN")) {
                                attribute = AttributeFactory.getInstance((String)"_DN");
                                attribute.setValue((Object)attributeSearchConditions.getMemberIdentifier().getMemberDN());
                            } else {
                                attribute = attributeSearchConditions.getAttribute((String)object);
                            }
                        } else {
                            throw new StaffPluginRuntimeException(new Object[]{"Internal error: Unsolicited WMM object returned. Returned type: " + attributeSearchConditions.getMemberType() + " Requested type: " + returnType.getType()});
                        }
                        if (attribute == null) {
                            if (TraceLog.isTracing) {
                                TraceLog.exit((Object)("Return attribute not found: " + returnType.getAttribute() + NEWLINE));
                            }
                            StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.ReturnAttributeNotFound", (Object)returnType.getAttribute(), (Object)"");
                            return;
                        }
                        object6 = attribute.getValues();
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            object4 = this.convertResultToString(object5.next());
                            hashSet.add(new UserDataImpl((String)object4, (Locale)null, (String)null));
                            if (hashSet.size() < n) continue;
                            if (TraceLog.isTracing) {
                                TraceLog.exit((Object)"Threshold reached");
                            }
                            return;
                        }
                        continue;
                    }
                    if (attributeSearchConditions.getMemberType() != 1) {
                        throw new StaffPluginRuntimeException(new Object[]{"Internal error: Unsolicited WMM object returned. Returned type: " + attributeSearchConditions.getMemberType() + " Requested type: group"});
                    }
                    try {
                        object6 = this.getGroupMembers(attributeSearchConditions.getMemberIdentifier(), groupScope, memberTypeAttributeMap, this._wmm);
                    }
                    catch (WMMApplicationException wMMApplicationException) {
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("WMM getGroupMembers following search input parameter error. query: " + searchQuery + NEWLINE + (Object)((Object)wMMApplicationException)));
                        }
                        StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.WMMAPIError", new Object[]{"getGroupMembers/(search)", attributeSearchConditions.getMemberIdentifier().getMemberDN(), wMMApplicationException.getLocalizedMessage()});
                        continue;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_6");
                        if (TraceLog.isTracing) {
                            TraceLog.exit((Object)("Access denied to secured WMM EJB." + NEWLINE + privilegedActionException));
                        }
                        object4 = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)privilegedActionException);
                        throw new StaffPluginNotAvailableException(null, (Throwable)object4);
                    }
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        object4 = object5.next();
                        if (string != null && string.equals("_DN")) {
                            attribute = AttributeFactory.getInstance((String)"_DN");
                            attribute.setValue((Object)object4.getMemberIdentifier().getMemberDN());
                        } else {
                            attribute = object4.getAttribute((String)object);
                        }
                        if (attribute == null) {
                            if (TraceLog.isTracing) {
                                TraceLog.exit((Object)("Return attribute not found: " + returnType.getAttribute() + NEWLINE));
                            }
                            StaffPluginUtil._messageLogger.message(MessageLogger.TYPE_WARNING, "StaffPlugin.ReturnAttributeNotFound", (Object)returnType.getAttribute(), (Object)"");
                            return;
                        }
                        object3 = attribute.getValues();
                        iterator = object3.iterator();
                        while (iterator.hasNext()) {
                            object2 = this.convertResultToString(iterator.next());
                            hashSet.add(new UserDataImpl((String)object2, (Locale)null, (String)null));
                            if (hashSet.size() < n) continue;
                            if (TraceLog.isTracing) {
                                TraceLog.exit((Object)"Threshold reached");
                            }
                            return;
                        }
                    }
                }
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)hashSet);
                }
                return;
            }
            catch (WMMException wMMException) {
                if (n2 == 1) {
                    FFDCFilter.processException((Throwable)wMMException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_7");
                    throw new StaffPluginNotAvailableException(null, (Throwable)wMMException);
                }
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Trying to reinitialize WMM session.");
                }
                object = this;
                synchronized (object) {
                    this.initialize(null);
                }
                ++n2;
                continue;
            }
            catch (RemoteException remoteException) {
                if (n2 == 1) {
                    FFDCFilter.processException((Throwable)remoteException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"search_8");
                    throw new StaffPluginNotAvailableException(null, (Throwable)remoteException);
                }
                if (TraceLog.isTracing) {
                    TraceLog.trace((TraceEventType)TraceLogger.TYPE_DEBUG, (String)"Trying to reinitialize WMM session.");
                }
                object = this;
                synchronized (object) {
                    this.initialize(null);
                }
                ++n2;
                continue;
            }
            break;
        }
    }

    private synchronized MemberSet search(final short s, final SearchCriteria searchCriteria, final StringSet stringSet, final int n, final int n2, final MemberService memberService) throws RemoteException, WMMException, PrivilegedActionException {
        try {
            return (MemberSet)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException, WMMException, PrivilegedActionException {
                    try {
                        return (MemberSet)WSSubject.doAs((Subject)MemberManagerStaffResolutionPlugin.this._currentConfig._subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(this){
                            private final /* synthetic */ 11 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public Object run() throws RemoteException, WMMException {
                                return 11.access$2500(this.this$1).search(11.access$2000(this.this$1), 11.access$2100(this.this$1), 11.access$2200(this.this$1), 11.access$2300(this.this$1), 11.access$2400(this.this$1));
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof WMMException) {
                            throw (WMMException)exception;
                        }
                        if (exception instanceof RemoteException) {
                            throw (RemoteException)exception;
                        }
                        throw privilegedActionException;
                    }
                }

                static /* synthetic */ short access$2000(11 var0) {
                    return var0.s;
                }

                static /* synthetic */ SearchCriteria access$2100(11 var0) {
                    return var0.searchCriteria;
                }

                static /* synthetic */ StringSet access$2200(11 var0) {
                    return var0.stringSet;
                }

                static /* synthetic */ int access$2300(11 var0) {
                    return var0.n;
                }

                static /* synthetic */ int access$2400(11 var0) {
                    return var0.n2;
                }

                static /* synthetic */ MemberService access$2500(11 var0) {
                    return var0.memberService;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof WMMException) {
                throw (WMMException)((Object)exception);
            }
            if (exception instanceof RemoteException) {
                throw (RemoteException)exception;
            }
            throw privilegedActionException;
        }
    }

    public synchronized void setAuthenticationAlias(String string) {
        this._authenticationAlias = string;
    }

    public synchronized void setContextFactory(String string) {
        this._contextFactory = string;
    }

    public synchronized void setProviderURL(String string) {
        this._providerURL = string;
    }

    public synchronized void setDefaultSearchTimeout(String string) {
        this._timeout = string;
    }

    public synchronized void setWMMEJBHomeName(String string) {
        this._wmmEJBHomeName = string;
    }

    private void start() throws ProcessException {
        if (TraceLog.isTracing) {
            TraceLog.entry();
        }
        ConfigurationParameters configurationParameters = new ConfigurationParameters(this._contextFactory, this._providerURL, this._timeout, this._wmmEJBHomeName, this._authenticationAlias);
        this.initialize(configurationParameters);
    }

    public static void repalecement4StaffpluginUtil_processUserID(String string, HashSet hashSet, Map map, int n) throws ProcessException {
        if (TraceLog.isTracing) {
            TraceLog.entry((Object)string);
        }
        String[] stringArray = StaffPluginUtil.replaceVariables((String)string, (Map)map, null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (hashSet.size() >= n) {
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)"threshold reached");
                }
                return;
            }
            String string2 = stringArray[i].trim();
            if (string2 == null || string2.startsWith("%") && string2.endsWith("%")) continue;
            String string3 = stringArray[i];
            hashSet.add(new UserDataImpl(string3, (Locale)null, (String)null));
        }
    }

    private static final class ConfigurationParameters {
        public static final String COPYRIGHT = "(C) Copyright IBM Corporation 2001, 2006.";
        private String _contextFactory;
        private String _providerURL;
        private Subject _subject;
        private int _timeout;
        private String _wmmEJBHomeName;
        private LoginContext _loginContext = null;

        private ConfigurationParameters(String string, String string2, String string3, String string4, String string5) throws ProcessException {
            if (TraceLog.isTracing) {
                TraceLog.entry((Object[])new Object[]{string, string2, string3, string4, string5});
            }
            if (string == null) {
                this._contextFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
            } else {
                if (string.length() == 0) {
                    throw new IllegalArgumentException("contextFactory.length() == 0");
                }
                this._contextFactory = string;
            }
            if (string2 == null) {
                this._providerURL = "iiop://localhost:2809";
            } else {
                if (string2.length() == 0) {
                    throw new IllegalArgumentException("providerURL.length() == 0");
                }
                this._providerURL = string2;
            }
            if (string3 == null) {
                this._timeout = 10000;
            } else {
                if (string3.length() == 0) {
                    throw new IllegalArgumentException("timeout.length() == 0");
                }
                try {
                    this._timeout = Integer.parseInt(string3);
                    if (this._timeout <= 0) {
                        throw new StaffPluginInvalidAttributeValueException(new Object[]{"timeout", "1 ... 2147483647"});
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"ConfigurationParameters_1");
                    throw new StaffPluginInvalidAttributeValueException(new Object[]{"timeout", "1 ... 2147483647"}, (Throwable)numberFormatException);
                }
            }
            if (string4 == null) {
                this._wmmEJBHomeName = "ejb/MemberServiceHome";
            } else {
                if (string4.length() == 0) {
                    throw new IllegalArgumentException("wmmEJBHomeName.length() == 0");
                }
                this._wmmEJBHomeName = string4;
            }
            if (string5 == null) {
                throw new IllegalArgumentException("authenticationAlias == null");
            }
            this._subject = null;
            AuthData authData = null;
            LoginContext loginContext = null;
            try {
                authData = this.getAuthenticationAlias(string5);
                loginContext = this.getLoginContext("WSLogin", (CallbackHandler)new WSCallbackHandlerImpl(authData.uid, authData.psw));
                if (loginContext == null) {
                    StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(new Object[]{"loginContext == null"});
                    throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
                }
                loginContext.login();
                this._loginContext = loginContext;
                this._subject = loginContext.getSubject();
            }
            catch (AccessControlException accessControlException) {
                FFDCFilter.processException((Throwable)accessControlException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"ConfigurationParameters_1.1");
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)("Could not retrieve authentication alias for WMM access, alias name is: " + string5 + NEWLINE + accessControlException));
                }
                StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)accessControlException);
                throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
            }
            catch (LoginException loginException) {
                FFDCFilter.processException((Throwable)loginException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"ConfigurationParameters_2");
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)("Could not login WMM EJB access user: " + authData.uid + NEWLINE + loginException));
                }
                StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)loginException);
                throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"ConfigurationParameters_1.2");
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)("Could not retrieve authentication alias for WMM access, alias name is: " + string5 + NEWLINE + privilegedActionException));
                }
                StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(null, (Throwable)privilegedActionException);
                throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
            }
        }

        private void reloginSubject() throws ProcessException {
            try {
                if (this._loginContext == null) {
                    if (TraceLog.isTracing) {
                        TraceLog.exit((Object)"Could not relogin subject, login context is not available ");
                    }
                    StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(new Object[]{"loginContext == null"});
                    throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
                }
                this._loginContext.login();
                this._subject = this._loginContext.getSubject();
            }
            catch (LoginException loginException) {
                FFDCFilter.processException((Throwable)loginException, (String)"com.ibm.bpe.staff.MemberManagerStaffResolutionPlugin", (String)"ConfigurationParameters_2");
                if (TraceLog.isTracing) {
                    TraceLog.exit((Object)"Could not relogin WMM subject");
                }
                StaffPluginCannotAccessWMMEJBException staffPluginCannotAccessWMMEJBException = new StaffPluginCannotAccessWMMEJBException(new Object[]{"Could not relogin WMM subject"});
                throw new StaffPluginNotAvailableException(null, (Throwable)staffPluginCannotAccessWMMEJBException);
            }
        }

        private AuthData getAuthenticationAlias(String string) throws AccessControlException, PrivilegedActionException {
            try {
                return (AuthData)AccessController.doPrivileged(new PrivilegedExceptionAction(this, string){
                    private final /* synthetic */ String val$authenticationAlias;
                    private final /* synthetic */ ConfigurationParameters this$0;
                    {
                        this.this$0 = configurationParameters;
                        this.val$authenticationAlias = string;
                    }

                    public Object run() {
                        return WSDefaultPrincipalMapping.getAuthDataInt((String)this.val$authenticationAlias);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof AccessControlException) {
                    throw (AccessControlException)exception;
                }
                throw privilegedActionException;
            }
        }

        private LoginContext getLoginContext(String string, CallbackHandler callbackHandler) throws LoginException, PrivilegedActionException {
            try {
                return (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction(this, string, callbackHandler){
                    private final /* synthetic */ String val$loginName;
                    private final /* synthetic */ CallbackHandler val$callbackHandler;
                    private final /* synthetic */ ConfigurationParameters this$0;
                    {
                        this.this$0 = configurationParameters;
                        this.val$loginName = string;
                        this.val$callbackHandler = callbackHandler;
                    }

                    public Object run() throws LoginException {
                        return new LoginContext(this.val$loginName, this.val$callbackHandler);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof LoginException) {
                    throw (LoginException)exception;
                }
                throw privilegedActionException;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(NEWLINE + "ConfigurationParameters object content:" + NEWLINE);
            stringBuffer.append("Context factory: ").append(this._contextFactory).append(NEWLINE);
            stringBuffer.append("Provider URL: ").append(this._providerURL).append(NEWLINE);
            stringBuffer.append("Default search timeout: ").append(this._timeout).append(NEWLINE);
            stringBuffer.append("WMM EJB home name: ").append(this._wmmEJBHomeName).append(NEWLINE);
            stringBuffer.append("WMM EJB access subject: ").append(this._subject.getPrincipals()).append(NEWLINE);
            stringBuffer.append("End ConfigurationParameters object content." + NEWLINE);
            return stringBuffer.toString();
        }
    }
}

